/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.ClassUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.DiskStoreDetails;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.DescribeDiskStoreFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DescribeDiskStoreCommand
implements GfshCommand {
    @CliCommand(value={"describe disk-store"}, help="Display information about a member's disk store.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeDiskStore(@CliOption(key={"member"}, mandatory=true, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member with the disk store to be described.") String memberName, @CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.cluster.diskstore:disable-string-converter", help="Name of the disk store to be described.") String diskStoreName) {
        return this.toCompositeResult(this.getDiskStoreDescription(memberName, diskStoreName));
    }

    DiskStoreDetails getDiskStoreDescription(String memberName, String diskStoreName) {
        Throwable cause;
        DistributedMember member = this.getMember(memberName);
        ResultCollector resultCollector = this.getMembersFunctionExecutor(Collections.singleton(member)).setArguments(diskStoreName).execute(new DescribeDiskStoreFunction());
        Object result = ((List)resultCollector.getResult()).get(0);
        if (result instanceof DiskStoreDetails) {
            return (DiskStoreDetails)result;
        }
        if (result instanceof EntityNotFoundException) {
            throw (EntityNotFoundException)result;
        }
        Throwable throwable = cause = result instanceof Throwable ? (Throwable)result : null;
        if (this.isLogging()) {
            if (cause != null) {
                this.getGfsh().logSevere(String.format("Exception (%1$s) occurred while executing '%2$s' on member (%3$s) with disk store (%4$s).", ClassUtils.getClassName(cause), "describe disk-store", memberName, diskStoreName), cause);
            } else {
                this.getGfsh().logSevere(String.format("Received an unexpected result of type (%1$s) while executing '%2$s' on member (%3$s) with disk store (%4$s).", ClassUtils.getClassName(result), "describe disk-store", memberName, diskStoreName), null);
            }
        }
        throw new RuntimeException(CliStrings.format("Received an unexpected return type ({0}) while executing command {1}.", ClassUtils.getClassName(result), "describe disk-store"), cause);
    }

    private Result toCompositeResult(DiskStoreDetails diskStoreDetails) {
        CompositeResultData diskStoreData = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData diskStoreSection = diskStoreData.addSection();
        diskStoreSection.addData("Disk Store ID", diskStoreDetails.getId());
        diskStoreSection.addData("Disk Store Name", diskStoreDetails.getName());
        diskStoreSection.addData("Member ID", diskStoreDetails.getMemberId());
        diskStoreSection.addData("Member Name", diskStoreDetails.getMemberName());
        diskStoreSection.addData("Allow Force Compaction", diskStoreDetails.isAllowForceCompaction() ? "Yes" : "No");
        diskStoreSection.addData("Auto Compaction", diskStoreDetails.isAutoCompact() ? "Yes" : "No");
        diskStoreSection.addData("Compaction Threshold", diskStoreDetails.getCompactionThreshold());
        diskStoreSection.addData("Max Oplog Size", diskStoreDetails.getMaxOplogSize());
        diskStoreSection.addData("Queue Size", diskStoreDetails.getQueueSize());
        diskStoreSection.addData("Time Interval", diskStoreDetails.getTimeInterval());
        diskStoreSection.addData("Write Buffer Size", diskStoreDetails.getWriteBufferSize());
        diskStoreSection.addData("Disk Usage Warning Percentage", diskStoreDetails.getDiskUsageWarningPercentage());
        diskStoreSection.addData("Disk Usage Critical Percentage", diskStoreDetails.getDiskUsageCriticalPercentage());
        diskStoreSection.addData("PDX Serialization Meta-Data Stored", diskStoreDetails.isPdxSerializationMetaDataStored() ? "Yes" : "No");
        TabularResultData diskDirTable = diskStoreData.addSection().addTable();
        for (Object diskDirDetails : diskStoreDetails) {
            diskDirTable.accumulate("Disk Directory", ((DiskStoreDetails.DiskDirDetails)diskDirDetails).getAbsolutePath());
            diskDirTable.accumulate("Size", ((DiskStoreDetails.DiskDirDetails)diskDirDetails).getSize());
        }
        TabularResultData regionTable = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.RegionDetails regionDetails : diskStoreDetails.iterateRegions()) {
            regionTable.accumulate("Region Path", regionDetails.getFullPath());
            regionTable.accumulate("Region Name", regionDetails.getName());
            regionTable.accumulate("Persistent", regionDetails.isPersistent() ? "Yes" : "No");
            regionTable.accumulate("Overflow To Disk", regionDetails.isOverflowToDisk() ? "Yes" : "No");
        }
        TabularResultData cacheServerTable = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.CacheServerDetails cacheServerDetails : diskStoreDetails.iterateCacheServers()) {
            cacheServerTable.accumulate("Bind Address", cacheServerDetails.getBindAddress());
            cacheServerTable.accumulate("Hostname for Clients", cacheServerDetails.getHostName());
            cacheServerTable.accumulate("Port", cacheServerDetails.getPort());
        }
        TabularResultData tabularResultData = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.GatewayDetails gatewayDetails : diskStoreDetails.iterateGateways()) {
            tabularResultData.accumulate("Gateway ID", gatewayDetails.getId());
            tabularResultData.accumulate("Persistent", gatewayDetails.isPersistent() ? "Yes" : "No");
        }
        TabularResultData tabularResultData2 = diskStoreData.addSection().addTable();
        for (DiskStoreDetails.AsyncEventQueueDetails asyncEventQueueDetails : diskStoreDetails.iterateAsyncEventQueues()) {
            tabularResultData2.accumulate("Async Event Queue ID", asyncEventQueueDetails.getId());
        }
        return ResultBuilder.buildResult(diskStoreData);
    }
}

