/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.cache.query.IndexType;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.IndexDefinition;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DefineIndexCommand
implements GfshCommand {
    @CliCommand(value={"define index"}, help="Define an index that can be used when executing queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result defineIndex(@CliOption(key={"name"}, mandatory=true, help="Define an index that can be used when executing queries.") String indexName, @CliOption(key={"expression"}, mandatory=true, help="Field of the region values that are referenced by the index.") String indexedExpression, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region which corresponds to the \"from\" clause in a query.") String regionPath, @CliOption(key={"type"}, unspecifiedDefaultValue="range", optionContext="geode.converter.index.type:disable-enum-converter", help="Type of the index. Valid values are: range and key. Deprecated: Since Geode 1.4, hash should not be used.") IndexType indexType) {
        IndexInfo indexInfo = new IndexInfo(indexName, indexedExpression, regionPath, indexType);
        IndexDefinition.indexDefinitions.add(indexInfo);
        InfoResultData infoResult = ResultBuilder.createInfoResultData();
        infoResult.addLine("Index successfully defined with following details");
        infoResult.addLine(CliStrings.format("Name       : {0}", (Object)indexName));
        infoResult.addLine(CliStrings.format("Expression : {0}", (Object)indexedExpression));
        infoResult.addLine(CliStrings.format("RegionPath : {0}", (Object)regionPath));
        CommandResult result = ResultBuilder.buildResult(infoResult);
        return result;
    }
}

