/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.management.DistributedRegionMXBean;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.RegionAttributesData;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.commands.RegionCommandsUtils;
import org.apache.geode.management.internal.cli.domain.ClassName;
import org.apache.geode.management.internal.cli.exceptions.EntityExistsException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.FetchRegionAttributesFunction;
import org.apache.geode.management.internal.cli.functions.RegionAttributesWrapper;
import org.apache.geode.management.internal.cli.functions.RegionCreateFunction;
import org.apache.geode.management.internal.cli.functions.RegionFunctionArgs;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.util.RegionPath;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateRegionCommand
implements GfshCommand {
    @CliCommand(value={"create region"}, help="Create a region with the given path and configuration. Specifying a --key-constraint and --value-constraint makes object type information available during querying and indexing.")
    @CliMetaData(relatedTopic={"Region"}, interceptor="org.apache.geode.management.internal.cli.commands.CreateRegionCommand$Interceptor")
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.MANAGE)
    public Result createRegion(@CliOption(key={"name"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region to be created.") String regionPath, @CliOption(key={"type"}, help="Type of region to create. The following types are pre-defined by the product (see RegionShortcut javadocs for more information): PARTITION, PARTITION_REDUNDANT, PARTITION_PERSISTENT, PARTITION_REDUNDANT_PERSISTENT, PARTITION_OVERFLOW, PARTITION_REDUNDANT_OVERFLOW, PARTITION_PERSISTENT_OVERFLOW, PARTITION_REDUNDANT_PERSISTENT_OVERFLOW, PARTITION_HEAP_LRU, PARTITION_REDUNDANT_HEAP_LRU, REPLICATE, REPLICATE_PERSISTENT, REPLICATE_OVERFLOW, REPLICATE_PERSISTENT_OVERFLOW, REPLICATE_HEAP_LRU, LOCAL, LOCAL_PERSISTENT, LOCAL_HEAP_LRU, LOCAL_OVERFLOW, LOCAL_PERSISTENT_OVERFLOW, PARTITION_PROXY, PARTITION_PROXY_REDUNDANT, and REPLICATE_PROXY.") RegionShortcut regionShortcut, @CliOption(key={"template-region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region whose attributes should be duplicated when creating this region. Deprecated: Since Geode 1.5, regions should be created explicitly so that undesirable attributes are not copied inadvertently.") String templateRegion, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which the region will be created.") String[] groups, @CliOption(key={"if-not-exists", "skip-if-exists"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="By default, an attempt to create a duplicate region is reported as an error. If this option is specified without a value or is specified with a value of true, then gfsh displays a \"Skipping...\" acknowledgement, but does not throw an error. Deprecated: the alias --skip-if-exists is deprecated since Geode 1.5.") boolean ifNotExists, @CliOption(key={"async-event-queue-id"}, help="IDs of the Async Event Queues that will be used for write-behind operations.") String[] asyncEventQueueIds, @CliOption(key={"cache-listener"}, optionContext="splittingRegex=,(?![^{]*\\})", help="Fully qualified class name of a plug-in to be instantiated for receiving after-event notification of changes to the region and its entries. Append json string for initialization properties. Any number of cache listeners can be configured.") ClassName<CacheListener>[] cacheListener, @CliOption(key={"cache-loader"}, help="Fully qualified class name of a plug-in to be instantiated for receiving notification of cache misses in the region. Append json string for initialization properties. At most, one cache loader can be defined in each member for the region. For distributed regions, a cache loader may be invoked remotely from other members that have the region defined.") ClassName<CacheLoader> cacheLoader, @CliOption(key={"cache-writer"}, help="Fully qualified class name of a plug-in to be instantiated for receiving before-event notification of changes to the region and its entries. Append json string for initialization properties. The plug-in may cancel the event. At most, one cache writer can be defined in each member for the region.") ClassName<CacheWriter> cacheWriter, @CliOption(key={"colocated-with"}, optionContext="geode.converter.region.path:disable-string-converter", help="Central Region with which this region should be colocated.") String prColocatedWith, @CliOption(key={"compressor"}, help="The fully-qualified class name of the Compressor to use when compressing region entry values.  The default is no compression.") String compressor, @CliOption(key={"concurrency-level"}, help="An estimate of the maximum number of application threads that will concurrently access a region entry at one time. This attribute does not apply to partitioned regions.") Integer concurrencyLevel, @CliOption(key={"disk-store"}, help="Disk Store to be used by this region. \"list disk-store\" can be used to display existing disk stores.") String diskStore, @CliOption(key={"enable-async-conflation"}, specifiedDefaultValue="true", help="Whether to allow aggregation of asynchronous TCP/IP messages sent by the producer member of the region. A false value causes all asynchronous messages to be sent individually.") Boolean enableAsyncConflation, @CliOption(key={"enable-cloning"}, specifiedDefaultValue="true", help="Determines how fromDelta applies deltas to the local cache for delta propagation. When true, the updates are applied to a clone of the value and then the clone is saved to the cache. When false, the value is modified in place in the cache.") Boolean cloningEnabled, @CliOption(key={"enable-concurrency-checks"}, specifiedDefaultValue="true", help="Enables a versioning system that detects concurrent modifications and ensures that region contents are consistent across the distributed system.") Boolean concurrencyChecksEnabled, @CliOption(key={"enable-multicast"}, specifiedDefaultValue="true", help="Enables multicast messaging on the region.  Multicast must also be enabled in the cache distributed system properties.  This is primarily useful for replicated regions that are in all servers.") Boolean mcastEnabled, @CliOption(key={"enable-statistics"}, specifiedDefaultValue="true", help="Whether to gather statistics for the region. Must be true to use expiration on the region.") Boolean statisticsEnabled, @CliOption(key={"enable-subscription-conflation"}, specifiedDefaultValue="true", help="Whether the server should conflate its messages to the client. A false value causes all server-client messages to be sent individually.") Boolean enableSubscriptionConflation, @CliOption(key={"enable-synchronous-disk"}, specifiedDefaultValue="true", help="Whether writes are done synchronously for regions that persist data to disk.") Boolean diskSynchronous, @CliOption(key={"entry-idle-time-expiration"}, help="How long the region's entries can remain in the cache without being accessed. The default is no expiration of this type.") Integer entryExpirationIdleTime, @CliOption(key={"entry-idle-time-expiration-action"}, help="Action to be taken on an entry that has exceeded the idle expiration.") ExpirationAction entryExpirationIdleTimeAction, @CliOption(key={"entry-time-to-live-expiration"}, help="How long the region's entries can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer entryExpirationTTL, @CliOption(key={"entry-time-to-live-expiration-action"}, help="Action to be taken on an entry that has exceeded the TTL expiration.") ExpirationAction entryExpirationTTLAction, @CliOption(key={"entry-idle-time-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry idle time. Append json string for initialization properties.") ClassName<CustomExpiry> entryIdleTimeCustomExpiry, @CliOption(key={"entry-time-to-live-custom-expiry"}, help="The name of the class implementing CustomExpiry for entry time to live. Append json string for initialization properties.") ClassName<CustomExpiry> entryTTLCustomExpiry, @CliOption(key={"eviction-action"}, help="The eviction action to apply. Must be either 'local-destroy' or 'overflow-to-disk'") String evictionAction, @CliOption(key={"eviction-entry-count"}, help="Activates LRU eviction based on the region's entry count specified by this value.") Integer evictionEntryCount, @CliOption(key={"eviction-max-memory"}, help="Activates LRU eviction based on the region's memory usage specified by this value (in megabytes).") Integer evictionMaxMemory, @CliOption(key={"eviction-object-sizer"}, help="A custom class which implements ObjectSizer in order to perform max memory eviction.") String evictionObjectSizer, @CliOption(key={"gateway-sender-id"}, help="IDs of the Gateway Senders to which data will be routed.") String[] gatewaySenderIds, @CliOption(key={"key-constraint"}, help="Fully qualified class name of the objects allowed as region keys. Ensures that keys for region entries are all of the same class.") String keyConstraint, @CliOption(key={"local-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in this process. (Default: 90% of available heap)") Integer prLocalMaxMemory, @CliOption(key={"off-heap"}, specifiedDefaultValue="true", help="Causes the values of the region to be stored in off-heap memory. The default is on heap.") Boolean offHeap, @CliOption(key={"partition-resolver"}, help="The fully-qualified class name of the region's partition resolver") String partitionResolver, @CliOption(key={"region-idle-time-expiration"}, help="How long the region can remain in the cache without being accessed. The default is no expiration of this type.") Integer regionExpirationIdleTime, @CliOption(key={"region-idle-time-expiration-action"}, help="Action to be taken on a region that has exceeded the idle expiration.") ExpirationAction regionExpirationIdleTimeAction, @CliOption(key={"region-time-to-live-expiration"}, help="How long the region can remain in the cache without being accessed or updated. The default is no expiration of this type.") Integer regionExpirationTTL, @CliOption(key={"region-time-to-live-expiration-action"}, help="Action to be taken on a region that has exceeded the TTL expiration.") ExpirationAction regionExpirationTTLAction, @CliOption(key={"recovery-delay"}, help="Sets the delay in milliseconds that existing members will wait before satisfying redundancy after another member crashes. -1 (the default) indicates that redundancy will not be recovered after a failure.") Long prRecoveryDelay, @CliOption(key={"redundant-copies"}, help="Sets the number of extra copies of buckets desired. Extra copies allow for both high availability in the face of VM departure (intended or unintended) and and load balancing read operations. (Allowed values: 0, 1, 2 and 3)") Integer prRedundantCopies, @CliOption(key={"startup-recovery-delay"}, help="Sets the delay in milliseconds that new members will wait before satisfying redundancy. -1 indicates that adding new members will not trigger redundancy recovery. The default is to recover redundancy immediately when a new member is added.") Long prStartupRecoveryDelay, @CliOption(key={"total-max-memory"}, help="Sets the maximum amount of memory, in megabytes, to be used by the region in all processes.") Long prTotalMaxMemory, @CliOption(key={"total-num-buckets"}, help="Sets the total number of hash buckets to be used by the region in all processes. (Default: 113).") Integer prTotalNumBuckets, @CliOption(key={"value-constraint"}, help="Fully qualified class name of the objects allowed as region values. If not specified then region values can be of any class.") String valueConstraint) {
        Set<DistributedMember> membersToCreateRegionOn;
        RegionPath regionPathData;
        String parentRegionPath;
        if (regionShortcut != null && templateRegion != null) {
            return ResultBuilder.createUserErrorResult("Only one of type & template-region can be specified.");
        }
        if (regionShortcut == null && templateRegion == null) {
            return ResultBuilder.createUserErrorResult("One of \"type\" or \"template-region\" is required.");
        }
        InternalCache cache = this.getCache();
        DistributedRegionMXBean regionBean = this.getManagementService().getDistributedRegionMXBean(regionPath);
        if (regionBean != null && regionShortcut != null) {
            String existingDataPolicy = regionBean.getRegionType();
            if (regionShortcut.isLocal() || existingDataPolicy.equals("NORMAL") || !regionShortcut.isProxy() && regionBean.getMemberCount() > regionBean.getEmptyNodes()) {
                throw new EntityExistsException(String.format("Region %s already exists on the cluster.", regionPath), ifNotExists);
            }
            if (regionShortcut.isPartition() && !existingDataPolicy.contains("PARTITION")) {
                throw new EntityExistsException("The existing region is not a partitioned region", ifNotExists);
            }
            if (regionShortcut.isReplicate() && !existingDataPolicy.equals("EMPTY") && !existingDataPolicy.contains("REPLICATE") && !existingDataPolicy.contains("PRELOADED")) {
                throw new EntityExistsException("The existing region is not a replicate region", ifNotExists);
            }
            Set membersWithThisRegion = Arrays.stream(regionBean.getMembers()).collect(Collectors.toSet());
            Set membersWithinGroup = this.findMembers(groups, null).stream().map(DistributedMember::getName).collect(Collectors.toSet());
            if (!Collections.disjoint(membersWithinGroup, membersWithThisRegion)) {
                throw new EntityExistsException(String.format("Region %s already exists on these members: %s.", regionPath, StringUtils.join(membersWithThisRegion, (String)",")), ifNotExists);
            }
        }
        if ((parentRegionPath = (regionPathData = new RegionPath(regionPath)).getParent()) != null && !"/".equals(parentRegionPath) && !this.regionExists(cache, parentRegionPath)) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("Parent region for \"{0}\" doesn't exist. ", new Object[]{regionPath}));
        }
        RegionFunctionArgs functionArgs = new RegionFunctionArgs();
        functionArgs.setRegionPath(regionPath);
        functionArgs.setIfNotExists(ifNotExists);
        functionArgs.setStatisticsEnabled(statisticsEnabled);
        functionArgs.setEntryExpirationIdleTime(entryExpirationIdleTime, entryExpirationIdleTimeAction);
        functionArgs.setEntryExpirationTTL(entryExpirationTTL, entryExpirationTTLAction);
        functionArgs.setRegionExpirationIdleTime(regionExpirationIdleTime, regionExpirationIdleTimeAction);
        functionArgs.setRegionExpirationTTL(regionExpirationTTL, regionExpirationTTLAction);
        functionArgs.setEntryIdleTimeCustomExpiry(entryIdleTimeCustomExpiry);
        functionArgs.setEntryTTLCustomExpiry(entryTTLCustomExpiry);
        functionArgs.setEvictionAttributes(evictionAction, evictionMaxMemory, evictionEntryCount, evictionObjectSizer);
        functionArgs.setDiskStore(diskStore);
        functionArgs.setDiskSynchronous(diskSynchronous);
        functionArgs.setEnableAsyncConflation(enableAsyncConflation);
        functionArgs.setEnableSubscriptionConflation(enableSubscriptionConflation);
        functionArgs.setAsyncEventQueueIds(asyncEventQueueIds);
        functionArgs.setGatewaySenderIds(gatewaySenderIds);
        functionArgs.setConcurrencyChecksEnabled(concurrencyChecksEnabled);
        functionArgs.setCloningEnabled(cloningEnabled);
        functionArgs.setConcurrencyLevel(concurrencyLevel);
        functionArgs.setPartitionArgs(prColocatedWith, prLocalMaxMemory, prRecoveryDelay, prRedundantCopies, prStartupRecoveryDelay, prTotalMaxMemory, prTotalNumBuckets, partitionResolver);
        functionArgs.setOffHeap(offHeap);
        functionArgs.setMcastEnabled(mcastEnabled);
        RegionAttributes regionAttributes = null;
        if (regionShortcut != null) {
            if (!regionShortcut.name().startsWith("PARTITION") && functionArgs.hasPartitionAttributes()) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Parameter(s) \"{0}\" can be used only for creating a Partitioned Region.", functionArgs.getPartitionArgs().getUserSpecifiedPartitionAttributes()) + " " + CliStrings.format("\"{0}\" is not a Partitioned Region.", (Object)regionPath));
            }
            functionArgs.setRegionShortcut(regionShortcut);
        } else {
            if (!this.regionExists(cache, templateRegion)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "template-region", templateRegion));
            }
            RegionAttributesWrapper wrappedAttributes = this.getRegionAttributes(cache, templateRegion);
            if (wrappedAttributes == null) {
                return ResultBuilder.createGemFireErrorResult(CliStrings.format("Could not retrieve region attributes for given path \"{0}\". Use \"list regions\" to verify region exists.", (Object)templateRegion));
            }
            if (wrappedAttributes.getRegionAttributes().getPartitionAttributes() == null && functionArgs.hasPartitionAttributes()) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Parameter(s) \"{0}\" can be used only for creating a Partitioned Region.", functionArgs.getPartitionArgs().getUserSpecifiedPartitionAttributes()) + " " + CliStrings.format("\"{0}\" is not a Partitioned Region.", (Object)templateRegion));
            }
            functionArgs.setTemplateRegion(templateRegion);
            functionArgs.setRegionAttributes(wrappedAttributes.getRegionAttributes());
            functionArgs.setCacheListeners(wrappedAttributes.getCacheListenerClasses().toArray(new ClassName[0]));
            functionArgs.setCacheWriter(wrappedAttributes.getCacheWriterClass());
            functionArgs.setCacheLoader(wrappedAttributes.getCacheLoaderClass());
            functionArgs.setCompressor(wrappedAttributes.getCompressorClass());
            functionArgs.setKeyConstraint(wrappedAttributes.getKeyConstraintClass());
            functionArgs.setValueConstraint(wrappedAttributes.getValueConstraintClass());
        }
        if (cacheListener != null) {
            functionArgs.setCacheListeners(cacheListener);
        }
        if (cacheLoader != null) {
            functionArgs.setCacheLoader(cacheLoader);
        }
        if (cacheWriter != null) {
            functionArgs.setCacheWriter(cacheWriter);
        }
        if (compressor != null) {
            functionArgs.setCompressor(compressor);
        }
        if (keyConstraint != null) {
            functionArgs.setKeyConstraint(keyConstraint);
        }
        if (valueConstraint != null) {
            functionArgs.setValueConstraint(valueConstraint);
        }
        DistributedSystemMXBean dsMBean = this.getDSMBean(cache);
        if (functionArgs.hasPartitionAttributes() && prColocatedWith != null) {
            ManagementService mgmtService = ManagementService.getExistingManagementService(cache);
            DistributedRegionMXBean distributedRegionMXBean = mgmtService.getDistributedRegionMXBean(prColocatedWith);
            if (distributedRegionMXBean == null) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Specify a valid region path for {0}. Region {1} not found.", "colocated-with", prColocatedWith));
            }
            String regionType = distributedRegionMXBean.getRegionType();
            if (!DataPolicy.PARTITION.toString().equals(regionType) && !DataPolicy.PERSISTENT_PARTITION.toString().equals(regionType)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("colocated-with \"{0}\" is not a Partitioned Region.", new Object[]{prColocatedWith}));
            }
        }
        if (gatewaySenderIds != null) {
            Set existingGatewaySenders = Arrays.stream(dsMBean.listGatewaySenders()).collect(Collectors.toSet());
            if (existingGatewaySenders.size() == 0) {
                return ResultBuilder.createUserErrorResult("There are no GatewaySenders defined currently in the system.");
            }
            Set specifiedGatewaySenders = Arrays.stream(gatewaySenderIds).collect(Collectors.toSet());
            specifiedGatewaySenders.removeAll(existingGatewaySenders);
            if (!specifiedGatewaySenders.isEmpty()) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Specify valid gateway-sender-id. Unknown Gateway Sender(s): \"{0}\".", gatewaySenderIds));
            }
        }
        if (diskStore != null) {
            regionAttributes = functionArgs.getRegionAttributes();
            if (regionAttributes != null && !regionAttributes.getDataPolicy().withPersistence()) {
                String subMessage = LocalizedStrings.DiskStore_IS_USED_IN_NONPERSISTENT_REGION.toLocalizedString();
                String message = subMessage + ". " + CliStrings.format("template-region region \"{0}\" is not persistent.", new Object[]{String.valueOf(functionArgs.getTemplateRegion())});
                return ResultBuilder.createUserErrorResult(message);
            }
            if (!this.diskStoreExists(cache, diskStore)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Specify valid disk-store. Unknown Disk Store : \"{0}\".", new Object[]{diskStore}));
            }
        }
        if (functionArgs.getRegionShortcut() != null && functionArgs.getRegionShortcut().isPersistent() || this.isAttributePersistent(functionArgs.getRegionAttributes())) {
            this.getSecurityService().authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        }
        if ((membersToCreateRegionOn = this.findMembers(groups, null)).isEmpty()) {
            if (groups == null || groups.length == 0) {
                return ResultBuilder.createUserErrorResult("No Members Found");
            }
            return ResultBuilder.createUserErrorResult(CliStrings.format("Group(s) \"{0}\" are invalid.", groups));
        }
        List<CliFunctionResult> regionCreateResults = this.executeAndGetFunctionResult(RegionCreateFunction.INSTANCE, functionArgs, membersToCreateRegionOn);
        CommandResult result = ResultBuilder.buildResult(regionCreateResults);
        XmlEntity xmlEntity = this.findXmlEntity(regionCreateResults);
        if (xmlEntity != null) {
            this.verifyDistributedRegionMbean(cache, regionPath);
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity(xmlEntity, groups));
        }
        return result;
    }

    boolean verifyDistributedRegionMbean(InternalCache cache, String regionName) {
        int federationInterval = cache.getInternalDistributedSystem().getConfig().getJmxManagerUpdateRate();
        long timeEnd = System.currentTimeMillis() + (long)federationInterval + 50L;
        while (System.currentTimeMillis() <= timeEnd) {
            try {
                DistributedRegionMXBean bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean(regionName);
                if (bean == null) {
                    bean = ManagementService.getManagementService(cache).getDistributedRegionMXBean("/" + regionName);
                }
                if (bean != null) {
                    return true;
                }
                Thread.sleep(2L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    RegionAttributesWrapper getRegionAttributes(InternalCache cache, String regionPath) {
        DistributedMember distributedMember;
        ResultCollector<?, ?> resultCollector;
        List resultsList;
        Set<DistributedMember> regionAssociatedMembers;
        if (!CreateRegionCommand.isClusterWideSameConfig(cache, regionPath)) {
            throw new IllegalStateException(CliStrings.format("The region mentioned for \"template-region\" exists in this Geode Cluster but with different Scopes or Data Policies on different members. For details, use command \"describe region\" for \"{0}\".", (Object)regionPath));
        }
        RegionAttributesWrapper attributes = null;
        try {
            attributes = FetchRegionAttributesFunction.getRegionAttributes(cache, regionPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (attributes == null && (regionAssociatedMembers = this.findMembersForRegion(cache, regionPath)) != null && !regionAssociatedMembers.isEmpty() && (resultsList = (List)(resultCollector = this.executeFunction((Function)FetchRegionAttributesFunction.INSTANCE, (Object)regionPath, distributedMember = regionAssociatedMembers.iterator().next())).getResult()) != null && !resultsList.isEmpty()) {
            for (Object object : resultsList) {
                if (object instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)object;
                }
                if (object instanceof Throwable) {
                    Throwable th = (Throwable)object;
                    LogWrapper.getInstance(this.getCache()).info(ExceptionUtils.getStackTrace((Throwable)th));
                    throw new IllegalArgumentException(CliStrings.format("Could not retrieve region attributes for given path \"{0}\". Reason: {1}", regionPath, th.getMessage()));
                }
                RegionAttributesWrapper regAttr = (RegionAttributesWrapper)object;
                if (attributes != null) continue;
                attributes = regAttr;
                break;
            }
        }
        return attributes;
    }

    private static boolean isClusterWideSameConfig(InternalCache cache, String regionPath) {
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        Set<DistributedMember> allMembers = CliUtil.getAllNormalMembers(cache);
        RegionAttributesData regionAttributesToValidateAgainst = null;
        for (DistributedMember distributedMember : allMembers) {
            try {
                ObjectName regionObjectName = dsMXBean.fetchRegionObjectName(CliUtil.getMemberNameOrId(distributedMember), regionPath);
                RegionMXBean regionMBean = managementService.getMBeanInstance(regionObjectName, RegionMXBean.class);
                RegionAttributesData regionAttributes = regionMBean.listRegionAttributes();
                if (regionAttributesToValidateAgainst == null) {
                    regionAttributesToValidateAgainst = regionAttributes;
                    continue;
                }
                if (regionAttributesToValidateAgainst.getScope().equals(regionAttributes.getScope()) || regionAttributesToValidateAgainst.getDataPolicy().equals(regionAttributes.getDataPolicy())) continue;
                return false;
            }
            catch (Exception exception) {
            }
        }
        return true;
    }

    boolean regionExists(InternalCache cache, String regionPath) {
        if (regionPath == null || "/".equals(regionPath)) {
            return false;
        }
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean dsMBean = managementService.getDistributedSystemMXBean();
        String[] allRegionPaths = dsMBean.listAllRegionPaths();
        return Arrays.stream(allRegionPaths).anyMatch(regionPath::equals);
    }

    private boolean diskStoreExists(InternalCache cache, String diskStoreName) {
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        DistributedSystemMXBean dsMXBean = managementService.getDistributedSystemMXBean();
        Map<String, String[]> diskstore = dsMXBean.listMemberDiskstore();
        Set<Map.Entry<String, String[]>> entrySet = diskstore.entrySet();
        for (Map.Entry<String, String[]> entry : entrySet) {
            Object[] value = entry.getValue();
            if (diskStoreName == null || !ArrayUtils.contains((Object[])value, (Object)diskStoreName)) continue;
            return true;
        }
        return false;
    }

    private boolean isAttributePersistent(RegionAttributes attributes) {
        return attributes != null && attributes.getDataPolicy() != null && attributes.getDataPolicy().toString().contains("PERSISTENT");
    }

    DistributedSystemMXBean getDSMBean(InternalCache cache) {
        ManagementService managementService = ManagementService.getExistingManagementService(cache);
        return managementService.getDistributedSystemMXBean();
    }

    public static class Interceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String regionShortcut;
            Integer localMaxMemory = (Integer)parseResult.getParamValue("local-max-memory");
            if (localMaxMemory != null && localMaxMemory < 0) {
                return ResultBuilder.createUserErrorResult(LocalizedStrings.AttributesFactory_PARTITIONATTRIBUTES_LOCALMAXMEMORY_MUST_NOT_BE_NEGATIVE.toLocalizedString());
            }
            Long totalMaxMemory = (Long)parseResult.getParamValue("total-max-memory");
            if (totalMaxMemory != null && totalMaxMemory <= 0L) {
                return ResultBuilder.createUserErrorResult(LocalizedStrings.AttributesFactory_TOTAL_SIZE_OF_PARTITION_REGION_MUST_BE_0.toLocalizedString());
            }
            Integer redundantCopies = (Integer)parseResult.getParamValue("redundant-copies");
            if (redundantCopies != null && (redundantCopies < 0 || redundantCopies > 3)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("redundant-copies \"{0}\" is not valid. It should be one of 0, 1, 2, 3.", new Object[]{redundantCopies}));
            }
            Integer concurrencyLevel = (Integer)parseResult.getParamValue("concurrency-level");
            if (concurrencyLevel != null && concurrencyLevel < 0) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Specify positive integer value for concurrency-level.  \"{0}\" is not valid.", new Object[]{concurrencyLevel}));
            }
            String keyConstraint = parseResult.getParamValueAsString("key-constraint");
            if (keyConstraint != null && !ClassName.isClassNameValid(keyConstraint)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Specify a valid class name for key-constraint. \"{0}\" is not valid.", new Object[]{keyConstraint}));
            }
            String valueConstraint = parseResult.getParamValueAsString("value-constraint");
            if (valueConstraint != null && !ClassName.isClassNameValid(valueConstraint)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Specify a valid class name for value-constraint. \"{0}\" is not valid.", new Object[]{valueConstraint}));
            }
            String compressor = parseResult.getParamValueAsString("compressor");
            if (compressor != null && !ClassName.isClassNameValid(compressor)) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("{0} is an invalid Compressor.", new Object[]{compressor}));
            }
            String diskStore = parseResult.getParamValueAsString("disk-store");
            if (diskStore != null && (regionShortcut = parseResult.getParamValueAsString("type")) != null && !RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS.contains((Object)RegionShortcut.valueOf(regionShortcut))) {
                String subMessage = LocalizedStrings.DiskStore_IS_USED_IN_NONPERSISTENT_REGION.toLocalizedString();
                String message = subMessage + ". " + CliStrings.format("Use one of these shortcuts: {0}", new Object[]{String.valueOf(RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS)});
                return ResultBuilder.createUserErrorResult(message);
            }
            Boolean statisticsEnabled = (Boolean)parseResult.getParamValue("enable-statistics");
            Integer entryIdle = (Integer)parseResult.getParamValue("entry-idle-time-expiration");
            Integer entryTtl = (Integer)parseResult.getParamValue("entry-time-to-live-expiration");
            Integer regionIdle = (Integer)parseResult.getParamValue("region-idle-time-expiration");
            Integer regionTtl = (Integer)parseResult.getParamValue("region-time-to-live-expiration");
            ExpirationAction entryIdleAction = (ExpirationAction)parseResult.getParamValue("entry-idle-time-expiration-action");
            ExpirationAction entryTtlAction = (ExpirationAction)parseResult.getParamValue("entry-time-to-live-expiration-action");
            ExpirationAction regionIdleAction = (ExpirationAction)parseResult.getParamValue("region-idle-time-expiration-action");
            ExpirationAction regionTtlAction = (ExpirationAction)parseResult.getParamValue("region-time-to-live-expiration-action");
            ClassName entryIdleExpiry = (ClassName)parseResult.getParamValue("entry-idle-time-custom-expiry");
            ClassName entryTTTLExpiry = (ClassName)parseResult.getParamValue("entry-time-to-live-custom-expiry");
            if (!(entryIdle == null && entryTtl == null && regionIdle == null && regionTtl == null && entryIdleAction == null && entryTtlAction == null && regionIdleAction == null && regionTtlAction == null && entryIdleExpiry == null && entryTTTLExpiry == null || statisticsEnabled != null && statisticsEnabled.booleanValue())) {
                String message = LocalizedStrings.AttributesFactory_STATISTICS_MUST_BE_ENABLED_FOR_EXPIRATION.toLocalizedString();
                return ResultBuilder.createUserErrorResult(message + ".");
            }
            String maxMemory = parseResult.getParamValueAsString("eviction-max-memory");
            String maxEntry = parseResult.getParamValueAsString("eviction-entry-count");
            String evictionAction = parseResult.getParamValueAsString("eviction-action");
            String evictionSizer = parseResult.getParamValueAsString("eviction-object-sizer");
            if (maxEntry != null && maxMemory != null) {
                return ResultBuilder.createUserErrorResult("eviction-max-memory and eviction-entry-count cannot both be specified.");
            }
            if ((maxEntry != null || maxMemory != null) && evictionAction == null) {
                return ResultBuilder.createUserErrorResult("eviction-action must be specified.");
            }
            if (evictionSizer != null && maxEntry != null) {
                return ResultBuilder.createUserErrorResult("eviction-object-sizer cannot be specified with eviction-entry-count");
            }
            if (evictionAction != null && EvictionAction.parseAction(evictionAction) == EvictionAction.NONE) {
                return ResultBuilder.createUserErrorResult("eviction-action must be 'local-destroy' or 'overflow-to-disk'");
            }
            return ResultBuilder.createInfoResult("");
        }
    }
}

