/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.AsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.CreateAsyncEventQueueFunction;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CreateAsyncEventQueueCommand
implements GfshCommand {
    @CliCommand(value={"create async-event-queue"}, help="Create Async Event Queue.")
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DEPLOY)
    public Result createAsyncEventQueue(@CliOption(key={"id"}, mandatory=true, help="ID of the queue to be created.") String id, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which queue will be created. If no group is specified the queue will be created on all members.") String[] groups, @CliOption(key={"parallel"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether this queue is parallel.") boolean parallel, @CliOption(key={"enable-batch-conflation"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to enable batch conflation.") boolean enableBatchConflation, @CliOption(key={"batch-size"}, unspecifiedDefaultValue="100", help="Maximum number of events that a batch can contain.") int batchSize, @CliOption(key={"batch-time-interval"}, unspecifiedDefaultValue="5", help="Maximum amount of time, in ms, that can elapse before a batch is delivered.") int batchTimeInterval, @CliOption(key={"persistent"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether events should be persisted to a disk store.") boolean persistent, @CliOption(key={"disk-store"}, help="Disk store to be used by this queue.") String diskStore, @CliOption(key={"disk-synchronous"}, unspecifiedDefaultValue="true", specifiedDefaultValue="true", help="Whether disk writes are synchronous.") boolean diskSynchronous, @CliOption(key={"forward-expiration-destroy"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Whether to forward expiration destroy events.") boolean forwardExpirationDestroy, @CliOption(key={"max-queue-memory"}, unspecifiedDefaultValue="100", help="Maximum amount of memory, in megabytes, that the queue can consume before overflowing to disk.") int maxQueueMemory, @CliOption(key={"dispatcher-threads"}, unspecifiedDefaultValue="1", help="Number of threads to use for sending events.") int dispatcherThreads, @CliOption(key={"order-policy"}, unspecifiedDefaultValue="KEY", help="Policy for dispatching events when --dispatcher-threads is > 1. Possible values are 'THREAD', 'KEY', 'PARTITION'.") String orderPolicy, @CliOption(key={"gateway-event-filter"}, help="List of fully qualified class names of GatewayEventFilters for this queue.  These classes filter events before dispatching to remote servers.") String[] gatewayEventFilters, @CliOption(key={"gateway-event-substitution-filter"}, help="Fully qualified class name of the GatewayEventSubstitutionFilter for this queue.") String gatewaySubstitutionListener, @CliOption(key={"listener"}, mandatory=true, help="Fully qualified class name of the AsyncEventListener for this queue.") String listener, @CliOption(key={"listener-param"}, help="Parameter name for the AsyncEventListener.  Optionally, parameter names may be followed by # and a value for the parameter.  Example: --listener-param=loadAll --listener-param=maxRead#1024") String[] listenerParamsAndValues) {
        Set<DistributedMember> targetMembers;
        AsyncEventQueueFunctionArgs aeqArgs;
        CreateAsyncEventQueueFunction function;
        List<CliFunctionResult> results;
        if (persistent) {
            this.getSecurityService().authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.WRITE, ResourcePermission.Target.DISK);
        }
        Properties listenerProperties = new Properties();
        if (listenerParamsAndValues != null) {
            for (String listenerParamsAndValue : listenerParamsAndValues) {
                int hashPosition = listenerParamsAndValue.indexOf(35);
                if (hashPosition == -1) {
                    listenerProperties.put(listenerParamsAndValue, "");
                    continue;
                }
                listenerProperties.put(listenerParamsAndValue.substring(0, hashPosition), listenerParamsAndValue.substring(hashPosition + 1));
            }
        }
        if ((results = this.executeAndGetFunctionResult(function = new CreateAsyncEventQueueFunction(), aeqArgs = new AsyncEventQueueFunctionArgs(id, parallel, enableBatchConflation, batchSize, batchTimeInterval, persistent, diskStore, diskSynchronous, maxQueueMemory, dispatcherThreads, orderPolicy, gatewayEventFilters, gatewaySubstitutionListener, listener, listenerProperties, forwardExpirationDestroy), targetMembers = this.getMembers(groups, null))).size() == 0) {
            throw new RuntimeException("No results received.");
        }
        CommandResult commandResult = ResultBuilder.buildResult(results);
        XmlEntity xmlEntity = this.findXmlEntity(results);
        if (xmlEntity != null) {
            this.persistClusterConfiguration(commandResult, () -> this.getSharedConfiguration().addXmlEntity(xmlEntity, groups));
        }
        return commandResult;
    }
}

