/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.geode.GemFireIOException;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.DiskStoreCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.util.DiskStoreCompacter;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class CompactOfflineDiskStoreCommand
implements GfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"compact offline-disk-store"}, help="Compact an offline disk store. If the disk store is large, additional memory may need to be allocated to the process using the --J=-Xmx??? parameter.")
    @CliMetaData(shellOnly=true, relatedTopic={"Disk Store"})
    public Result compactOfflineDiskStore(@CliOption(key={"name"}, mandatory=true, help="Name of the offline disk store to be compacted.") String diskStoreName, @CliOption(key={"disk-dirs"}, mandatory=true, help="Directories where data for the disk store was previously written.") String[] diskDirs, @CliOption(key={"max-oplog-size"}, unspecifiedDefaultValue="-1", help="Maximum size (in megabytes) of the oplogs created by compaction.") long maxOplogSize, @CliOption(key={"J"}, help="Arguments passed to the Java Virtual Machine performing the compact operation on the disk store.") String[] jvmProps) {
        Result result;
        LogWrapper logWrapper = LogWrapper.getInstance(CliUtil.getCacheIfExists(this::getCache));
        StringBuilder output = new StringBuilder();
        StringBuilder error = new StringBuilder();
        StringBuilder errorMessage = new StringBuilder();
        Process compacterProcess = null;
        try {
            String line;
            String validatedDirectories = DiskStoreCommandsUtils.validatedDirectories(diskDirs);
            if (validatedDirectories != null) {
                throw new IllegalArgumentException("Could not find disk-dirs: \"" + validatedDirectories + "\"");
            }
            ArrayList<String> commandList = new ArrayList<String>();
            commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
            DiskStoreCommandsUtils.configureLogging(commandList);
            if (jvmProps != null && jvmProps.length != 0) {
                commandList.addAll(Arrays.asList(jvmProps));
            }
            commandList.add("-classpath");
            commandList.add(System.getProperty("java.class.path", "."));
            commandList.add(DiskStoreCompacter.class.getName());
            commandList.add("name=" + diskStoreName);
            if (diskDirs != null && diskDirs.length != 0) {
                StringBuilder builder = new StringBuilder();
                int arrayLength = diskDirs.length;
                for (int i = 0; i < arrayLength; ++i) {
                    if (File.separatorChar == '\\') {
                        builder.append(diskDirs[i].replace("\\", "/"));
                    } else {
                        builder.append(diskDirs[i]);
                    }
                    if (i + 1 == arrayLength) continue;
                    builder.append(',');
                }
                commandList.add("disk-dirs=" + builder.toString());
            }
            commandList.add("max-oplog-size=" + maxOplogSize);
            ProcessBuilder procBuilder = new ProcessBuilder(commandList);
            compacterProcess = procBuilder.start();
            InputStream inputStream = compacterProcess.getInputStream();
            InputStream errorStream = compacterProcess.getErrorStream();
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));
            while ((line = inputReader.readLine()) != null) {
                output.append(line).append(GfshParser.LINE_SEPARATOR);
            }
            boolean switchToStackTrace = false;
            while ((line = errorReader.readLine()) != null) {
                if (!switchToStackTrace && DiskStoreCompacter.STACKTRACE_START.equals(line)) {
                    switchToStackTrace = true;
                    continue;
                }
                if (switchToStackTrace) {
                    error.append(line).append(GfshParser.LINE_SEPARATOR);
                    continue;
                }
                errorMessage.append(line);
            }
            if (errorMessage.length() > 0) {
                throw new GemFireIOException(errorMessage.toString());
            }
            compacterProcess.destroy();
            result = ResultBuilder.createInfoResult(output.toString());
        }
        catch (IOException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            String fieldsMessage = maxOplogSize != -1L ? "max-oplog-size=" + maxOplogSize + "," : "";
            fieldsMessage = fieldsMessage + StringUtils.arrayToString(diskDirs);
            String errorString = CliStrings.format("While compacting disk store={0} {1}. Reason: {2}", diskStoreName, fieldsMessage);
            result = ResultBuilder.createUserErrorResult(errorString);
            if (logWrapper.fineEnabled()) {
                logWrapper.fine(e.getMessage(), e);
            }
        }
        catch (GemFireIOException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            result = ResultBuilder.createUserErrorResult(errorMessage.toString());
            if (logWrapper.fineEnabled()) {
                logWrapper.fine(error.toString());
            }
        }
        catch (IllegalArgumentException e) {
            if (output.length() != 0) {
                Gfsh.println(output.toString());
            }
            result = ResultBuilder.createUserErrorResult(e.getMessage());
        }
        finally {
            if (compacterProcess != null) {
                try {
                    compacterProcess.exitValue();
                }
                catch (IllegalThreadStateException ise) {
                    compacterProcess.destroy();
                }
            }
        }
        return result;
    }
}

