/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.geode.cache.Cache;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.management.internal.cli.CommandManagerAware;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.help.Helper;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.cli.util.ClasspathScanLoadHelper;
import org.springframework.shell.converters.EnumConverter;
import org.springframework.shell.converters.SimpleFileConverter;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;

public class CommandManager {
    public static final String USER_CMD_PACKAGES_PROPERTY = "gemfire.user-command-packages";
    public static final String USER_CMD_PACKAGES_ENV_VARIABLE = "GEMFIRE_USER_COMMAND_PACKAGES";
    private final Helper helper = new Helper();
    private final List<Converter<?>> converters = new ArrayList();
    private final List<CommandMarker> commandMarkers = new ArrayList<CommandMarker>();
    private Properties cacheProperties;
    private LogWrapper logWrapper;
    private static List<Class> SHL_CONVERTERS_TOSKIP = new ArrayList<Class>();

    public CommandManager() {
        this(null, null);
    }

    public CommandManager(Properties cacheProperties, Cache cache) {
        if (cacheProperties != null) {
            this.cacheProperties = cacheProperties;
        }
        this.logWrapper = LogWrapper.getInstance(cache);
        this.loadCommands();
    }

    private static void raiseExceptionIfEmpty(Set<Class<?>> foundClasses, String errorFor) throws IllegalStateException {
        if (foundClasses == null || foundClasses.isEmpty()) {
            throw new IllegalStateException("Required " + errorFor + " classes were not loaded. Check logs for errors.");
        }
    }

    private void loadUserCommands() {
        String cacheUserCmdPackages;
        StringTokenizer tokenizer;
        HashSet<String> userCommandPackages = new HashSet<String>();
        if (System.getProperty(USER_CMD_PACKAGES_PROPERTY) != null) {
            tokenizer = new StringTokenizer(System.getProperty(USER_CMD_PACKAGES_PROPERTY), ",");
            while (tokenizer.hasMoreTokens()) {
                userCommandPackages.add(tokenizer.nextToken());
            }
        }
        if (System.getenv().containsKey(USER_CMD_PACKAGES_ENV_VARIABLE)) {
            tokenizer = new StringTokenizer(System.getenv().get(USER_CMD_PACKAGES_ENV_VARIABLE), ",");
            while (tokenizer.hasMoreTokens()) {
                userCommandPackages.add(tokenizer.nextToken());
            }
        }
        if (this.cacheProperties != null && (cacheUserCmdPackages = this.cacheProperties.getProperty("user-command-packages")) != null && !cacheUserCmdPackages.isEmpty()) {
            StringTokenizer tokenizer2 = new StringTokenizer(cacheUserCmdPackages, ",");
            while (tokenizer2.hasMoreTokens()) {
                userCommandPackages.add(tokenizer2.nextToken());
            }
        }
        for (String userCommandPackage : userCommandPackages) {
            try {
                Set<Class<?>> foundClasses = ClasspathScanLoadHelper.scanPackageForClassesImplementing(userCommandPackage, CommandMarker.class);
                for (Class<?> klass : foundClasses) {
                    try {
                        this.add((CommandMarker)klass.newInstance());
                    }
                    catch (Exception e) {
                        this.logWrapper.warning("Could not load User Commands from: " + klass + " due to " + e.getLocalizedMessage());
                    }
                }
                CommandManager.raiseExceptionIfEmpty(foundClasses, "User Command");
            }
            catch (IllegalStateException e) {
                this.logWrapper.warning(e.getMessage(), e);
                throw e;
            }
        }
    }

    private void loadPluginCommands() {
        Iterator<CommandMarker> iterator = ServiceLoader.load(CommandMarker.class, ClassPathLoader.getLatest().asClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                CommandMarker commandMarker = iterator.next();
                try {
                    this.add(commandMarker);
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Command from: " + commandMarker.getClass() + " due to " + e.getLocalizedMessage(), e);
                }
            }
            catch (ServiceConfigurationError e) {
                this.logWrapper.severe("Could not load Command: " + e.getLocalizedMessage(), e);
            }
        }
    }

    private void loadCommands() {
        this.loadUserCommands();
        this.loadPluginCommands();
        this.loadGeodeCommands();
        this.loadConverters();
    }

    private void loadConverters() {
        try {
            Set<Class<?>> foundClasses = ClasspathScanLoadHelper.scanPackageForClassesImplementing("org.apache.geode.management.internal.cli.converters", Converter.class);
            for (Class<?> klass : foundClasses) {
                try {
                    Converter object = (Converter)klass.newInstance();
                    this.add(object);
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Converter from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Converters");
            foundClasses = ClasspathScanLoadHelper.scanPackageForClassesImplementing("org.springframework.shell.converters", Converter.class);
            for (Class<?> klass : foundClasses) {
                if (SHL_CONVERTERS_TOSKIP.contains(klass)) continue;
                try {
                    this.add((Converter)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Converter from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Basic Converters");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    private void loadGeodeCommands() {
        try {
            Set<Class<?>> foundClasses = ClasspathScanLoadHelper.scanPackageForClassesImplementing(GfshCommand.class.getPackage().getName(), CommandMarker.class);
            for (Class<?> klass : foundClasses) {
                try {
                    this.add((CommandMarker)klass.newInstance());
                }
                catch (Exception e) {
                    this.logWrapper.warning("Could not load Command from: " + klass + " due to " + e.getLocalizedMessage());
                }
            }
            CommandManager.raiseExceptionIfEmpty(foundClasses, "Commands");
        }
        catch (IllegalStateException e) {
            this.logWrapper.warning(e.getMessage(), e);
            throw e;
        }
    }

    public List<Converter<?>> getConverters() {
        return this.converters;
    }

    public List<CommandMarker> getCommandMarkers() {
        return this.commandMarkers;
    }

    void add(Converter<?> converter) {
        if (CommandManagerAware.class.isAssignableFrom(converter.getClass())) {
            ((CommandManagerAware)converter).setCommandManager(this);
        }
        this.converters.add(converter);
    }

    void add(CommandMarker commandMarker) {
        if (CommandManagerAware.class.isAssignableFrom(commandMarker.getClass())) {
            ((CommandManagerAware)commandMarker).setCommandManager(this);
        }
        this.commandMarkers.add(commandMarker);
        for (Method method : commandMarker.getClass().getMethods()) {
            CliCommand cliCommand = method.getAnnotation(CliCommand.class);
            CliAvailabilityIndicator availability = method.getAnnotation(CliAvailabilityIndicator.class);
            if (cliCommand == null && availability == null) continue;
            if (cliCommand != null) {
                this.helper.addCommand(cliCommand, method);
            }
            if (availability == null) continue;
            this.helper.addAvailabilityIndicator(availability, new MethodTarget(method, (Object)commandMarker));
        }
    }

    public Helper getHelper() {
        return this.helper;
    }

    public String obtainHelp(String buffer) {
        int terminalWidth = -1;
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null) {
            terminalWidth = gfsh.getTerminalWidth();
        }
        return this.helper.getHelp(buffer, terminalWidth);
    }

    public String obtainHint(String topic) {
        return this.helper.getHint(topic);
    }

    static {
        SHL_CONVERTERS_TOSKIP.add(SimpleFileConverter.class);
        SHL_CONVERTERS_TOSKIP.add(EnumConverter.class);
    }
}

