/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.management.CacheServerMXBean;
import org.apache.geode.management.GatewayReceiverMXBean;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.LockServiceMXBean;
import org.apache.geode.management.MemberMXBean;
import org.apache.geode.management.RegionMXBean;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.ProxyListener;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.AggregateHandler;
import org.apache.geode.management.internal.beans.DistributedSystemBridge;

public class MBeanAggregator
implements ProxyListener {
    private static final List<Class> distributedMBeanList = new ArrayList<Class>();
    protected LogWriterI18n logger;
    private SystemManagementService service;
    private RegionHandler regionHandler = new RegionHandler();
    private MemberHandler memberHandler = new MemberHandler();
    private LockServiceHandler lockServiceHandler = new LockServiceHandler();
    private CacheServerHandler cacheServerHandler = new CacheServerHandler();
    private GatewayReceiverHandler gatewayReceiverHandler = new GatewayReceiverHandler();
    private GatewaySenderHandler gatewaySenderHandler = new GatewaySenderHandler();
    private DistributedSystemBridge distributedSystemBridge;

    public MBeanAggregator(DistributedSystemBridge distributedSystemBridge) {
        this.logger = InternalDistributedSystem.getLoggerI18n();
        this.distributedSystemBridge = distributedSystemBridge;
    }

    private AggregateHandler getHandler(Class interfaceClass) {
        if (interfaceClass.equals(RegionMXBean.class)) {
            return this.regionHandler;
        }
        if (interfaceClass.equals(MemberMXBean.class)) {
            return this.memberHandler;
        }
        if (interfaceClass.equals(LockServiceMXBean.class)) {
            return this.lockServiceHandler;
        }
        if (interfaceClass.equals(CacheServerMXBean.class)) {
            return this.cacheServerHandler;
        }
        if (interfaceClass.equals(GatewayReceiverMXBean.class)) {
            return this.gatewayReceiverHandler;
        }
        if (interfaceClass.equals(GatewaySenderMXBean.class)) {
            return this.gatewaySenderHandler;
        }
        return null;
    }

    @Override
    public void afterCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        if (!distributedMBeanList.contains(interfaceClass)) {
            return;
        }
        AggregateHandler handler = this.getHandler(interfaceClass);
        handler.handleProxyAddition(objectName, interfaceClass, proxyObject, newVal);
    }

    @Override
    public void afterRemoveProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
        if (!distributedMBeanList.contains(interfaceClass)) {
            return;
        }
        AggregateHandler handler = this.getHandler(interfaceClass);
        handler.handleProxyRemoval(objectName, interfaceClass, proxyObject, oldVal);
    }

    @Override
    public void afterUpdateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        if (!distributedMBeanList.contains(interfaceClass)) {
            return;
        }
        AggregateHandler handler = this.getHandler(interfaceClass);
        handler.handleProxyUpdate(objectName, interfaceClass, proxyObject, newVal, oldVal);
    }

    @Override
    public void afterPseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        if (!distributedMBeanList.contains(interfaceClass)) {
            return;
        }
        AggregateHandler handler = this.getHandler(interfaceClass);
        handler.handlePseudoCreateProxy(objectName, interfaceClass, proxyObject, newVal);
    }

    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        this.distributedSystemBridge.memberDeparted(id, crashed);
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
        this.distributedSystemBridge.memberJoined(id);
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        this.distributedSystemBridge.memberSuspect(id, whoSuspected);
    }

    @Override
    public void handleNotification(Notification notification) {
        this.distributedSystemBridge.sendSystemLevelNotification(notification);
    }

    static {
        distributedMBeanList.add(RegionMXBean.class);
        distributedMBeanList.add(MemberMXBean.class);
        distributedMBeanList.add(LockServiceMXBean.class);
        distributedMBeanList.add(CacheServerMXBean.class);
        distributedMBeanList.add(GatewayReceiverMXBean.class);
        distributedMBeanList.add(GatewaySenderMXBean.class);
    }

    private class LockServiceHandler
    implements AggregateHandler {
        private LockServiceHandler() {
        }

        @Override
        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            LockServiceMXBean lockServiceProxy = (LockServiceMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.addLockService(objectName, lockServiceProxy, newVal);
        }

        @Override
        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            LockServiceMXBean lockServiceProxy = (LockServiceMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.removeLockService(objectName, lockServiceProxy, oldVal);
        }

        @Override
        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        }

        @Override
        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }

    private class MemberHandler
    implements AggregateHandler {
        private MemberHandler() {
        }

        @Override
        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            MemberMXBean memberProxy = (MemberMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.addMemberToSystem(objectName, memberProxy, newVal);
        }

        @Override
        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            MemberMXBean memberProxy = (MemberMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.removeMemberFromSystem(objectName, memberProxy, oldVal);
        }

        @Override
        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
            MBeanAggregator.this.distributedSystemBridge.updateMember(objectName, newVal, oldVal);
        }

        @Override
        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            MBeanAggregator.this.distributedSystemBridge.updateMember(objectName, newVal, null);
        }
    }

    private class RegionHandler
    implements AggregateHandler {
        private RegionHandler() {
        }

        @Override
        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            RegionMXBean regionProxy = (RegionMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.addRegion(objectName, regionProxy, newVal);
        }

        @Override
        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            RegionMXBean regionProxy = (RegionMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.removeRegion(objectName, regionProxy, oldVal);
        }

        @Override
        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
            MBeanAggregator.this.distributedSystemBridge.updateRegion(objectName, oldVal, newVal);
        }

        @Override
        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }

    private class GatewaySenderHandler
    implements AggregateHandler {
        private GatewaySenderHandler() {
        }

        @Override
        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            GatewaySenderMXBean proxy = (GatewaySenderMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.addGatewaySenderToSystem(objectName, proxy, newVal);
        }

        @Override
        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            GatewaySenderMXBean proxy = (GatewaySenderMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.removeGatewaySenderFromSystem(objectName, proxy, oldVal);
        }

        @Override
        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
            MBeanAggregator.this.distributedSystemBridge.updateGatewaySender(objectName, newVal, oldVal);
        }

        @Override
        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }

    private class GatewayReceiverHandler
    implements AggregateHandler {
        private GatewayReceiverHandler() {
        }

        @Override
        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            GatewayReceiverMXBean proxy = (GatewayReceiverMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.addGatewayReceiverToSystem(objectName, proxy, newVal);
        }

        @Override
        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent oldVal) {
            GatewayReceiverMXBean proxy = (GatewayReceiverMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.removeGatewayReceiverFromSystem(objectName, proxy, oldVal);
        }

        @Override
        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
            MBeanAggregator.this.distributedSystemBridge.updateGatewayReceiver(objectName, newVal, oldVal);
        }

        @Override
        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }

    private class CacheServerHandler
    implements AggregateHandler {
        private CacheServerHandler() {
        }

        @Override
        public void handleProxyAddition(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
            CacheServerMXBean serverProxy = (CacheServerMXBean)interfaceClass.cast(proxyObject);
            MBeanAggregator.this.distributedSystemBridge.addServerToSystem(objectName, serverProxy, newVal);
        }

        @Override
        public void handleProxyRemoval(ObjectName objectName, Class interfaceClass, Object obj, FederationComponent oldVal) {
            CacheServerMXBean serverProxy = (CacheServerMXBean)interfaceClass.cast(obj);
            MBeanAggregator.this.distributedSystemBridge.removeServerFromSystem(objectName, serverProxy, oldVal);
        }

        @Override
        public void handleProxyUpdate(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
            MBeanAggregator.this.distributedSystemBridge.updateCacheServer(objectName, newVal, oldVal);
        }

        @Override
        public void handlePseudoCreateProxy(ObjectName objectName, Class interfaceClass, Object proxyObject, FederationComponent newVal) {
        }
    }
}

