/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.management.JMX;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.FederationComponent;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MXBeanProxyInvocationHandler;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.NotificationBroadCasterProxy;
import org.apache.geode.management.internal.ProxyInterface;
import org.apache.logging.log4j.Logger;

public class MBeanProxyInvocationHandler
implements InvocationHandler {
    private static final Logger logger = LogService.getLogger();
    private ObjectName objectName;
    private Region<String, Object> monitoringRegion;
    private DistributedMember member;
    private final NotificationBroadcasterSupport emitter;
    private final ProxyInterface proxyImpl;
    private boolean isMXBean;
    private MXBeanProxyInvocationHandler mxbeanInvocationRef;

    public static Object newProxyInstance(DistributedMember member, Region<String, Object> monitoringRegion, ObjectName objectName, Class interfaceClass) throws ClassNotFoundException, IntrospectionException {
        boolean isMXBean = JMX.isMXBeanInterface(interfaceClass);
        boolean notificationBroadcaster = ((FederationComponent)monitoringRegion.get(objectName.toString())).isNotificationEmitter();
        MBeanProxyInvocationHandler handler = new MBeanProxyInvocationHandler(member, objectName, monitoringRegion, isMXBean);
        Class[] interfaces = notificationBroadcaster ? new Class[]{interfaceClass, ProxyInterface.class, NotificationBroadCasterProxy.class} : new Class[]{interfaceClass, ProxyInterface.class};
        Object proxy = Proxy.newProxyInstance(MBeanProxyInvocationHandler.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        return interfaceClass.cast(proxy);
    }

    private MBeanProxyInvocationHandler(DistributedMember member, ObjectName objectName, Region<String, Object> monitoringRegion, boolean isMXBean) throws IntrospectionException, ClassNotFoundException {
        this.member = member;
        this.objectName = objectName;
        this.monitoringRegion = monitoringRegion;
        this.emitter = new NotificationBroadcasterSupport();
        this.proxyImpl = new ProxyInterfaceImpl();
        this.isMXBean = isMXBean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int nargs;
        Class<?> methodClass;
        if (logger.isTraceEnabled()) {
            logger.trace("Invoking Method {}", (Object)method.getName());
        }
        if ((methodClass = method.getDeclaringClass()).equals(NotificationBroadcaster.class) || methodClass.equals(NotificationEmitter.class)) {
            return this.invokeBroadcasterMethod(proxy, method, args);
        }
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        int n = nargs = args == null ? 0 : args.length;
        if (methodName.equals("setLastRefreshedTime")) {
            this.proxyImpl.setLastRefreshedTime((Long)args[0]);
            return null;
        }
        if (methodName.equals("getLastRefreshedTime")) {
            return this.proxyImpl.getLastRefreshedTime();
        }
        if (methodName.equals("sendNotification")) {
            this.sendNotification(args[0]);
            return null;
        }
        if (this.shouldDoLocally(proxy, method)) {
            return this.doLocally(proxy, method, args);
        }
        if (this.isMXBean) {
            MXBeanProxyInvocationHandler p = this.findMXBeanProxy(this.objectName, methodClass, this);
            return p.invoke(proxy, method, args);
        }
        if (methodName.startsWith("get") && methodName.length() > 3 && nargs == 0 && !returnType.equals(Void.TYPE)) {
            return this.delegateToObjectState(methodName.substring(3));
        }
        if (methodName.startsWith("is") && methodName.length() > 2 && nargs == 0 && (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class))) {
            return this.delegateToObjectState(methodName.substring(2));
        }
        String[] signature = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            signature[i] = paramTypes[i].getName();
        }
        if (methodName.startsWith("set") && methodName.length() > 3 && nargs == 1 && returnType.equals(Void.TYPE)) {
            return this.delegateToFucntionService(this.objectName, methodName, args, signature);
        }
        return this.delegateToFucntionService(this.objectName, methodName, args, signature);
    }

    private void sendNotification(Object notification) {
        this.emitter.sendNotification((Notification)notification);
    }

    protected Object delegateToObjectState(String attributeName) throws Throwable {
        Object returnObj;
        try {
            FederationComponent fedComp = (FederationComponent)this.monitoringRegion.get(this.objectName.toString());
            returnObj = fedComp.getValue(attributeName);
        }
        catch (IllegalArgumentException e) {
            throw new MBeanException(e);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            throw new MBeanException(new Exception(th.getLocalizedMessage()));
        }
        return returnObj;
    }

    protected Object delegateToFucntionService(ObjectName objectName, String methodName, Object[] args, String[] signature) throws Throwable {
        Object[] functionArgs = new Object[]{objectName, methodName, signature, args, this.member.getName()};
        List result = null;
        try {
            ResultCollector rc = FunctionService.onMember(this.member).setArguments(functionArgs).execute(ManagementConstants.MGMT_FUNCTION_ID);
            result = (List)rc.getResult();
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug(" Exception while Executing Funtion {}", (Object)e.getMessage(), (Object)e);
            }
            return null;
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            if (logger.isDebugEnabled()) {
                logger.debug(" Exception while Executing Funtion {}", (Object)th.getMessage(), (Object)th);
            }
            return null;
        }
        return this.checkErrors(result.get(0));
    }

    private Object checkErrors(Object lastResult) throws Throwable {
        if (lastResult instanceof MBeanException) {
            throw (Exception)lastResult;
        }
        if (lastResult instanceof Exception) {
            return null;
        }
        if (lastResult instanceof Throwable) {
            return null;
        }
        return lastResult;
    }

    private Object invokeBroadcasterMethod(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int nargs = args == null ? 0 : args.length;
        Class<?>[] paramTypes = method.getParameterTypes();
        String[] signature = new String[paramTypes.length];
        if (methodName.equals("addNotificationListener")) {
            if (nargs != 3) {
                String msg = "Bad arg count to addNotificationListener: " + nargs;
                throw new IllegalArgumentException(msg);
            }
            NotificationListener listener = (NotificationListener)args[0];
            NotificationFilter filter = (NotificationFilter)args[1];
            Object handback = args[2];
            this.emitter.addNotificationListener(listener, filter, handback);
            this.delegateToFucntionService(this.objectName, methodName, null, signature);
            return null;
        }
        if (methodName.equals("removeNotificationListener")) {
            NotificationListener listener = (NotificationListener)args[0];
            switch (nargs) {
                case 1: {
                    this.emitter.removeNotificationListener(listener);
                    this.delegateToFucntionService(this.objectName, methodName, null, signature);
                    return null;
                }
                case 3: {
                    NotificationFilter filter = (NotificationFilter)args[1];
                    Object handback = args[2];
                    this.emitter.removeNotificationListener(listener, filter, handback);
                    this.delegateToFucntionService(this.objectName, methodName, null, signature);
                    return null;
                }
            }
            String msg = "Bad arg count to removeNotificationListener: " + nargs;
            throw new IllegalArgumentException(msg);
        }
        if (methodName.equals("getNotificationInfo")) {
            if (args != null) {
                throw new IllegalArgumentException("getNotificationInfo has args");
            }
            if (!MBeanJMXAdapter.mbeanServer.isRegistered(this.objectName)) {
                return new MBeanNotificationInfo[0];
            }
            Object obj = this.delegateToFucntionService(this.objectName, methodName, args, signature);
            if (obj instanceof String) {
                return new MBeanNotificationInfo[0];
            }
            MBeanInfo info = (MBeanInfo)obj;
            return info.getNotifications();
        }
        throw new IllegalArgumentException("Bad method name: " + methodName);
    }

    private boolean shouldDoLocally(Object proxy, Method method) {
        String methodName = method.getName();
        if ((methodName.equals("hashCode") || methodName.equals("toString")) && method.getParameterTypes().length == 0) {
            return true;
        }
        return methodName.equals("equals") && Arrays.equals(method.getParameterTypes(), new Class[]{Object.class});
    }

    private Object doLocally(Object proxy, Method method, Object[] args) {
        String methodName = method.getName();
        FederationComponent fedComp = (FederationComponent)this.monitoringRegion.get(this.objectName.toString());
        if (methodName.equals("equals")) {
            return fedComp.equals(args[0]);
        }
        if (methodName.equals("toString")) {
            return fedComp.toString();
        }
        if (methodName.equals("hashCode")) {
            return fedComp.hashCode();
        }
        throw new RuntimeException("Unexpected method name: " + methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MXBeanProxyInvocationHandler findMXBeanProxy(ObjectName objectName, Class<?> mxbeanInterface, MBeanProxyInvocationHandler handler) throws Throwable {
        MXBeanProxyInvocationHandler proxyRef = this.mxbeanInvocationRef;
        if (this.mxbeanInvocationRef == null) {
            MBeanProxyInvocationHandler mBeanProxyInvocationHandler = this;
            synchronized (mBeanProxyInvocationHandler) {
                try {
                    this.mxbeanInvocationRef = new MXBeanProxyInvocationHandler(objectName, mxbeanInterface, handler);
                }
                catch (IllegalArgumentException e) {
                    String msg = "Cannot make MXBean proxy for " + mxbeanInterface.getName() + ": " + e.getMessage();
                    throw new IllegalArgumentException(msg, e.getCause());
                }
            }
        }
        return this.mxbeanInvocationRef;
    }

    private class ProxyInterfaceImpl
    implements ProxyInterface {
        private long lastRefreshedTime = System.currentTimeMillis();

        @Override
        public long getLastRefreshedTime() {
            return this.lastRefreshedTime;
        }

        @Override
        public void setLastRefreshedTime(long lastRefreshedTime) {
            this.lastRefreshedTime = lastRefreshedTime;
        }
    }
}

