/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.internal.util.ArrayUtils;

public class ArgumentRedactor {
    public static final String redacted = "********";
    private static final List<String> tabooToContain = ArrayUtils.asList("password");
    private static final List<String> tabooForKeyToStartWith = ArrayUtils.asList("sysprop-", "javax.net.ssl", "security-");
    private static final Pattern optionWithValuePattern = Pattern.compile("([^ ]--?[^\\s=]+)(?=[ =])( *=? *)(?!-)((?:\"[^\"]*\"|\\S+))");

    private ArgumentRedactor() {
    }

    public static String redact(String line, boolean permitFirstPairWithoutHyphen) {
        boolean wasPaddedWithHyphen = false;
        if (!line.trim().startsWith("-") && permitFirstPairWithoutHyphen) {
            line = "-" + line.trim();
            wasPaddedWithHyphen = true;
        }
        Matcher matcher = optionWithValuePattern.matcher(line);
        while (matcher.find()) {
            String option = matcher.group(1);
            if (!ArgumentRedactor.isTaboo(option)) continue;
            String separator = matcher.group(2);
            String withRedaction = option + separator + redacted;
            line = line.replace(matcher.group(), withRedaction);
        }
        if (wasPaddedWithHyphen) {
            line = line.substring(1);
        }
        return line;
    }

    public static String redact(String line) {
        return ArgumentRedactor.redact(line, true);
    }

    public static String redact(List<String> args) {
        return ArgumentRedactor.redact(String.join((CharSequence)" ", args));
    }

    public static String redactValueIfNecessary(String key, String value) {
        if (ArgumentRedactor.isTaboo(key)) {
            return redacted;
        }
        return value;
    }

    static boolean isTaboo(String key) {
        if (key == null) {
            return false;
        }
        for (String taboo : tabooForKeyToStartWith) {
            if (!key.toLowerCase().startsWith(taboo)) continue;
            return true;
        }
        for (String taboo : tabooToContain) {
            if (!key.toLowerCase().contains(taboo)) continue;
            return true;
        }
        return false;
    }
}

