/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.tcp.ConnectExceptions;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.MsgStreamer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

class DirectReplySender
implements ReplySender {
    private static final Logger logger = LogService.getLogger();
    private static final DMStats DUMMY_STATS = new LonerDistributionManager.DummyDMStats();
    private final Connection conn;
    private boolean sentReply = false;

    public DirectReplySender(Connection connection) {
        this.conn = connection;
    }

    @Override
    public Set putOutgoing(DistributionMessage msg) {
        Assert.assertTrue(!this.sentReply, "Trying to reply twice to a message");
        this.conn.getConduit().getDM().getCancelCriterion().checkCancelInProgress(null);
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "Sending a direct reply {} to {}", (Object)msg, (Object)this.conn.getRemoteAddress());
        }
        ArrayList<Connection> conns = new ArrayList<Connection>(1);
        conns.add(this.conn);
        MsgStreamer ms = (MsgStreamer)MsgStreamer.create(conns, msg, false, DUMMY_STATS);
        try {
            ms.writeMessage();
            ConnectExceptions ce = ms.getConnectExceptions();
            if (ce != null && !ce.getMembers().isEmpty()) {
                Assert.assertTrue(ce.getMembers().size() == 1);
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DirectChannel_FAILURE_SENDING_DIRECT_REPLY, ce.getMembers().iterator().next()));
                Set set = Collections.singleton(ce.getMembers().iterator().next());
                return set;
            }
            this.sentReply = true;
            Set set = Collections.emptySet();
            return set;
        }
        catch (NotSerializableException e) {
            throw new InternalGemFireException(e);
        }
        catch (IOException ex) {
            throw new InternalGemFireException(LocalizedStrings.DirectChannel_UNKNOWN_ERROR_SERIALIZING_MESSAGE.toLocalizedString(), ex);
        }
        finally {
            try {
                ms.close();
            }
            catch (IOException e) {
                throw new InternalGemFireException("Unknown error serializing message", e);
            }
        }
    }
}

