/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.internal.statistics.StatisticsTypeXml;

public class StatisticsTypeImpl
implements StatisticsType {
    private final String name;
    private final String description;
    private final StatisticDescriptor[] stats;
    private final HashMap statsMap;
    private final int intStatCount;
    private final int longStatCount;
    private final int doubleStatCount;

    public static StatisticsType[] fromXml(Reader reader, StatisticsTypeFactory factory) throws IOException {
        return new StatisticsTypeXml().read(reader, factory);
    }

    public StatisticsTypeImpl(String name, String description, StatisticDescriptor[] stats) {
        this(name, description, stats, false);
    }

    public StatisticsTypeImpl(String name, String description, StatisticDescriptor[] stats, boolean wrapsSharedClass) {
        if (name == null) {
            throw new NullPointerException(LocalizedStrings.StatisticsTypeImpl_CANNOT_HAVE_A_NULL_STATISTICS_TYPE_NAME.toLocalizedString());
        }
        if (stats == null) {
            throw new NullPointerException(LocalizedStrings.StatisticsTypeImpl_CANNOT_HAVE_A_NULL_STATISTIC_DESCRIPTORS.toLocalizedString());
        }
        if (stats.length > 254) {
            throw new IllegalArgumentException(LocalizedStrings.StatisticsTypeImpl_THE_REQUESTED_DESCRIPTOR_COUNT_0_EXCEEDS_THE_MAXIMUM_WHICH_IS_1.toLocalizedString(stats.length, 254));
        }
        this.name = name;
        this.description = description;
        this.stats = stats;
        this.statsMap = new HashMap(stats.length * 2);
        int intCount = 0;
        int longCount = 0;
        int doubleCount = 0;
        for (int i = 0; i < stats.length; ++i) {
            StatisticDescriptorImpl sd = (StatisticDescriptorImpl)stats[i];
            if (sd.getTypeCode() == 5) {
                if (!wrapsSharedClass) {
                    sd.setId(intCount);
                }
                ++intCount;
            } else if (sd.getTypeCode() == 6) {
                if (!wrapsSharedClass) {
                    sd.setId(longCount);
                }
                ++longCount;
            } else if (sd.getTypeCode() == 8) {
                if (!wrapsSharedClass) {
                    sd.setId(doubleCount);
                }
                ++doubleCount;
            }
            StatisticDescriptorImpl previousValue = this.statsMap.put(stats[i].getName(), sd);
            if (previousValue == null) continue;
            throw new IllegalArgumentException(LocalizedStrings.StatisticsTypeImpl_DUPLICATE_STATISTICDESCRIPTOR_NAMED_0.toLocalizedString(stats[i].getName()));
        }
        this.intStatCount = intCount;
        this.longStatCount = longCount;
        this.doubleStatCount = doubleCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public StatisticDescriptor[] getStatistics() {
        return this.stats;
    }

    @Override
    public int nameToId(String name) {
        return this.nameToDescriptor(name).getId();
    }

    @Override
    public StatisticDescriptor nameToDescriptor(String name) {
        StatisticDescriptorImpl stat = (StatisticDescriptorImpl)this.statsMap.get(name);
        if (stat == null) {
            throw new IllegalArgumentException(LocalizedStrings.StatisticsTypeImpl_THERE_IS_NO_STATISTIC_NAMED_0.toLocalizedString(name));
        }
        return stat;
    }

    public int getIntStatCount() {
        return this.intStatCount;
    }

    public int getLongStatCount() {
        return this.longStatCount;
    }

    public int getDoubleStatCount() {
        return this.doubleStatCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("name=").append(this.name);
        sb.append(", description=").append(this.description);
        sb.append(", stats.length=").append(this.stats.length);
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        StatisticDescriptor[] yourStats;
        if (o == null) {
            return false;
        }
        if (!(o instanceof StatisticsType)) {
            return false;
        }
        StatisticsType other = (StatisticsType)o;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        StatisticDescriptor[] myStats = this.getStatistics();
        if (myStats.length != (yourStats = other.getStatistics()).length) {
            return false;
        }
        for (int i = 0; i < myStats.length; ++i) {
            if (myStats[i].equals(yourStats[i])) continue;
            return false;
        }
        return true;
    }
}

