/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.Statistics;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.PureJavaMode;
import org.apache.geode.internal.admin.ListenerIdMap;
import org.apache.geode.internal.admin.remote.StatListenerMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.statistics.HostStatHelper;
import org.apache.geode.internal.statistics.HostStatSampler;
import org.apache.geode.internal.statistics.LocalStatListener;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatSamplerStats;
import org.apache.geode.internal.statistics.StatisticDescriptorImpl;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.platform.OsStatisticsFactory;
import org.apache.geode.internal.statistics.platform.ProcessStats;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class GemFireStatSampler
extends HostStatSampler {
    private static final Logger logger = LogService.getLogger();
    private final ListenerIdMap listeners = new ListenerIdMap();
    private final Map<LocalStatListenerImpl, Boolean> localListeners = new ConcurrentHashMap<LocalStatListenerImpl, Boolean>();
    private final Map<InternalDistributedMember, List<RemoteStatListenerImpl>> recipientToListeners = new HashMap<InternalDistributedMember, List<RemoteStatListenerImpl>>();
    private final InternalDistributedSystem con;
    private int nextListenerId = 1;
    private ProcessStats processStats = null;

    public GemFireStatSampler(InternalDistributedSystem con) {
        super(con.getCancelCriterion(), new StatSamplerStats(con, con.getId()));
        this.con = con;
    }

    public ProcessStats getProcessStats() {
        return this.processStats;
    }

    @Override
    public String getProductDescription() {
        return "GemFire " + GemFireVersion.getGemFireVersion() + " #" + GemFireVersion.getBuildId() + " as of " + GemFireVersion.getSourceDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addListener(InternalDistributedMember recipient, long resourceId, String statName) {
        int result = this.getNextListenerId();
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            while (this.listeners.get(result) != null) {
                result = this.getNextListenerId();
            }
            RemoteStatListenerImpl sl = RemoteStatListenerImpl.create(result, recipient, resourceId, statName, this);
            this.listeners.put(result, sl);
            List<RemoteStatListenerImpl> l = this.recipientToListeners.get(recipient);
            if (l == null) {
                l = new ArrayList<RemoteStatListenerImpl>();
                this.recipientToListeners.put(recipient, l);
            }
            l.add(sl);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(int listenerId) {
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            RemoteStatListenerImpl sl = (RemoteStatListenerImpl)this.listeners.remove(listenerId);
            if (sl != null) {
                List<RemoteStatListenerImpl> l = this.recipientToListeners.get(sl.getRecipient());
                l.remove(sl);
            }
            return sl != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListenersByRecipient(InternalDistributedMember recipient) {
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            List<RemoteStatListenerImpl> l = this.recipientToListeners.get(recipient);
            if (l != null && l.size() != 0) {
                for (RemoteStatListenerImpl sl : l) {
                    this.listeners.remove(sl.getListenerId());
                }
                this.recipientToListeners.remove(recipient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalStatListener(LocalStatListener l, Statistics stats, String statName) {
        LocalStatListenerImpl sl = null;
        Class<LocalStatListenerImpl> clazz = LocalStatListenerImpl.class;
        synchronized (LocalStatListenerImpl.class) {
            sl = LocalStatListenerImpl.create(l, stats, statName);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.localListeners.put(sl, Boolean.TRUE);
            return;
        }
    }

    public boolean removeLocalStatListener(LocalStatListener listener) {
        Iterator<Map.Entry<LocalStatListenerImpl, Boolean>> it = this.localListeners.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<LocalStatListenerImpl, Boolean> entry = it.next();
            if (!listener.equals(entry.getKey().getListener())) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public Set<LocalStatListenerImpl> getLocalListeners() {
        return this.localListeners.keySet();
    }

    @Override
    public File getArchiveFileName() {
        return this.con.getConfig().getStatisticArchiveFile();
    }

    @Override
    public long getArchiveFileSizeLimit() {
        if (this.fileSizeLimitInKB()) {
            return (long)this.con.getConfig().getArchiveFileSizeLimit() * 1024L;
        }
        return (long)this.con.getConfig().getArchiveFileSizeLimit() * 0x100000L;
    }

    @Override
    public long getArchiveDiskSpaceLimit() {
        if (this.fileSizeLimitInKB()) {
            return (long)this.con.getConfig().getArchiveDiskSpaceLimit() * 1024L;
        }
        return (long)this.con.getConfig().getArchiveDiskSpaceLimit() * 0x100000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkListeners() {
        this.checkLocalListeners();
        ListenerIdMap listenerIdMap = this.listeners;
        synchronized (listenerIdMap) {
            if (this.listeners.size() == 0) {
                return;
            }
            long timeStamp = System.currentTimeMillis();
            Iterator<Map.Entry<InternalDistributedMember, List<RemoteStatListenerImpl>>> it1 = this.recipientToListeners.entrySet().iterator();
            while (it1.hasNext()) {
                if (this.stopRequested()) {
                    return;
                }
                Map.Entry<InternalDistributedMember, List<RemoteStatListenerImpl>> me = it1.next();
                List<RemoteStatListenerImpl> l = me.getValue();
                if (l.size() <= 0) continue;
                InternalDistributedMember recipient = me.getKey();
                StatListenerMessage msg = StatListenerMessage.create(timeStamp, l.size());
                msg.setRecipient(recipient);
                for (RemoteStatListenerImpl statListener : l) {
                    if (this.getStatisticsManager().statisticsExists(statListener.getStatId())) {
                        statListener.checkForChange(msg);
                        continue;
                    }
                    msg.addChange(-statListener.getListenerId(), 0.0);
                }
                this.con.getDistributionManager().putOutgoing(msg);
            }
        }
    }

    @Override
    protected int getSampleRate() {
        return this.con.getConfig().getStatisticSampleRate();
    }

    @Override
    public boolean isSamplingEnabled() {
        return this.con.getConfig().getStatisticSamplingEnabled();
    }

    @Override
    protected StatisticsManager getStatisticsManager() {
        return this.con;
    }

    @Override
    protected OsStatisticsFactory getOsStatisticsFactory() {
        return this.con;
    }

    @Override
    protected long getSpecialStatsId() {
        long statId = OSProcess.getId();
        if (statId == 0L || statId == -1L) {
            statId = this.getStatisticsManager().getId();
        }
        return statId;
    }

    @Override
    protected void initProcessStats(long id) {
        if (PureJavaMode.osStatsAreAvailable()) {
            if (this.osStatsDisabled()) {
                logger.info(LogMarker.STATISTICS, (Message)LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_OS_STATISTIC_COLLECTION_DISABLED_BY_OSSTATSDISABLED_SYSTEM_PROPERTY));
            } else {
                int retVal = HostStatHelper.initOSStats();
                if (retVal != 0) {
                    logger.error(LogMarker.STATISTICS, (Message)LocalizedMessage.create(LocalizedStrings.GemFireStatSampler_OS_STATISTICS_FAILED_TO_INITIALIZE_PROPERLY_SOME_STATS_MAY_BE_MISSING_SEE_BUGNOTE_37160));
                }
                HostStatHelper.newSystem(this.getOsStatisticsFactory());
                String statName = this.getStatisticsManager().getName();
                if (statName == null || statName.length() == 0) {
                    statName = "javaApp" + this.getStatisticsManager().getId();
                }
                Statistics stats = HostStatHelper.newProcess(this.getOsStatisticsFactory(), id, statName + "-proc");
                this.processStats = HostStatHelper.newProcessStats(stats);
            }
        }
    }

    @Override
    protected void sampleProcessStats(boolean prepareOnly) {
        if (prepareOnly || this.osStatsDisabled() || !PureJavaMode.osStatsAreAvailable()) {
            return;
        }
        List<Statistics> l = this.getStatisticsManager().getStatsList();
        if (l == null) {
            return;
        }
        if (this.stopRequested()) {
            return;
        }
        HostStatHelper.readyRefreshOSStats();
        Iterator<Statistics> it = l.iterator();
        while (it.hasNext()) {
            if (this.stopRequested()) {
                return;
            }
            StatisticsImpl s = (StatisticsImpl)it.next();
            if (!s.usesSystemCalls()) continue;
            HostStatHelper.refresh((LocalStatisticsImpl)s);
        }
    }

    @Override
    protected void closeProcessStats() {
        if (PureJavaMode.osStatsAreAvailable() && !this.osStatsDisabled()) {
            if (this.processStats != null) {
                this.processStats.close();
            }
            HostStatHelper.closeOSStats();
        }
    }

    private void checkLocalListeners() {
        for (LocalStatListenerImpl st : this.localListeners.keySet()) {
            if (!this.getStatisticsManager().statisticsExists(st.getStatId())) continue;
            st.checkForChange();
        }
    }

    private int getNextListenerId() {
        int result = this.nextListenerId++;
        if (this.nextListenerId < 0) {
            this.nextListenerId = 1;
        }
        return result;
    }

    protected static class DoubleStatListenerImpl
    extends RemoteStatListenerImpl {
        protected DoubleStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return Double.longBitsToDouble(bits);
        }
    }

    protected static class FloatStatListenerImpl
    extends RemoteStatListenerImpl {
        protected FloatStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return Float.intBitsToFloat((int)bits);
        }
    }

    protected static class LongStatListenerImpl
    extends RemoteStatListenerImpl {
        protected LongStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return bits;
        }
    }

    protected static abstract class RemoteStatListenerImpl
    extends StatListenerImpl {
        private int listenerId;
        private InternalDistributedMember recipient;

        protected RemoteStatListenerImpl() {
        }

        public int hashCode() {
            return this.listenerId;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof RemoteStatListenerImpl) {
                return this.listenerId == ((RemoteStatListenerImpl)o).listenerId;
            }
            return false;
        }

        public int getListenerId() {
            return this.listenerId;
        }

        public InternalDistributedMember getRecipient() {
            return this.recipient;
        }

        static RemoteStatListenerImpl create(int listenerId, InternalDistributedMember recipient, long resourceId, String statName, HostStatSampler sampler) {
            RemoteStatListenerImpl result = null;
            Statistics stats = sampler.getStatisticsManager().findStatistics(resourceId);
            StatisticDescriptorImpl stat = (StatisticDescriptorImpl)stats.nameToDescriptor(statName);
            switch (stat.getTypeCode()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    result = new LongStatListenerImpl();
                    break;
                }
                case 7: {
                    result = new FloatStatListenerImpl();
                    break;
                }
                case 8: {
                    result = new DoubleStatListenerImpl();
                    break;
                }
                default: {
                    throw new RuntimeException(LocalizedStrings.GemFireStatSampler_ILLEGAL_FIELD_TYPE_0_FOR_STATISTIC.toLocalizedString(stats.getType()));
                }
            }
            result.stats = stats;
            result.stat = stat;
            result.listenerId = listenerId;
            result.recipient = recipient;
            return result;
        }

        public void checkForChange(StatListenerMessage msg) {
            long currentValue = this.stats.getRawBits(this.stat);
            if (this.oldValueInitialized) {
                if (currentValue == this.oldValue) {
                    return;
                }
            } else {
                this.oldValueInitialized = true;
            }
            this.oldValue = currentValue;
            msg.addChange(this.listenerId, this.getBitsAsDouble(currentValue));
        }
    }

    protected static class LocalDoubleStatListenerImpl
    extends LocalStatListenerImpl {
        protected LocalDoubleStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return Double.longBitsToDouble(bits);
        }
    }

    protected static class LocalFloatStatListenerImpl
    extends LocalStatListenerImpl {
        protected LocalFloatStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return Float.intBitsToFloat((int)bits);
        }
    }

    protected static class LocalLongStatListenerImpl
    extends LocalStatListenerImpl {
        protected LocalLongStatListenerImpl() {
        }

        @Override
        protected double getBitsAsDouble(long bits) {
            return bits;
        }
    }

    protected static abstract class LocalStatListenerImpl
    extends StatListenerImpl {
        private LocalStatListener listener;

        protected LocalStatListenerImpl() {
        }

        public LocalStatListener getListener() {
            return this.listener;
        }

        static LocalStatListenerImpl create(LocalStatListener l, Statistics stats, String statName) {
            LocalStatListenerImpl result = null;
            StatisticDescriptorImpl stat = (StatisticDescriptorImpl)stats.nameToDescriptor(statName);
            switch (stat.getTypeCode()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    result = new LocalLongStatListenerImpl();
                    break;
                }
                case 7: {
                    result = new LocalFloatStatListenerImpl();
                    break;
                }
                case 8: {
                    result = new LocalDoubleStatListenerImpl();
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal field type " + stats.getType() + " for statistic");
                }
            }
            result.stats = stats;
            result.stat = stat;
            result.listener = l;
            return result;
        }

        public void checkForChange() {
            long currentValue = this.stats.getRawBits(this.stat);
            if (this.oldValueInitialized) {
                if (currentValue == this.oldValue) {
                    return;
                }
            } else {
                this.oldValueInitialized = true;
            }
            this.oldValue = currentValue;
            this.listener.statValueChanged(this.getBitsAsDouble(currentValue));
        }
    }

    protected static abstract class StatListenerImpl {
        protected Statistics stats;
        protected StatisticDescriptorImpl stat;
        protected boolean oldValueInitialized = false;
        protected long oldValue;

        protected StatListenerImpl() {
        }

        public long getStatId() {
            if (this.stats.isClosed()) {
                return -1L;
            }
            return this.stats.getUniqueId();
        }

        protected abstract double getBitsAsDouble(long var1);
    }
}

