/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog;

import java.util.regex.Pattern;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.sequencelog.GraphType;
import org.apache.geode.internal.sequencelog.SequenceLogger;
import org.apache.geode.internal.sequencelog.SequenceLoggerImpl;

public class MembershipLogger {
    private static final SequenceLogger GRAPH_LOGGER = SequenceLoggerImpl.getInstance();
    private static final Pattern ALL = Pattern.compile(".*");

    public static void logCrash(InternalDistributedMember member) {
        GRAPH_LOGGER.logTransition(GraphType.MEMBER, "member", "crash", "destroyed", member, member);
        GRAPH_LOGGER.logTransition(GraphType.REGION, ALL, "crash", "destroyed", member, member);
        GRAPH_LOGGER.logTransition(GraphType.KEY, ALL, "crash", "destroyed", member, member);
        GRAPH_LOGGER.logTransition(GraphType.MESSAGE, ALL, "crash", "destroyed", member, member);
    }

    public static void logStartup(InternalDistributedMember member) {
        GRAPH_LOGGER.logTransition(GraphType.MEMBER, "member", "start", "running", member, member);
    }

    public static void logShutdown(InternalDistributedMember member) {
        GRAPH_LOGGER.logTransition(GraphType.MEMBER, "member", "stop", "destroyed", member, member);
    }
}

