/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.lang;

import java.util.Optional;

public class SystemPropertyHelper {
    private static final String GEODE_PREFIX = "geode.";
    private static final String GEMFIRE_PREFIX = "gemfire.";
    public static final String EVICTION_SCAN_ASYNC = "EvictionScanAsync";
    public static final String EVICTION_SCAN_MAX_THREADS = "EvictionScanMaxThreads";
    public static final String EVICTION_SCAN_THRESHOLD_PERCENT = "EvictionScanThresholdPercent";
    public static final String EVICTION_SEARCH_MAX_ENTRIES = "lru.maxSearchEntries";

    public static Optional<Boolean> getProductBooleanProperty(String name) {
        String property = SystemPropertyHelper.getProperty(name);
        return property != null ? Optional.of(Boolean.parseBoolean(property)) : Optional.empty();
    }

    public static Optional<Integer> getProductIntegerProperty(String name) {
        Integer propertyValue = Integer.getInteger(GEODE_PREFIX + name);
        if (propertyValue == null) {
            propertyValue = Integer.getInteger(GEMFIRE_PREFIX + name);
        }
        if (propertyValue != null) {
            return Optional.of(propertyValue);
        }
        return Optional.empty();
    }

    private static String getProperty(String name) {
        String property = SystemPropertyHelper.getGeodeProperty(name);
        return property != null ? property : SystemPropertyHelper.getGemfireProperty(name);
    }

    private static String getGeodeProperty(String name) {
        return System.getProperty(GEODE_PREFIX + name);
    }

    private static String getGemfireProperty(String name) {
        return System.getProperty(GEMFIRE_PREFIX + name);
    }

    public static boolean restoreSetOperationTransactionBehavior() {
        return SystemPropertyHelper.getProductBooleanProperty("restoreSetOperationTransactionBehavior").orElse(false);
    }

    public static boolean restoreIdleExpirationBehavior() {
        return SystemPropertyHelper.getProductBooleanProperty("restoreIdleExpirationBehavior").orElse(false);
    }
}

