/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import org.apache.geode.cache.wan.GatewayTransportFilter;

public class TransportFilterSocket
extends Socket {
    private InputStream in;
    private OutputStream out;
    private List<GatewayTransportFilter> gatewayTransportFilters;

    public TransportFilterSocket(List<GatewayTransportFilter> transportFilters) {
        this.gatewayTransportFilters = transportFilters;
    }

    public TransportFilterSocket(List<GatewayTransportFilter> transportFilters, InetAddress host, int port) throws IOException {
        super(host, port);
        this.gatewayTransportFilters = transportFilters;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = super.getInputStream();
            for (GatewayTransportFilter filter : this.gatewayTransportFilters) {
                this.in = filter.getInputStream(this.in);
            }
        }
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = super.getOutputStream();
            for (GatewayTransportFilter filter : this.gatewayTransportFilters) {
                this.out = filter.getOutputStream(this.out);
            }
        }
        return this.out;
    }

    @Override
    public synchronized void close() throws IOException {
        OutputStream o = this.getOutputStream();
        o.flush();
        super.close();
    }
}

