/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.AbstractPeerTXRegionStub;
import org.apache.geode.internal.cache.tx.RemoteContainsKeyValueMessage;
import org.apache.geode.internal.cache.tx.RemoteDestroyMessage;
import org.apache.geode.internal.cache.tx.RemoteFetchEntryMessage;
import org.apache.geode.internal.cache.tx.RemoteGetMessage;
import org.apache.geode.internal.cache.tx.RemoteInvalidateMessage;
import org.apache.geode.internal.cache.tx.RemotePutAllMessage;
import org.apache.geode.internal.cache.tx.RemotePutMessage;
import org.apache.geode.internal.cache.tx.RemoteRemoveAllMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class DistributedTXRegionStub
extends AbstractPeerTXRegionStub {
    private final DistributedRegion region;

    public DistributedTXRegionStub(TXStateStub txstate, DistributedRegion r) {
        super(txstate);
        this.region = r;
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        try {
            RemoteDestroyMessage.RemoteDestroyReplyProcessor response = RemoteDestroyMessage.send(this.state.getTarget(), event.getRegion(), event, expectedOldValue, true, false);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, boolean allowTombstone) {
        try {
            RemoteFetchEntryMessage.FetchEntryResponse res = RemoteFetchEntryMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, keyInfo.getKey());
            return res.waitForResponse();
        }
        catch (EntryNotFoundException enfe) {
            return null;
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (CacheException | RemoteOperationException e) {
            throw new TransactionDataNodeHasDepartedException(e);
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        try {
            RemoteInvalidateMessage.InvalidateResponse response = RemoteInvalidateMessage.send(this.state.getTarget(), event.getRegion(), event, true, false);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo) {
        try {
            RemoteContainsKeyValueMessage.RemoteContainsKeyValueResponse response = RemoteContainsKeyValueMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, keyInfo.getKey(), false);
            return response.waitForContainsResult();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo) {
        try {
            RemoteContainsKeyValueMessage.RemoteContainsKeyValueResponse response = RemoteContainsKeyValueMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, keyInfo.getKey(), true);
            return response.waitForContainsResult();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public Object findObject(KeyInfo keyInfo, boolean isCreate, boolean generateCallbacks, Object value, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent) {
        Object retVal = null;
        Object key = keyInfo.getKey();
        Object callbackArgument = keyInfo.getCallbackArg();
        try {
            RemoteGetMessage.RemoteGetResponse response = RemoteGetMessage.send((InternalDistributedMember)this.state.getTarget(), this.region, key, callbackArgument, requestingClient);
            retVal = response.waitForResponse(preferCD);
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
        return retVal;
    }

    @Override
    public Object getEntryForIterator(KeyInfo keyInfo, boolean allowTombstone) {
        return this.getEntry(keyInfo, allowTombstone);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        boolean retVal = false;
        LocalRegion r = event.getRegion();
        try {
            RemotePutMessage.RemotePutResponse response = RemotePutMessage.txSend(this.state.getTarget(), r, event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue);
            RemotePutMessage.PutResult result = response.waitForResult();
            event.setOldValue(result.oldValue, true);
            retVal = result.returnValue;
        }
        catch (TransactionDataNotColocatedException enfe) {
            throw enfe;
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (CacheException | RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
        return retVal;
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, LocalRegion region) {
        try {
            RemotePutAllMessage.PutAllResponse response = RemotePutAllMessage.send(this.state.getTarget(), putallOp.getBaseEvent(), putallOp.getPutAllEntryData(), putallOp.getPutAllEntryData().length, true, false);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, LocalRegion region) {
        try {
            RemoteRemoveAllMessage.RemoveAllResponse response = RemoteRemoveAllMessage.send(this.state.getTarget(), op.getBaseEvent(), op.getRemoveAllEntryData(), op.getRemoveAllEntryData().length, true, false);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(LocalizedStrings.RemoteMessage_REGION_0_NOT_COLOCATED_WITH_TRANSACTION.toLocalizedString(rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    protected InternalRegion getRegion() {
        return this.region;
    }
}

