/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;

public class Size
extends BaseCommand {
    private static final Size singleton = new Size();

    private Size() {
    }

    public static Command getCommand() {
        return singleton;
    }

    private static void writeSizeResponse(Integer sizeCount, Message origMsg, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setNumberOfParts(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        responseMsg.addObjPart(sizeCount);
        responseMsg.send(servConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        StringBuilder errMessage = new StringBuilder();
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadSizeRequestTime(start - oldStart);
        Part regionNamePart = clientMessage.getPart(0);
        String regionName = regionNamePart.getString();
        if (regionName == null) {
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL, "size"));
            errMessage.append(LocalizedStrings.BaseCommand__THE_INPUT_REGION_NAME_FOR_THE_0_REQUEST_IS_NULL.toLocalizedString("size"));
            Size.writeErrorResponse(clientMessage, 82, errMessage.toString(), serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
        if (region == null) {
            String reason = LocalizedStrings.BaseCommand__0_WAS_NOT_FOUND_DURING_1_REQUEST.toLocalizedString(regionName, "size");
            Size.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            Size.writeSizeResponse(region.size(), clientMessage, serverConnection);
        }
        catch (RegionDestroyedException rde) {
            Size.writeException(clientMessage, rde, false, serverConnection);
        }
        catch (Exception e) {
            Size.checkForInterrupt(serverConnection, e);
            Size.writeException(clientMessage, e, false, serverConnection);
            if (e instanceof GemFireSecurityException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)e);
                }
            } else {
                logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.BaseCommand_0_UNEXPECTED_EXCEPTION, serverConnection.getName()), (Throwable)e);
            }
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Sent size response for region {}", (Object)serverConnection.getName(), (Object)regionName);
            }
            serverConnection.setAsTrue(1);
            stats.incWriteSizeResponseTime(DistributionStats.getStatTime() - start);
        }
    }
}

