/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutAllOperationContext;
import org.apache.geode.cache.operations.internal.UpdateOnlyMap;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class PutAll
extends BaseCommand {
    private static final PutAll singleton = new PutAll();

    public static Command getCommand() {
        return singleton;
    }

    private PutAll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        Part regionNamePart = null;
        Part numberOfKeysPart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        int numberOfKeys = 0;
        Object key = null;
        Part eventPart = null;
        StringBuilder errMessage = new StringBuilder();
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        boolean replyWithMetaData = false;
        serverConnection.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadPutAllRequestTime(start - oldStart);
        try {
            PartitionedRegion pr;
            regionNamePart = clientMessage.getPart(0);
            regionName = regionNamePart.getString();
            if (regionName == null) {
                String putAllMsg = LocalizedStrings.PutAll_THE_INPUT_REGION_NAME_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)putAllMsg);
                errMessage.append(putAllMsg);
                PutAll.writeErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = " was not found during put request";
                PutAll.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            eventPart = clientMessage.getPart(1);
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
            numberOfKeysPart = clientMessage.getPart(2);
            numberOfKeys = numberOfKeysPart.getInt();
            Map<Object, byte[]> map = new LinkedHashMap();
            for (int i = 0; i < numberOfKeys; ++i) {
                String putAllMsg;
                keyPart = clientMessage.getPart(3 + i * 2);
                key = keyPart.getStringOrObject();
                if (key == null) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_KEYS_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll.writeErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
                valuePart = clientMessage.getPart(3 + i * 2 + 1);
                if (valuePart.isNull()) {
                    putAllMsg = LocalizedStrings.PutAll_ONE_OF_THE_INPUT_VALUES_FOR_THE_PUTALL_REQUEST_IS_NULL.toLocalizedString();
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)putAllMsg);
                    errMessage.append(putAllMsg);
                    PutAll.writeErrorResponse(clientMessage, 8, errMessage.toString(), serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
                Object value = valuePart.isObject() ? (Object)CachedDeserializableFactory.create(valuePart.getSerializedForm(), region.getCache()) : valuePart.getSerializedForm();
                map.put(key, (byte[])value);
            }
            if (clientMessage.getNumberOfParts() == 3 + 2 * numberOfKeys + 1) {
                int timeout = clientMessage.getPart(3 + 2 * numberOfKeys).getInt();
                serverConnection.setRequestSpecificTimeout(timeout);
            }
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    authzRequest.createRegionAuthorize(regionName);
                } else {
                    PutAllOperationContext putAllContext = authzRequest.putAllAuthorize(regionName, map, null);
                    if ((map = putAllContext.getMap()) instanceof UpdateOnlyMap) {
                        map = ((UpdateOnlyMap)map).getInternalMap();
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: Received putAll request ({} bytes) from {} for region {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName);
            }
            region.basicBridgePutAll(map, Collections.emptyMap(), serverConnection.getProxyID(), eventId, false, null);
            if (region instanceof PartitionedRegion && (pr = (PartitionedRegion)region).getNetworkHopType() != 0) {
                this.writeReplyWithRefreshMetadata(clientMessage, serverConnection, pr, pr.getNetworkHopType());
                pr.clearNetworkHopData();
                replyWithMetaData = true;
            }
        }
        catch (RegionDestroyedException rde) {
            PutAll.writeException(clientMessage, rde, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (ResourceException re) {
            PutAll.writeException(clientMessage, re, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (PutAllPartialResultException pre) {
            PutAll.writeException(clientMessage, pre, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        catch (Exception ce) {
            PutAll.checkForInterrupt(serverConnection, ce);
            PutAll.writeException(clientMessage, ce, false, serverConnection);
            serverConnection.setAsTrue(1);
            logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Generic_0_UNEXPECTED_EXCEPTION, serverConnection.getName()), (Throwable)ce);
            return;
        }
        finally {
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incProcessPutAllTime(start - oldStart2);
        }
        if (!replyWithMetaData) {
            this.writeReply(clientMessage, serverConnection);
        }
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent putAll response back to {} for region {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)regionName);
        }
        stats.incWritePutAllResponseTime(DistributionStats.getStatTime() - start);
    }
}

