/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.ResourceException;
import org.apache.geode.cache.operations.PutOperationContext;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.EventIDHolder;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.geode.security.ResourcePermission;

public class Put
extends BaseCommand {
    private static final Put singleton = new Put();

    public static Command getCommand() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        CacheServerStats stats;
        Object key;
        String regionName;
        Part valuePart;
        block29: {
            Part regionNamePart = null;
            Part keyPart = null;
            valuePart = null;
            Part callbackArgPart = null;
            regionName = null;
            Object callbackArg = null;
            key = null;
            Part eventPart = null;
            String errMessage = "";
            CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
            stats = serverConnection.getCacheServerStats();
            serverConnection.setAsTrue(2);
            long oldStart = start;
            start = DistributionStats.getStatTime();
            stats.incReadPutRequestTime(start - oldStart);
            regionNamePart = clientMessage.getPart(0);
            keyPart = clientMessage.getPart(1);
            valuePart = clientMessage.getPart(2);
            eventPart = clientMessage.getPart(3);
            if (clientMessage.getNumberOfParts() > 4) {
                callbackArgPart = clientMessage.getPart(4);
                try {
                    callbackArg = callbackArgPart.getObject();
                }
                catch (Exception e) {
                    Put.writeException(clientMessage, e, false, serverConnection);
                    serverConnection.setAsTrue(1);
                    return;
                }
            }
            regionName = regionNamePart.getString();
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                Put.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Received put request ({} bytes) from {} for region {} key {} value {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)valuePart);
            }
            if (key == null || regionName == null) {
                if (key == null) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Put_0_THE_INPUT_KEY_FOR_THE_PUT_REQUEST_IS_NULL, serverConnection.getName()));
                    errMessage = LocalizedStrings.Put_THE_INPUT_KEY_FOR_THE_PUT_REQUEST_IS_NULL.toLocalizedString();
                }
                if (regionName == null) {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Put_0_THE_INPUT_REGION_NAME_FOR_THE_PUT_REQUEST_IS_NULL, serverConnection.getName()));
                    errMessage = LocalizedStrings.Put_THE_INPUT_REGION_NAME_FOR_THE_PUT_REQUEST_IS_NULL.toLocalizedString();
                }
                Put.writeErrorResponse(clientMessage, 8, errMessage, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            LocalRegion region = (LocalRegion)serverConnection.getCache().getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Put_REGION_WAS_NOT_FOUND_DURING_PUT_REQUEST.toLocalizedString();
                Put.writeRegionDestroyedEx(clientMessage, regionName, reason, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            if (valuePart.isNull() && region.containsKey(key)) {
                logger.info((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.Put_0_ATTEMPTED_TO_PUT_A_NULL_VALUE_FOR_EXISTING_KEY_1, new Object[]{serverConnection.getName(), key}));
                errMessage = LocalizedStrings.Put_ATTEMPTED_TO_PUT_A_NULL_VALUE_FOR_EXISTING_KEY_0.toLocalizedString();
                Put.writeErrorResponse(clientMessage, 8, errMessage, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
            long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
            EventID eventId = new EventID(serverConnection.getEventMemberIDByteArray(), threadId, sequenceId);
            try {
                byte[] value = valuePart.getSerializedForm();
                boolean isObject = valuePart.isObject();
                securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionName, key.toString());
                AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
                if (authzRequest != null) {
                    if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                        authzRequest.createRegionAuthorize((String)key);
                    } else if (!region.isUsedForMetaRegion()) {
                        PutOperationContext putContext = authzRequest.putAuthorize(regionName, key, value, isObject, callbackArg);
                        value = putContext.getSerializedValue();
                        isObject = putContext.isObject();
                        callbackArg = putContext.getCallbackArg();
                    }
                }
                boolean result = false;
                result = value == null ? region.basicBridgeCreate(key, null, true, callbackArg, serverConnection.getProxyID(), true, new EventIDHolder(eventId), false) : region.basicBridgePut(key, value, null, isObject, callbackArg, serverConnection.getProxyID(), true, new EventIDHolder(eventId));
                if (result) {
                    serverConnection.setModificationInfo(true, regionName, key);
                    break block29;
                }
                StringId message = LocalizedStrings.PUT_0_FAILED_TO_PUT_ENTRY_FOR_REGION_1_KEY_2_VALUE_3;
                Object[] messageArgs = new Object[]{serverConnection.getName(), regionName, key, valuePart};
                String s = message.toLocalizedString(messageArgs);
                logger.info(s);
                throw new Exception(s);
            }
            catch (RegionDestroyedException rde) {
                Put.writeException(clientMessage, rde, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            catch (ResourceException re) {
                Put.writeException(clientMessage, re, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            catch (Exception ce) {
                Put.checkForInterrupt(serverConnection, ce);
                Put.writeException(clientMessage, ce, false, serverConnection);
                serverConnection.setAsTrue(1);
                if (ce instanceof GemFireSecurityException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Unexpected Security exception", (Object)serverConnection.getName(), (Object)ce);
                    }
                } else {
                    logger.warn((org.apache.logging.log4j.message.Message)LocalizedMessage.create(LocalizedStrings.PUT_0_UNEXPECTED_EXCEPTION, serverConnection.getName()), (Throwable)ce);
                }
                return;
            }
            finally {
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessPutTime(start - oldStart2);
            }
        }
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent put response back to {} for region {} key {} value {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)regionName, key, (Object)valuePart);
        }
        stats.incWritePutResponseTime(DistributionStats.getStatTime() - start);
    }
}

