/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.snapshot.SnapshotIterator;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.snapshot.ExportedRegistry;
import org.apache.geode.internal.cache.snapshot.SnapshotPacket;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

public class GFSnapshot {
    public static final int SNAP_VER_1 = 1;
    public static final int SNAP_VER_2 = 2;
    private static final byte[] SNAP_FMT = new byte[]{71, 70, 83};

    private GFSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: GFSnapshot <file>");
            ExitCode.FATAL.doSystemExit();
        }
        try (GFSnapshotImporter imp = new GFSnapshotImporter(new File(args[0]), null);){
            SnapshotPacket.SnapshotRecord snapshotRecord;
            System.out.println("Snapshot format is version " + imp.getVersion());
            System.out.println("Snapshot region is " + imp.getRegionName());
            ExportedRegistry reg = imp.getPdxTypes();
            Map<Integer, PdxType> types = reg.types();
            System.out.println("Found " + types.size() + " PDX types:");
            for (Map.Entry<Integer, PdxType> entry : types.entrySet()) {
                System.out.println("\t" + entry.getKey() + " = " + entry.getValue());
            }
            Map<Integer, EnumInfo> enums = reg.enums();
            System.out.println("Found " + enums.size() + " PDX enums: ");
            for (Map.Entry<Integer, EnumInfo> entry : enums.entrySet()) {
                System.out.println("\t" + entry.getKey() + " = " + entry.getValue());
            }
            System.out.println();
            while ((snapshotRecord = imp.readSnapshotRecord()) != null) {
                System.out.println(snapshotRecord.getKeyObject() + " = " + snapshotRecord.getValueObject());
            }
        }
    }

    public static SnapshotWriter create(File snapshot, String region, InternalCache cache) throws IOException {
        final GFSnapshotExporter out = new GFSnapshotExporter(snapshot, region, cache);
        return new SnapshotWriter(){

            @Override
            public void snapshotEntry(SnapshotPacket.SnapshotRecord entry) throws IOException {
                out.writeSnapshotEntry(entry);
            }

            @Override
            public void snapshotComplete() throws IOException {
                out.close();
            }
        };
    }

    public static <K, V> SnapshotIterator<K, V> read(final File snapshot, final TypeRegistry typeRegistry) throws IOException, ClassNotFoundException {
        return new SnapshotIterator<K, V>(){
            GFSnapshotImporter in;
            private boolean foundNext;
            private Map.Entry<K, V> next;
            {
                this.in = new GFSnapshotImporter(snapshot, typeRegistry);
            }

            @Override
            public boolean hasNext() throws IOException, ClassNotFoundException {
                if (!this.foundNext) {
                    return this.moveNext();
                }
                return true;
            }

            @Override
            public Map.Entry<K, V> next() throws IOException, ClassNotFoundException {
                if (!this.foundNext && !this.moveNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry result = this.next;
                this.foundNext = false;
                this.next = null;
                return result;
            }

            @Override
            public void close() throws IOException {
                this.in.close();
            }

            private boolean moveNext() throws IOException, ClassNotFoundException {
                SnapshotPacket.SnapshotRecord record = this.in.readSnapshotRecord();
                if (record != null) {
                    this.foundNext = true;
                    final Object key = record.getKeyObject();
                    final Object value = record.getValueObject();
                    this.next = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key;
                        }

                        @Override
                        public V getValue() {
                            return value;
                        }

                        @Override
                        public V setValue(V value2) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    static class GFSnapshotImporter {
        private final byte version;
        private final String region;
        private final ExportedRegistry pdx;
        private final DataInputStream dis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GFSnapshotImporter(File in, TypeRegistry typeRegistry) throws IOException, ClassNotFoundException {
            long entryPosition;
            block7: {
                this.pdx = new ExportedRegistry();
                FileInputStream fis = new FileInputStream(in);
                FileChannel fc = fis.getChannel();
                try (DataInputStream tmp = new DataInputStream(fis);){
                    this.version = tmp.readByte();
                    if (this.version == 1) {
                        throw new IOException(LocalizedStrings.Snapshot_UNSUPPORTED_SNAPSHOT_VERSION_0.toLocalizedString(1) + ": " + in);
                    }
                    if (this.version == 2) {
                        byte[] format = new byte[3];
                        tmp.readFully(format);
                        if (!Arrays.equals(format, SNAP_FMT)) {
                            throw new IOException(LocalizedStrings.Snapshot_UNRECOGNIZED_FILE_TYPE_0.toLocalizedString(Arrays.toString(format)) + ": " + in);
                        }
                        long registryPosition = tmp.readLong();
                        this.region = tmp.readUTF();
                        entryPosition = fc.position();
                        if (registryPosition != -1L) {
                            fc.position(registryPosition);
                            this.pdx.fromData(tmp);
                        }
                        break block7;
                    }
                    throw new IOException(LocalizedStrings.Snapshot_UNRECOGNIZED_FILE_VERSION_0.toLocalizedString(this.version) + ": " + in);
                }
            }
            this.checkPdxTypeCompatibility(typeRegistry);
            this.checkPdxEnumCompatibility(typeRegistry);
            this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(in)));
            this.dis.skip(entryPosition);
        }

        public byte getVersion() {
            return this.version;
        }

        public String getRegionName() {
            return this.region;
        }

        public ExportedRegistry getPdxTypes() {
            return this.pdx;
        }

        public SnapshotPacket.SnapshotRecord readSnapshotRecord() throws IOException, ClassNotFoundException {
            byte[] key = DataSerializer.readByteArray(this.dis);
            if (key == null) {
                return null;
            }
            byte[] value = DataSerializer.readByteArray(this.dis);
            return new SnapshotPacket.SnapshotRecord(key, value);
        }

        public void close() throws IOException {
            this.dis.close();
        }

        private void checkPdxTypeCompatibility(TypeRegistry tr) {
            if (tr == null) {
                return;
            }
            for (Map.Entry<Integer, PdxType> entry : this.pdx.types().entrySet()) {
                tr.addImportedType(entry.getKey(), entry.getValue());
            }
        }

        private void checkPdxEnumCompatibility(TypeRegistry tr) {
            if (tr == null) {
                return;
            }
            for (Map.Entry<Integer, EnumInfo> entry : this.pdx.enums().entrySet()) {
                tr.addImportedEnum(entry.getKey(), entry.getValue());
            }
        }
    }

    static class GFSnapshotExporter {
        private final FileChannel fc;
        private final DataOutputStream dos;
        private final InternalCache cache;

        public GFSnapshotExporter(File out, String region, InternalCache cache) throws IOException {
            this.cache = cache;
            FileOutputStream fos = new FileOutputStream(out);
            this.fc = fos.getChannel();
            this.dos = new DataOutputStream(new BufferedOutputStream(fos));
            this.dos.writeByte(2);
            this.dos.write(SNAP_FMT);
            this.dos.writeLong(-1L);
            this.dos.writeUTF(region);
        }

        public void writeSnapshotEntry(SnapshotPacket.SnapshotRecord entry) throws IOException {
            InternalDataSerializer.invokeToData(entry, this.dos);
        }

        public void close() throws IOException {
            DataSerializer.writeByteArray(null, this.dos);
            this.dos.flush();
            long registryPosition = this.fc.position();
            try {
                new ExportedRegistry(this.cache.getPdxRegistry()).toData(this.dos);
            }
            catch (CacheClosedException e) {
                new ExportedRegistry().toData(this.dos);
            }
            this.dos.flush();
            this.fc.position(4L);
            this.dos.writeLong(registryPosition);
            this.dos.close();
        }
    }

    public static interface SnapshotWriter {
        public void snapshotEntry(SnapshotPacket.SnapshotRecord var1) throws IOException;

        public void snapshotComplete() throws IOException;
    }
}

