/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import java.util.List;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.rebalance.PartitionedRegionLoadModel;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class MovePrimariesFPR
extends RebalanceDirectorAdapter {
    private static final Logger logger = LogService.getLogger();
    private PartitionedRegionLoadModel model;

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        this.model = model;
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.initialize(model);
    }

    @Override
    public boolean nextStep() {
        this.makeFPRPrimaryForThisNode();
        return false;
    }

    private void makeFPRPrimaryForThisNode() {
        PartitionedRegion partitionedRegion = this.model.getPartitionedRegion();
        List<FixedPartitionAttributesImpl> FPAs = partitionedRegion.getFixedPartitionAttributesImpl();
        InternalDistributedMember targetId = partitionedRegion.getDistributionManager().getId();
        PartitionedRegionLoadModel.MemberRollup target = this.model.getMember(targetId);
        for (PartitionedRegionLoadModel.BucketRollup bucket : this.model.getBuckets()) {
            if (bucket == null) continue;
            for (FixedPartitionAttributesImpl fpa : FPAs) {
                PartitionedRegionLoadModel.Member source;
                if (!fpa.hasBucket(bucket.getId()) || !fpa.isPrimary() || (source = bucket.getPrimary()) == target) continue;
                PartitionedRegionLoadModel.Member member = source = source == null || source == this.model.INVALID_MEMBER ? target : source;
                if (logger.isDebugEnabled()) {
                    logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moving primary from source {} to target {}", (Object)bucket.getId(), (Object)bucket.getPrimary(), (Object)target);
                }
                boolean successfulMove = this.model.movePrimary(new PartitionedRegionLoadModel.Move(source, target, bucket));
                Assert.assertTrue(successfulMove, " Fixed partitioned region not able to move the primary!");
                if (!successfulMove) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("PRLM#movePrimariesForFPR: For Bucket#{}, moved primary from source {} to target {}", (Object)bucket.getId(), (Object)bucket.getPrimary(), (Object)target);
                }
                ((PartitionedRegionLoadModel.Bucket)bucket).setPrimary(target, bucket.getPrimaryLoad());
            }
        }
    }
}

