/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ByteArrayDataInput;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class PutAllPRMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private DistributedPutAllOperation.PutAllEntryData[] putAllPRData;
    private int putAllPRDataSize = 0;
    private Integer bucketId;
    ClientProxyMembershipID bridgeContext;
    private boolean skipCallbacks;
    private Object callbackArg;
    protected static final short HAS_BRIDGE_CONTEXT = 4096;
    protected static final short SKIP_CALLBACKS = 8192;
    private transient InternalDistributedSystem internalDs;
    private transient boolean directAck = false;
    transient boolean result = false;
    transient VersionedObjectList versions = null;

    public PutAllPRMessage() {
    }

    public PutAllPRMessage(int bucketId, int size, boolean notificationOnly, boolean posDup, boolean skipCallbacks, Object callbackArg) {
        this.bucketId = bucketId;
        this.putAllPRData = new DistributedPutAllOperation.PutAllEntryData[size];
        this.notificationOnly = notificationOnly;
        this.posDup = posDup;
        this.skipCallbacks = skipCallbacks;
        this.callbackArg = callbackArg;
        this.initTxMemberId();
    }

    public void addEntry(DistributedPutAllOperation.PutAllEntryData entry) {
        this.putAllPRData[this.putAllPRDataSize++] = entry;
    }

    public void initMessage(PartitionedRegion r, Set recipients, boolean notifyOnly, DirectReplyProcessor p) {
        this.setInternalDs(r.getSystem());
        this.setDirectAck(false);
        this.resetRecipients();
        if (recipients != null) {
            this.setRecipients(recipients);
        }
        this.regionId = r.getPRId();
        this.processor = p;
        int n = this.processorId = p == null ? 0 : p.getProcessorId();
        if (p != null && this.isSevereAlertCompatible()) {
            p.enableSevereAlertProcessing();
        }
        this.notificationOnly = notifyOnly;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public void setPossibleDuplicate(boolean posDup) {
        this.posDup = posDup;
    }

    public int getSize() {
        return this.putAllPRDataSize;
    }

    public Set getKeys() {
        HashSet<Object> keys = new HashSet<Object>(this.getSize());
        for (int i = 0; i < this.putAllPRData.length; ++i) {
            if (this.putAllPRData[i] == null) continue;
            keys.add(this.putAllPRData[i].getKey());
        }
        return keys;
    }

    public PartitionMessage.PartitionResponse send(DistributedMember recipient, PartitionedRegion r) throws ForceReattemptException {
        Set failures;
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        PutAllResponse p = new PutAllResponse(r.getSystem(), recipients);
        this.initMessage(r, recipients, false, p);
        this.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        if (logger.isDebugEnabled()) {
            logger.debug("PutAllPRMessage.send: recipient is {}, msg is {}", (Object)recipient, (Object)this);
        }
        if ((failures = r.getDistributionManager().putOutgoing(this)) != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + this + ">");
        }
        return p;
    }

    public void setBridgeContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.bridgeContext = contx;
    }

    @Override
    public int getDSFID() {
        return -109;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = (int)InternalDataSerializer.readSignedVL(in);
        if ((this.flags & 0x1000) != 0) {
            this.bridgeContext = (ClientProxyMembershipID)DataSerializer.readObject(in);
        }
        this.callbackArg = DataSerializer.readObject(in);
        this.putAllPRDataSize = (int)InternalDataSerializer.readUnsignedVL(in);
        this.putAllPRData = new DistributedPutAllOperation.PutAllEntryData[this.putAllPRDataSize];
        if (this.putAllPRDataSize > 0) {
            Version version = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            ByteArrayDataInput bytesIn = new ByteArrayDataInput();
            for (int i = 0; i < this.putAllPRDataSize; ++i) {
                this.putAllPRData[i] = new DistributedPutAllOperation.PutAllEntryData(in, null, i, version, bytesIn);
            }
            boolean hasTags = in.readBoolean();
            if (hasTags) {
                DistributedPutAllOperation.EntryVersionsList versionTags = DistributedPutAllOperation.EntryVersionsList.create(in);
                for (int i = 0; i < this.putAllPRDataSize; ++i) {
                    this.putAllPRData[i].versionTag = (VersionTag)versionTags.get(i);
                }
            }
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        if (this.bucketId == null) {
            InternalDataSerializer.writeSignedVL(-1L, out);
        } else {
            InternalDataSerializer.writeSignedVL(this.bucketId.intValue(), out);
        }
        if (this.bridgeContext != null) {
            DataSerializer.writeObject(this.bridgeContext, out);
        }
        DataSerializer.writeObject(this.callbackArg, out);
        InternalDataSerializer.writeUnsignedVL(this.putAllPRDataSize, out);
        if (this.putAllPRDataSize > 0) {
            DistributedPutAllOperation.EntryVersionsList versionTags = new DistributedPutAllOperation.EntryVersionsList(this.putAllPRDataSize);
            boolean hasTags = false;
            for (int i = 0; i < this.putAllPRDataSize; ++i) {
                if (!hasTags && this.putAllPRData[i].versionTag != null) {
                    hasTags = true;
                }
                VersionTag tag = this.putAllPRData[i].versionTag;
                versionTags.add(tag);
                this.putAllPRData[i].versionTag = null;
                this.putAllPRData[i].toData(out);
                this.putAllPRData[i].versionTag = tag;
            }
            out.writeBoolean(hasTags);
            if (hasTags) {
                InternalDataSerializer.invokeToData(versionTags, out);
            }
        }
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.bridgeContext != null) {
            s = (short)(s | 0x1000);
        }
        if (this.skipCallbacks) {
            s = (short)(s | 0x2000);
        }
        return s;
    }

    @Override
    protected void setBooleans(short s, DataInput in) throws IOException, ClassNotFoundException {
        super.setBooleans(s, in);
        this.skipCallbacks = (s & 0x2000) != 0;
    }

    @Override
    public EventID getEventID() {
        if (this.putAllPRData.length > 0) {
            return this.putAllPRData[0].getEventID();
        }
        return null;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws EntryExistsException, ForceReattemptException, DataLocationException {
        boolean sendReply = true;
        InternalDistributedMember eventSender = this.getSender();
        long lastModified = 0L;
        try {
            this.result = this.doLocalPutAll(pr, eventSender, lastModified);
        }
        catch (ForceReattemptException fre) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(fre), pr, startTime);
            return false;
        }
        if (sendReply) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, pr, startTime);
        }
        return false;
    }

    public EntryEventImpl getFirstEvent(PartitionedRegion r) {
        if (this.putAllPRDataSize == 0) {
            return null;
        }
        EntryEventImpl ev = EntryEventImpl.create((LocalRegion)r, this.putAllPRData[0].getOp(), this.putAllPRData[0].getKey(), this.putAllPRData[0].getValue(r.getCache()), this.callbackArg, false, (DistributedMember)this.getSender(), true, this.putAllPRData[0].getEventID());
        return ev;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"IMSE_DONT_CATCH_IMSE"})
    public boolean doLocalPutAll(PartitionedRegion r, InternalDistributedMember eventSender, long lastModified) throws EntryExistsException, ForceReattemptException, DataLocationException {
        block53: {
            boolean didPut = false;
            long clientReadTimeOut = 10000L;
            if (r.hasServerProxy()) {
                clientReadTimeOut = r.getServerProxy().getPool().getReadTimeout();
                if (logger.isDebugEnabled()) {
                    logger.debug("PutAllPRMessage: doLocalPutAll: clientReadTimeOut is {}", (Object)clientReadTimeOut);
                }
            }
            DistributedPutAllOperation dpao = null;
            EntryEventImpl baseEvent = null;
            BucketRegion bucketRegion = null;
            PartitionedRegionDataStore ds = r.getDataStore();
            InternalDistributedMember myId = r.getDistributionManager().getDistributionManagerId();
            try {
                int i;
                if (!this.notificationOnly) {
                    bucketRegion = ds.getInitializedBucketForId(null, this.bucketId);
                    this.versions = new VersionedObjectList(this.putAllPRDataSize, true, bucketRegion.getAttributes().getConcurrencyChecksEnabled());
                    baseEvent = EntryEventImpl.create((LocalRegion)bucketRegion, Operation.PUTALL_CREATE, null, null, this.callbackArg, true, (DistributedMember)eventSender, !this.skipCallbacks, true);
                    baseEvent.setEventId(this.putAllPRData[0].getEventID());
                    if (this.bridgeContext != null) {
                        baseEvent.setContext(this.bridgeContext);
                    }
                    baseEvent.setPossibleDuplicate(this.posDup);
                    if (logger.isDebugEnabled()) {
                        logger.debug("PutAllPRMessage.doLocalPutAll: eventSender is {}, baseEvent is {}, msg is {}", (Object)eventSender, (Object)baseEvent, (Object)this);
                    }
                    dpao = new DistributedPutAllOperation(baseEvent, this.putAllPRDataSize, false);
                }
                Object[] keys = new Object[this.putAllPRDataSize];
                for (i = 0; i < this.putAllPRDataSize; ++i) {
                    keys[i] = this.putAllPRData[i].getKey();
                }
                if (!this.notificationOnly) {
                    try {
                        if (this.putAllPRData.length > 0) {
                            if (this.posDup && bucketRegion.getConcurrencyChecksEnabled()) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("attempting to locate version tags for retried event");
                                }
                                for (i = 0; i < this.putAllPRDataSize; ++i) {
                                    if (this.putAllPRData[i].versionTag != null) continue;
                                    this.putAllPRData[i].versionTag = bucketRegion.findVersionTagForClientBulkOp(this.putAllPRData[i].getEventID());
                                    if (this.putAllPRData[i].versionTag == null) continue;
                                    this.putAllPRData[i].versionTag.replaceNullIDs(bucketRegion.getVersionMember());
                                }
                            }
                            EventID eventID = this.putAllPRData[0].getEventID();
                            ThreadIdentifier membershipID = new ThreadIdentifier(eventID.getMembershipID(), eventID.getThreadID());
                            bucketRegion.recordBulkOpStart(membershipID, eventID);
                        }
                        bucketRegion.waitUntilLocked(keys);
                        boolean lockedForPrimary = false;
                        HashMap<Object, Object> succeeded = new HashMap<Object, Object>();
                        PutAllPartialResultException.PutAllPartialResult partialKeys = new PutAllPartialResultException.PutAllPartialResult(this.putAllPRDataSize);
                        Object key = keys[0];
                        try {
                            bucketRegion.doLockForPrimary(false);
                            lockedForPrimary = true;
                            for (int i2 = 0; i2 < this.putAllPRDataSize; ++i2) {
                                EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(r, myId, eventSender, i2, this.putAllPRData, this.notificationOnly, this.bridgeContext, this.posDup, this.skipCallbacks);
                                try {
                                    block50: {
                                        key = ev.getKey();
                                        ev.setPutAllOperation(dpao);
                                        ev.makeSerializedNewValue();
                                        try {
                                            didPut = r.getDataView().putEntryOnRemote(ev, false, false, null, false, lastModified, true);
                                            if (didPut && logger.isDebugEnabled()) {
                                                logger.debug("PutAllPRMessage.doLocalPutAll:putLocally success for {}", (Object)ev);
                                            }
                                        }
                                        catch (ConcurrentCacheModificationException e) {
                                            didPut = true;
                                            if (!logger.isDebugEnabled()) break block50;
                                            logger.debug("PutAllPRMessage.doLocalPutAll:putLocally encountered concurrent cache modification for {}", (Object)ev, (Object)e);
                                        }
                                    }
                                    this.putAllPRData[i2].setTailKey(ev.getTailKey());
                                    if (!didPut) {
                                        r.checkReadiness();
                                        ForceReattemptException fre = new ForceReattemptException("unable to perform put in PutAllPR, but operation should not fail");
                                        fre.setHash(ev.getKey().hashCode());
                                        throw fre;
                                    }
                                    succeeded.put(this.putAllPRData[i2].getKey(), this.putAllPRData[i2].getValue(r.getCache()));
                                    this.versions.addKeyAndVersion(this.putAllPRData[i2].getKey(), ev.getVersionTag());
                                    continue;
                                }
                                finally {
                                    ev.release();
                                }
                            }
                        }
                        catch (IllegalMonitorStateException ignore) {
                            throw new ForceReattemptException("unable to get lock for primary, retrying... ");
                        }
                        catch (CacheWriterException cwe) {
                            partialKeys.saveFailedKey(key, cwe);
                        }
                        finally {
                            try {
                                dpao.setUseFakeEventId(true);
                                r.checkReadiness();
                                bucketRegion.getDataView().postPutAll(dpao, this.versions, bucketRegion);
                            }
                            finally {
                                if (lockedForPrimary) {
                                    bucketRegion.doUnlockForPrimary();
                                }
                            }
                        }
                        if (partialKeys.hasFailure()) {
                            partialKeys.addKeysAndVersions(this.versions);
                            if (logger.isDebugEnabled()) {
                                logger.debug("PutAllPRMessage: partial keys applied, map to bucket {}'s keys: {}. Applied {}", (Object)this.bucketId, (Object)Arrays.toString(keys), succeeded);
                            }
                            throw new PutAllPartialResultException(partialKeys);
                        }
                        break block53;
                    }
                    catch (RegionDestroyedException e) {
                        ds.checkRegionDestroyedOnBucket(bucketRegion, true, e);
                        break block53;
                    }
                    finally {
                        bucketRegion.removeAndNotifyKeys(keys);
                    }
                }
                for (i = 0; i < this.putAllPRDataSize; ++i) {
                    EntryEventImpl ev = PutAllPRMessage.getEventFromEntry(r, myId, eventSender, i, this.putAllPRData, this.notificationOnly, this.bridgeContext, this.posDup, this.skipCallbacks);
                    try {
                        ev.setOriginRemote(true);
                        if (this.callbackArg != null) {
                            ev.setCallbackArgument(this.callbackArg);
                        }
                        r.invokePutCallbacks(ev.getOperation().isCreate() ? EnumListenerEvent.AFTER_CREATE : EnumListenerEvent.AFTER_UPDATE, ev, r.isInitialized(), true);
                        continue;
                    }
                    finally {
                        ev.release();
                    }
                }
            }
            finally {
                if (baseEvent != null) {
                    baseEvent.release();
                }
                if (dpao != null) {
                    dpao.freeOffHeapResources();
                }
            }
        }
        return true;
    }

    public VersionedObjectList getVersions() {
        return this.versions;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntryEventImpl getEventFromEntry(LocalRegion r, InternalDistributedMember myId, InternalDistributedMember eventSender, int idx, DistributedPutAllOperation.PutAllEntryData[] data, boolean notificationOnly, ClientProxyMembershipID bridgeContext, boolean posDup, boolean skipCallbacks) {
        DistributedPutAllOperation.PutAllEntryData prd = data[idx];
        Object prdValue = prd.getValue(r.getCache());
        EntryEventImpl ev = EntryEventImpl.create(r, prd.getOp(), prd.getKey(), prdValue, null, false, (DistributedMember)eventSender, !skipCallbacks, prd.getEventID());
        boolean evReturned = false;
        try {
            if (prdValue == null && ev.getRegion().getAttributes().getDataPolicy() == DataPolicy.NORMAL) {
                ev.setLocalInvalid(true);
            }
            ev.setNewValue(prdValue);
            ev.setOldValue(prd.getOldValue());
            if (bridgeContext != null) {
                ev.setContext(bridgeContext);
            }
            ev.setInvokePRCallbacks(!notificationOnly);
            ev.setPossibleDuplicate(posDup);
            if (prd.filterRouting != null) {
                ev.setLocalFilterInfo(prd.filterRouting.getFilterInfo(myId));
            }
            if (prd.versionTag != null) {
                prd.versionTag.replaceNullIDs(eventSender);
                ev.setVersionTag(prd.versionTag);
            }
            if (notificationOnly) {
                ev.setTailKey(-1L);
            } else {
                ev.setTailKey(prd.getTailKey());
            }
            evReturned = true;
            EntryEventImpl entryEventImpl = ev;
            return entryEventImpl;
        }
        finally {
            if (!evReturned) {
                ev.release();
            }
        }
    }

    PartitionMessage.PartitionResponse createReplyProcessor(PartitionedRegion r, Set recipients, Object key) {
        return new PutAllResponse(r.getSystem(), recipients);
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, PartitionedRegion pr, long startTime) {
        if (pr != null) {
            if (startTime > 0L) {
                pr.getPrStats().endPartitionMessagesProcessing(startTime);
            }
            if (!pr.getConcurrencyChecksEnabled() && this.versions != null) {
                this.versions.clear();
            }
        }
        PutAllReplyMessage.send(member, procId, this.getReplySender(dm), this.result, this.versions, ex);
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; putAllPRDataSize=").append(this.putAllPRDataSize).append("; bucketId=").append(this.bucketId);
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        buff.append("; directAck=").append(this.directAck);
        for (int i = 0; i < this.putAllPRDataSize; ++i) {
            buff.append("; entry").append(i).append(":").append(this.putAllPRData[i].getKey()).append(",").append(this.putAllPRData[i].versionTag);
        }
    }

    public void setInternalDs(InternalDistributedSystem internalDs) {
        this.internalDs = internalDs;
    }

    public void setDirectAck(boolean directAck) {
        this.directAck = directAck;
    }

    @Override
    protected boolean mayAddToMultipleSerialGateways(ClusterDistributionManager dm) {
        return this._mayAddToMultipleSerialGateways(dm);
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(".cache.") + ".cache.".length()));
        buff.append("(prid=");
        buff.append(this.regionId);
        String name = null;
        try {
            PartitionedRegion pr = PartitionedRegion.getPRFromId(this.regionId);
            if (pr != null) {
                name = pr.getFullPath();
            }
        }
        catch (Exception ignore) {
            name = null;
        }
        if (name != null) {
            buff.append(" (name = \"").append(name).append("\")");
        }
        this.appendFields(buff);
        buff.append(" ,distTx=");
        buff.append(this.isTransactionDistributed);
        buff.append(" ,putAlldatasize=");
        buff.append(this.putAllPRDataSize);
        buff.append(" ,putAlldata=");
        buff.append(Arrays.toString(this.putAllPRData));
        buff.append(")");
        return buff.toString();
    }

    public static class PutAllResult {
        public boolean returnValue;
        public VersionedObjectList versions;

        public PutAllResult(boolean flag, VersionedObjectList versions) {
            this.returnValue = flag;
            this.versions = versions;
        }

        public String toString() {
            return "PutAllResult(" + this.returnValue + ", " + this.versions + ")";
        }
    }

    public static class PutAllResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean returnValue;
        private VersionedObjectList versions;

        public PutAllResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients, false);
        }

        public void setResponse(PutAllReplyMessage response) {
            this.returnValue = response.result;
            if (response.versions != null) {
                this.versions = response.versions;
                this.versions.replaceNullIDs(response.getSender());
            }
        }

        public PutAllResult waitForResult() throws CacheException, ForceReattemptException {
            this.waitForCacheException();
            return new PutAllResult(this.returnValue, this.versions);
        }
    }

    public static class PutAllReplyMessage
    extends ReplyMessage {
        boolean result;
        VersionedObjectList versions;

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public PutAllReplyMessage() {
        }

        private PutAllReplyMessage(int processorId, boolean result, VersionedObjectList versions, ReplyException ex) {
            this.versions = versions;
            this.result = result;
            this.setProcessorId(processorId);
            this.setException(ex);
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender dm, boolean result, VersionedObjectList versions, ReplyException ex) {
            Assert.assertTrue(recipient != null, "PutAllReplyMessage NULL reply message");
            PutAllReplyMessage m = new PutAllReplyMessage(processorId, result, versions, ex);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "{}: processor not found", (Object)this);
                }
                return;
            }
            if (rp instanceof PutAllResponse) {
                PutAllResponse processor = (PutAllResponse)rp;
                processor.setResponse(this);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return -110;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.result = in.readBoolean();
            this.versions = (VersionedObjectList)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.result);
            DataSerializer.writeObject(this.versions, out);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PutAllReplyMessage ").append("processorid=").append(this.processorId).append(" returning ").append(this.result).append(" exception=").append(this.getException()).append(" versions= ").append(this.versions);
            return sb.toString();
        }
    }
}

