/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class PrimaryRequestMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private int bucketId;

    public static PrimaryResponse send(Set recipients, PartitionedRegion r, int bucketId) throws ForceReattemptException {
        Assert.assertTrue(recipients != null, "PrimaryRequestMessage NULL recipient");
        PrimaryResponse p = new PrimaryResponse(r.getSystem(), recipients);
        PrimaryRequestMessage m = new PrimaryRequestMessage(recipients, r.getPRId(), p, bucketId);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.PrimaryRequestMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public PrimaryRequestMessage() {
    }

    private PrimaryRequestMessage(Set recipients, int regionId, ReplyProcessor21 processor, int bId) {
        super(recipients, regionId, processor);
        this.bucketId = bId;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion pr, long startTime) throws CacheException, ForceReattemptException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "PrimaryRequestMessage operateOnRegion: {}", (Object)pr.getFullPath());
        }
        pr.checkReadiness();
        boolean isPrimary = dm.getId().equals(pr.getBucketPrimary(this.bucketId));
        PrimaryRequestReplyMessage.sendReply(this.getSender(), this.getProcessorId(), isPrimary, dm);
        return false;
    }

    @Override
    public int getDSFID() {
        return 54;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    public static class PrimaryResponse
    extends ReplyProcessor21 {
        private volatile PrimaryRequestReplyMessage msg;

        protected PrimaryResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof PrimaryRequestReplyMessage) {
                    PrimaryRequestReplyMessage reply = (PrimaryRequestReplyMessage)msg;
                    if (reply.isPrimary) {
                        this.msg = reply;
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            logger.trace(LogMarker.DM, "PrimaryRequestResponse primary is {}", (Object)this.msg.getSender());
                        }
                    } else if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.debug("PrimaryRequestResponse {} is not primary", (Object)this.msg.getSender());
                    }
                } else {
                    Assert.assertTrue(msg instanceof ReplyMessage);
                }
            }
            finally {
                super.process(msg);
            }
        }

        public InternalDistributedMember waitForPrimary() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "NodeResponse got remote CacheClosedException, throwing PartitionedRegionCommunication Exception. {}", (Object)t.getMessage(), (Object)t);
                    }
                    throw new ForceReattemptException(LocalizedStrings.PrimaryRequestMessage_NODERESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION_THROWING_PARTITIONEDREGIONCOMMUNICATION_EXCEPTION.toLocalizedString(), t);
                }
                e.handleCause();
            }
            return this.msg.getSender();
        }
    }

    public static class PrimaryRequestReplyMessage
    extends ReplyMessage {
        private static final long serialVersionUID = 1L;
        public volatile boolean isPrimary;

        protected static void sendReply(InternalDistributedMember member, int procId, boolean isPrimary, DistributionManager dm) {
            dm.putOutgoing(new PrimaryRequestReplyMessage(member, procId, isPrimary));
        }

        public PrimaryRequestReplyMessage() {
        }

        private PrimaryRequestReplyMessage(InternalDistributedMember member, int procId, boolean isPrimary2) {
            this.setRecipient(member);
            this.setProcessorId(procId);
            this.isPrimary = isPrimary2;
        }

        @Override
        public int getDSFID() {
            return 55;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.isPrimary = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.isPrimary);
        }
    }
}

