/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.FunctionStreamingOrderedReplyMessage;
import org.apache.geode.internal.cache.FunctionStreamingReplyMessage;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.execute.FunctionRemoteContext;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionFunctionStreamingMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private boolean replyLastMsg;
    private int replyMsgNum;
    private Object result;
    private FunctionRemoteContext context;

    public PartitionedRegionFunctionStreamingMessage() {
    }

    public PartitionedRegionFunctionStreamingMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, FunctionRemoteContext context) {
        super(recipient, regionId, processor);
        this.context = context;
    }

    public PartitionedRegionFunctionStreamingMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public int getProcessorType() {
        return 80;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "PartitionedRegionFunctionResultStreamerMessage operateOnRegion: {}", (Object)r.getFullPath());
        }
        if (this.context.getFunction() == null) {
            this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(this.context.getFunctionId()))), r, startTime);
            return false;
        }
        PartitionedRegionDataStore ds = r.getDataStore();
        if (ds != null) {
            ds.executeOnDataStore(this.context.getFilter(), this.context.getFunction(), this.context.getArgs(), this.getProcessorId(), this.context.getBucketSet(), this.context.isReExecute(), this, startTime, null, 0);
            if (!this.replyLastMsg && this.context.getFunction().hasResult()) {
                this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(this.context.getFunction().getId()))), r, startTime);
                return false;
            }
        } else {
            throw new InternalError("PartitionedRegionFunctionResultStreamerMessage sent to an accessor vm :" + dm.getId().getId());
        }
        return false;
    }

    public synchronized boolean sendReplyForOneResult(DistributionManager dm, PartitionedRegion pr, long startTime, Object oneResult, boolean lastResult, boolean sendResultsInOrder) throws CacheException, ForceReattemptException, InterruptedException {
        if (this.replyLastMsg) {
            return false;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int msgNum = this.replyMsgNum;
        this.replyLastMsg = lastResult;
        this.sendReply(this.getSender(), this.processorId, dm, null, oneResult, pr, startTime, msgNum, lastResult, sendResultsInOrder);
        if (logger.isDebugEnabled()) {
            logger.debug("Sending reply message count: {} to co-ordinating node");
        }
        ++this.replyMsgNum;
        return false;
    }

    protected void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, Object result, PartitionedRegion pr, long startTime, int msgNum, boolean lastResult, boolean sendResultsInOrder) {
        if (ex != null) {
            this.result = null;
            this.replyMsgNum = 0;
            this.replyLastMsg = true;
        }
        if (this.replyLastMsg && pr != null && startTime > 0L) {
            pr.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        if (sendResultsInOrder) {
            FunctionStreamingOrderedReplyMessage.send(member, procId, ex, dm, result, msgNum, lastResult);
        } else {
            FunctionStreamingReplyMessage.send(member, procId, ex, dm, result, msgNum, lastResult);
        }
    }

    @Override
    public int getDSFID() {
        return 1201;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.context = (FunctionRemoteContext)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.context, out);
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }
}

