/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Operation;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.SerializationVersions;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientTombstoneMessage;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class PRTombstoneMessage
extends PartitionMessageWithDirectReply
implements SerializationVersions {
    private static final Logger logger = LogService.getLogger();
    private static Version[] serializationVersions = null;
    private Set<Object> keys;
    private EventID eventID;

    public PRTombstoneMessage() {
    }

    public static void send(BucketRegion r, Set<Object> keys, EventID eventID) {
        Set recipients = r.getPartitionedRegion().getRegionAdvisor().adviseAllServersWithInterest();
        recipients.removeAll(r.getDistributionAdvisor().adviseReplicates());
        if (recipients.size() == 0) {
            return;
        }
        Response p = new Response(r.getSystem(), recipients);
        PRTombstoneMessage m = new PRTombstoneMessage(recipients, r.getPartitionedRegion().getPRId(), p, keys, eventID);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        r.getDistributionManager().putOutgoing(m);
        try {
            p.waitForCacheException();
        }
        catch (ForceReattemptException forceReattemptException) {
            // empty catch block
        }
    }

    private PRTombstoneMessage(Set<InternalDistributedMember> recipients, int regionId, PartitionMessage.PartitionResponse p, Set<Object> reapedKeys, EventID eventID) {
        super(recipients, regionId, (DirectReplyProcessor)p);
        this.keys = reapedKeys;
        this.eventID = eventID;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws ForceReattemptException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.debug("PRTombstoneMessage operateOnRegion: {}", (Object)r.getFullPath());
        }
        FilterProfile fp = r.getFilterProfile();
        if (this.keys != null && this.keys.size() > 0 && fp != null && CacheClientNotifier.getInstance() != null && this.eventID != null) {
            RegionEventImpl regionEvent = new RegionEventImpl(r, Operation.REGION_DESTROY, null, true, r.getGemFireCache().getMyId());
            regionEvent.setLocalFilterInfo(fp.getLocalFilterRouting(regionEvent));
            ClientTombstoneMessage clientMessage = ClientTombstoneMessage.gc((LocalRegion)r, this.keys, this.eventID);
            CacheClientNotifier.notifyClients(regionEvent, clientMessage);
        }
        return true;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; keys=").append(this.keys.size());
        buff.append("; eventID=").append(this.eventID);
    }

    @Override
    public int getDSFID() {
        return 157;
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        int numKeys = in.readInt();
        this.keys = new HashSet<Object>(numKeys);
        for (int i = 0; i < numKeys; ++i) {
            this.keys.add(DataSerializer.readObject(in));
        }
        this.eventID = (EventID)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.keys.size());
        for (Object key : this.keys) {
            DataSerializer.writeObject(key, out);
        }
        DataSerializer.writeObject(this.eventID, out);
    }

    private static class Response
    extends PartitionMessage.PartitionResponse {
        public Response(InternalDistributedSystem ds, Set recipients) {
            super(ds, recipients, false);
        }

        @Override
        public void process(DistributionMessage msg) {
            Throwable cause;
            ReplyMessage reply = (ReplyMessage)msg;
            if (reply.getException() != null && ((cause = reply.getException().getCause()) instanceof ForceReattemptException || cause instanceof CancelException)) {
                reply.setException(null);
            }
            super.process(reply);
        }
    }
}

