/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionDataStore;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class BucketSizeMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;

    public BucketSizeMessage() {
    }

    private BucketSizeMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
    }

    @Override
    public int getProcessorType() {
        return 73;
    }

    public static BucketSizeResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "BucketSizeMessage NULL reply message");
        BucketSizeResponse p = new BucketSizeResponse(r.getSystem(), Collections.singleton(recipient));
        BucketSizeMessage m = new BucketSizeMessage(recipient, r.getPRId(), p, bucketId);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, ForceReattemptException {
        PartitionedRegionDataStore ds = r.getDataStore();
        if (ds == null) {
            throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_NO_DATASTORE_IN_0.toLocalizedString(dm.getDistributionManagerId()));
        }
        long size = ds.getBucketSize(this.bucketId);
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        BucketSizeReplyMessage.send(this.getSender(), this.getProcessorId(), dm, size);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
    }

    @Override
    public int getDSFID() {
        return 42;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }

    public static class BucketSizeResponse
    extends ReplyProcessor21 {
        private volatile long returnValue;

        public BucketSizeResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof BucketSizeReplyMessage) {
                    BucketSizeReplyMessage reply = (BucketSizeReplyMessage)msg;
                    this.returnValue = reply.getSize();
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "BucketSizeResponse return value is {}", (Object)this.returnValue);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public long waitForSize() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("BucketSizeResponse got remote cancellation; forcing reattempt. {}", (Object)t.getMessage(), (Object)t);
                    throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_BUCKETSIZERESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION_FORCING_REATTEMPT.toLocalizedString(), t);
                }
                if (t instanceof ForceReattemptException) {
                    logger.debug("BucketSizeResponse got remote Region destroyed; forcing reattempt. {}", (Object)t.getMessage(), (Object)t);
                    throw new ForceReattemptException(LocalizedStrings.BucketSizeMessage_BUCKETSIZERESPONSE_GOT_REMOTE_REGION_DESTROYED_FORCING_REATTEMPT.toLocalizedString(), t);
                }
                e.handleCause();
            }
            return this.returnValue;
        }
    }

    public static class BucketSizeReplyMessage
    extends HighPriorityDistributionMessage {
        private int processorId;
        private long size;

        public BucketSizeReplyMessage() {
        }

        private BucketSizeReplyMessage(int processorId, long size) {
            this.processorId = processorId;
            this.size = size;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm, long size) {
            Assert.assertTrue(recipient != null, "PRDistribuedGetReplyMessage NULL reply message");
            BucketSizeReplyMessage m = new BucketSizeReplyMessage(processorId, size);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            ReplyProcessor21 processor;
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "PRDistributedBucketSizeReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if ((processor = ReplyProcessor21.getProcessor(this.processorId)) == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("PRDistributedBucketSizeReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 63;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.size = in.readLong();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeLong(this.size);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("PRDistributedBucketSizeReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning numEntries=").append(this.getSize());
            return sb.toString();
        }

        public long getSize() {
            return this.size;
        }
    }
}

