/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.internal.cache.BucketAdvisor;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class BucketProfileUpdateMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private int prId;
    private int bucketId;
    private int processorId = 0;
    private BucketAdvisor.BucketProfile profile;

    public BucketProfileUpdateMessage() {
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    private BucketProfileUpdateMessage(Set recipients, int partitionedRegionId, int processorId, int bucketId, BucketAdvisor.BucketProfile profile) {
        this.setRecipients(recipients);
        this.processorId = processorId;
        this.prId = partitionedRegionId;
        this.bucketId = bucketId;
        this.profile = profile;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        try {
            PartitionedRegion pr = PartitionedRegion.getPRFromId(this.prId);
            pr.getRegionAdvisor().putBucketProfile(this.bucketId, this.profile);
        }
        catch (PRLocallyDestroyedException fre) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region locally destroyed> ///{}", (Object)this);
            }
        }
        catch (RegionDestroyedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<region destroyed> ///{}", (Object)this);
            }
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("<cache closed> ///{}", (Object)this);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ignore) {
            SystemFailure.checkFailure();
        }
        finally {
            if (this.processorId != 0) {
                ReplyMessage.send(this.getSender(), this.processorId, null, (ReplySender)dm);
            }
        }
    }

    public static ReplyProcessor21 send(Set recipients, DistributionManager dm, int prId, int bucketId, BucketAdvisor.BucketProfile bp, boolean requireAck) {
        if (recipients.isEmpty()) {
            return null;
        }
        ReplyProcessor21 rp = null;
        int procId = 0;
        if (requireAck) {
            rp = new ReplyProcessor21(dm, (Collection)recipients);
            procId = rp.getProcessorId();
        }
        BucketProfileUpdateMessage m = new BucketProfileUpdateMessage(recipients, prId, procId, bucketId, bp);
        dm.putOutgoing(m);
        return rp;
    }

    @Override
    public int getDSFID() {
        return 41;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.prId = in.readInt();
        this.bucketId = in.readInt();
        this.processorId = in.readInt();
        this.profile = (BucketAdvisor.BucketProfile)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.prId);
        out.writeInt(this.bucketId);
        out.writeInt(this.processorId);
        DataSerializer.writeObject(this.profile, out);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        String shortName = className.substring(className.lastIndexOf(46, className.lastIndexOf(46) - 1) + 1);
        return buff.append(shortName).append("(prid=").append(this.prId).append("; bucketid=").append(this.bucketId).append("; sender=").append(this.getSender()).append("]; processorId=").append(this.processorId).append("; profile=").append(this.profile).append(")").toString();
    }
}

