/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.FunctionStats;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.InternalResultSender;
import org.apache.geode.internal.cache.execute.LocalResultCollector;
import org.apache.geode.internal.cache.execute.LocalResultCollectorImpl;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.PartitionedRegionFunctionResultSender;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class AbstractExecution
implements InternalExecution {
    private static final Logger logger = LogService.getLogger();
    protected boolean isMemberMappedArgument;
    protected MemberMappedArgument memberMappedArg;
    protected Object args;
    protected ResultCollector rc;
    protected Set filter = new HashSet();
    protected boolean hasRoutingObjects;
    protected volatile boolean isReExecute = false;
    protected volatile boolean isClientServerMode = false;
    protected Set<String> failedNodes = new HashSet<String>();
    protected boolean isFnSerializationReqd;
    protected Collection<InternalDistributedMember> executionNodes = null;
    protected ExecutionNodesListener executionNodesListener = null;
    protected boolean waitOnException = false;
    protected boolean forwardExceptions = false;
    protected boolean ignoreDepartedMembers = false;
    protected ProxyCache proxyCache;
    private static final ConcurrentHashMap<String, byte[]> idToFunctionAttributes = new ConcurrentHashMap();
    public static final byte NO_HA_NO_HASRESULT_NO_OPTIMIZEFORWRITE = 0;
    public static final byte NO_HA_HASRESULT_NO_OPTIMIZEFORWRITE = 2;
    public static final byte HA_HASRESULT_NO_OPTIMIZEFORWRITE = 3;
    public static final byte NO_HA_NO_HASRESULT_OPTIMIZEFORWRITE = 4;
    public static final byte NO_HA_HASRESULT_OPTIMIZEFORWRITE = 6;
    public static final byte HA_HASRESULT_OPTIMIZEFORWRITE = 7;
    public static final byte HA_HASRESULT_NO_OPTIMIZEFORWRITE_REEXECUTE = 11;
    public static final byte HA_HASRESULT_OPTIMIZEFORWRITE_REEXECUTE = 15;

    public static byte getFunctionState(boolean isHA, boolean hasResult, boolean optimizeForWrite) {
        if (isHA) {
            if (hasResult) {
                if (optimizeForWrite) {
                    return 7;
                }
                return 3;
            }
            return 1;
        }
        if (hasResult) {
            if (optimizeForWrite) {
                return 6;
            }
            return 2;
        }
        if (optimizeForWrite) {
            return 4;
        }
        return 0;
    }

    public static byte getReexecuteFunctionState(byte fnState) {
        if (fnState == 3) {
            return 11;
        }
        if (fnState == 7) {
            return 15;
        }
        throw new InternalGemFireException("Wrong fnState provided.");
    }

    protected AbstractExecution() {
    }

    protected AbstractExecution(AbstractExecution ae) {
        if (ae.args != null) {
            this.args = ae.args;
        }
        if (ae.rc != null) {
            this.rc = ae.rc;
        }
        if (ae.memberMappedArg != null) {
            this.memberMappedArg = ae.memberMappedArg;
        }
        this.isMemberMappedArgument = ae.isMemberMappedArgument;
        this.isClientServerMode = ae.isClientServerMode;
        if (ae.proxyCache != null) {
            this.proxyCache = ae.proxyCache;
        }
        this.isFnSerializationReqd = ae.isFnSerializationReqd;
    }

    protected AbstractExecution(AbstractExecution ae, boolean isReExecute) {
        this(ae);
        this.isReExecute = isReExecute;
    }

    public boolean isMemberMappedArgument() {
        return this.isMemberMappedArgument;
    }

    public Object getArgumentsForMember(String memberId) {
        if (!this.isMemberMappedArgument) {
            return this.args;
        }
        return this.memberMappedArg.getArgumentsForMember(memberId);
    }

    public MemberMappedArgument getMemberMappedArgument() {
        return this.memberMappedArg;
    }

    public Object getArguments() {
        return this.args;
    }

    public ResultCollector getResultCollector() {
        return this.rc;
    }

    public Set getFilter() {
        return this.filter;
    }

    public AbstractExecution setIsReExecute() {
        this.isReExecute = true;
        if (this.executionNodesListener != null) {
            this.executionNodesListener.reset();
        }
        return this;
    }

    public boolean isReExecute() {
        return this.isReExecute;
    }

    public Set<String> getFailedNodes() {
        return this.failedNodes;
    }

    public void addFailedNode(String failedNode) {
        this.failedNodes.add(failedNode);
    }

    public void clearFailedNodes() {
        this.failedNodes.clear();
    }

    public boolean isClientServerMode() {
        return this.isClientServerMode;
    }

    public boolean isFnSerializationReqd() {
        return this.isFnSerializationReqd;
    }

    public Collection<InternalDistributedMember> getExecutionNodes() {
        return this.executionNodes;
    }

    public void setRequireExecutionNodes(ExecutionNodesListener listener) {
        this.executionNodes = Collections.emptySet();
        this.executionNodesListener = listener;
    }

    public void setExecutionNodes(Set<InternalDistributedMember> nodes) {
        if (this.executionNodes != null) {
            this.executionNodes = nodes;
            if (this.executionNodesListener != null) {
                this.executionNodesListener.afterExecutionNodesSet(this);
            }
        }
    }

    public void executeFunctionOnLocalPRNode(final Function fn, final FunctionContext cx, final PartitionedRegionFunctionResultSender sender, DistributionManager dm, boolean isTx) {
        if (dm instanceof ClusterDistributionManager && !isTx) {
            if (ServerConnection.isExecuteFunctionOnLocalNodeOnly() == 1) {
                ServerConnection.executeFunctionOnLocalNodeOnly((byte)3);
                this.executeFunctionLocally(fn, cx, sender, dm);
                if (!sender.isLastResultReceived() && fn.hasResult()) {
                    sender.setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
                }
            } else {
                final ClusterDistributionManager newDM = (ClusterDistributionManager)dm;
                newDM.getFunctionExcecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractExecution.this.executeFunctionLocally(fn, cx, sender, newDM);
                        if (!sender.isLastResultReceived() && fn.hasResult()) {
                            sender.setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
                        }
                    }
                });
            }
        } else {
            this.executeFunctionLocally(fn, cx, sender, dm);
            if (!sender.isLastResultReceived() && fn.hasResult()) {
                sender.setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
            }
        }
    }

    public void executeFunctionOnLocalNode(final Function<?> fn, final FunctionContext cx, final ResultSender sender, DistributionManager dm, boolean isTx) {
        if (dm instanceof ClusterDistributionManager && !isTx) {
            final ClusterDistributionManager newDM = (ClusterDistributionManager)dm;
            newDM.getFunctionExcecutor().execute(new Runnable(){

                @Override
                public void run() {
                    AbstractExecution.this.executeFunctionLocally(fn, cx, sender, newDM);
                    if (!((InternalResultSender)sender).isLastResultReceived() && fn.hasResult()) {
                        ((InternalResultSender)sender).setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
                    }
                }
            });
        } else {
            this.executeFunctionLocally(fn, cx, sender, dm);
            if (!((InternalResultSender)sender).isLastResultReceived() && fn.hasResult()) {
                ((InternalResultSender)sender).setException(new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId())));
            }
        }
    }

    public void executeFunctionLocally(Function<?> fn, FunctionContext cx, ResultSender sender, DistributionManager dm) {
        FunctionStats stats = FunctionStats.getFunctionStats(fn.getId(), dm.getSystem());
        try {
            long start = stats.startTime();
            stats.startFunctionExecution(fn.hasResult());
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on local node with context: {}", (Object)fn.getId(), (Object)cx.toString());
            }
            fn.execute(cx);
            stats.endFunctionExecution(start, fn.hasResult());
        }
        catch (FunctionInvocationTargetException fite) {
            FunctionException functionException = null;
            functionException = fn.isHA() ? new FunctionException(new InternalFunctionInvocationTargetException(fite.getMessage())) : new FunctionException(fite);
            this.handleException(functionException, fn, cx, sender, dm);
        }
        catch (BucketMovedException bme) {
            FunctionException functionException = null;
            functionException = fn.isHA() ? new FunctionException(new InternalFunctionInvocationTargetException(bme)) : new FunctionException(bme);
            this.handleException(functionException, fn, cx, sender, dm);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.handleException(t, fn, cx, sender, dm);
        }
    }

    public ResultCollector execute(String functionName) {
        if (functionName == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(functionName));
        }
        return this.executeFunction(functionObject);
    }

    public ResultCollector execute(Function function) throws FunctionException {
        if (function == null) {
            throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString());
        }
        if (function.isHA() && !function.hasResult()) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        String id = function.getId();
        if (id == null) {
            throw new IllegalArgumentException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_GET_ID_RETURNED_NULL.toLocalizedString());
        }
        this.isFnSerializationReqd = true;
        return this.executeFunction(function);
    }

    @Override
    public void setWaitOnExceptionFlag(boolean waitOnException) {
        this.setForwardExceptions(waitOnException);
        this.waitOnException = waitOnException;
    }

    public boolean getWaitOnExceptionFlag() {
        return this.waitOnException;
    }

    @Override
    public void setForwardExceptions(boolean forward) {
        this.forwardExceptions = forward;
    }

    public boolean isForwardExceptions() {
        return this.forwardExceptions;
    }

    @Override
    public void setIgnoreDepartedMembers(boolean ignore) {
        this.ignoreDepartedMembers = ignore;
        if (ignore) {
            this.setWaitOnExceptionFlag(true);
        }
    }

    public boolean isIgnoreDepartedMembers() {
        return this.ignoreDepartedMembers;
    }

    protected abstract ResultCollector executeFunction(Function var1);

    public abstract void validateExecution(Function var1, Set var2);

    public LocalResultCollector<?, ?> getLocalResultCollector(Function function, ResultCollector<?, ?> rc) {
        if (rc instanceof LocalResultCollector) {
            return (LocalResultCollector)rc;
        }
        return new LocalResultCollectorImpl(function, rc, this);
    }

    public byte[] getFunctionAttributes(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        return idToFunctionAttributes.get(functionId);
    }

    public void removeFunctionAttributes(String functionId) {
        idToFunctionAttributes.remove(functionId);
    }

    public void addFunctionAttributes(String functionId, byte[] functionAttributes) {
        idToFunctionAttributes.put(functionId, functionAttributes);
    }

    private void handleException(Throwable functionException, Function fn, FunctionContext cx, ResultSender sender, DistributionManager dm) {
        FunctionStats stats = FunctionStats.getFunctionStats(fn.getId(), dm.getSystem());
        if (logger.isDebugEnabled()) {
            logger.debug("Exception occurred on local node while executing Function: {}", (Object)fn.getId(), (Object)functionException);
        }
        stats.endFunctionExecutionWithException(fn.hasResult());
        if (fn.hasResult()) {
            if (this.waitOnException || this.forwardExceptions) {
                if (functionException instanceof FunctionException && functionException.getCause() instanceof QueryInvalidException) {
                    functionException = new FunctionException(functionException.getLocalizedMessage());
                }
                sender.lastResult(functionException);
            } else {
                ((InternalResultSender)sender).setException(functionException);
            }
        } else {
            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.FunctionService_EXCEPTION_ON_LOCAL_NODE), functionException);
        }
    }

    public static interface ExecutionNodesListener {
        public void afterExecutionNodesSet(AbstractExecution var1);

        public void reset();
    }
}

