/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.geode.internal.cache.backup.BackupWriter;
import org.apache.geode.internal.cache.backup.FileSystemBackupWriter;
import org.apache.geode.internal.cache.backup.FileSystemBackupWriterConfig;
import org.apache.geode.internal.cache.backup.FileSystemIncrementalBackupLocation;

public enum BackupWriterFactory {
    FILE_SYSTEM("FileSystem"){

        @Override
        BackupWriter createWriter(Properties properties, String memberId) {
            FileSystemBackupWriterConfig config = new FileSystemBackupWriterConfig(properties);
            Path targetDir = Paths.get(config.getTargetDirectory(), new String[0]).resolve(properties.getProperty("TIMESTAMP")).resolve(memberId);
            String baselineDir = config.getBaselineDirectory();
            FileSystemIncrementalBackupLocation incrementalBackupLocation = null;
            if (baselineDir != null) {
                File baseline = new File(baselineDir).getAbsoluteFile();
                incrementalBackupLocation = new FileSystemIncrementalBackupLocation(baseline, memberId);
            }
            return new FileSystemBackupWriter(targetDir, incrementalBackupLocation);
        }
    };

    private String type;

    private BackupWriterFactory(String type) {
        this.type = type;
    }

    String getType() {
        return this.type;
    }

    static BackupWriterFactory getFactoryForType(String type) {
        for (BackupWriterFactory factory : BackupWriterFactory.values()) {
            if (!factory.type.equals(type)) continue;
            return factory;
        }
        throw new IllegalArgumentException("No factory exists for type '" + type + "'");
    }

    abstract BackupWriter createWriter(Properties var1, String var2);
}

