/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.geode.CancelCriterion;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.LoaderHelper;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ProcessorKeeper21;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CacheDistributionAdvisee;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXStateInterface;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.versions.DiskVersionTag;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.offheap.Releasable;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SearchLoadAndWriteProcessor
implements MembershipListener {
    private static final Logger logger = LogService.getLogger();
    public static final int SMALL_BLOB_SIZE = Integer.getInteger("DistributionManager.OptimizedUpdateByteLimit", 2000);
    static final long RETRY_TIME = Long.getLong("gemfire.search-retry-interval", 2000L);
    private volatile InternalDistributedMember selectedNode;
    private boolean selectedNodeDead = false;
    private int timeout;
    private boolean netSearchDone = false;
    private boolean netLoadDone = false;
    private long lastModified = 0L;
    protected int processorId;
    private Object aCallbackArgument;
    private String regionName;
    private Object key;
    protected LocalRegion region;
    private Object result = null;
    private boolean isSerialized = false;
    private CacheDistributionAdvisor advisor = null;
    protected Exception remoteException = null;
    public DistributionManager distributionManager = null;
    private volatile boolean requestInProgress = false;
    private boolean remoteGetInProgress = false;
    private volatile boolean authorative = false;
    private volatile boolean remoteLoadInProgress = false;
    private static final ProcessorKeeper21 processorKeeper = new ProcessorKeeper21(false);
    private final Set pendingResponders = Collections.synchronizedSet(new HashSet());
    private List responseQueue = null;
    private boolean netWriteSucceeded = false;
    private int remainingTimeout = 0;
    private long startTimeSnapShot = 0L;
    private long endTimeSnapShot = 0L;
    private boolean netSearch = false;
    private boolean netLoad = false;
    private boolean attemptedLocalLoad = false;
    private boolean localLoad = false;
    private boolean localWrite = false;
    private boolean netWrite = false;
    private final Object membersLock = new Object();
    private ArrayList<InternalDistributedMember> departedMembers;
    private Lock lock = null;
    static final int NETSEARCH = 0;
    static final int NETLOAD = 1;
    static final int NETWRITE = 2;
    static final int BEFORECREATE = 0;
    static final int BEFOREDESTROY = 1;
    static final int BEFOREUPDATE = 2;
    static final int BEFOREREGIONDESTROY = 3;
    static final int BEFOREREGIONCLEAR = 4;
    private volatile int lastNotifySpot = 0;
    private VersionTag versionTag;

    Object doNetSearch() throws TimeoutException {
        this.resetResults();
        RegionAttributes attrs = this.region.getAttributes();
        this.requestInProgress = true;
        Scope scope = attrs.getScope();
        Assert.assertTrue(scope != Scope.LOCAL);
        this.netSearchForBlob();
        this.requestInProgress = false;
        return this.result;
    }

    void doSearchAndLoad(EntryEventImpl event, TXStateInterface txState, Object localValue) throws CacheLoaderException, TimeoutException {
        this.requestInProgress = true;
        RegionAttributes attrs = this.region.getAttributes();
        Scope scope = attrs.getScope();
        CacheLoader loader = this.region.basicGetLoader();
        if (scope.isLocal()) {
            Object obj = this.doLocalLoad(loader, false);
            event.setNewValue(obj);
        } else {
            this.searchAndLoad(event, txState, localValue);
        }
        this.requestInProgress = false;
        if (this.netSearch) {
            if (event.getOperation().isCreate()) {
                event.setOperation(Operation.SEARCH_CREATE);
            } else {
                event.setOperation(Operation.SEARCH_UPDATE);
            }
        } else if (this.netLoad) {
            if (event.getOperation().isCreate()) {
                event.setOperation(Operation.NET_LOAD_CREATE);
            } else {
                event.setOperation(Operation.NET_LOAD_UPDATE);
            }
        } else if (this.localLoad) {
            if (event.getOperation().isCreate()) {
                event.setOperation(Operation.LOCAL_LOAD_CREATE);
            } else {
                event.setOperation(Operation.LOCAL_LOAD_UPDATE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doNetWrite(CacheEvent event, Set netWriteRecipients, CacheWriter localWriter, int paction) throws CacheWriterException, TimeoutException {
        int action = paction;
        this.requestInProgress = true;
        Scope scope = this.region.getScope();
        if (localWriter != null) {
            this.doLocalWrite(localWriter, event, action);
            this.requestInProgress = false;
            return true;
        }
        if (scope == Scope.LOCAL && this.region.getPartitionAttributes() == null) {
            return false;
        }
        CacheEvent listenerEvent = this.getEventForListener(event);
        try {
            if (action == 2 && listenerEvent.getOperation().isCreate()) {
                action = 0;
            }
            boolean cacheWrote = this.netWrite(listenerEvent, action, netWriteRecipients);
            this.requestInProgress = false;
            boolean bl = cacheWrote;
            return bl;
        }
        finally {
            if (event != listenerEvent && listenerEvent instanceof EntryEventImpl) {
                ((Releasable)((Object)listenerEvent)).release();
            }
        }
    }

    @Override
    public void memberJoined(DistributionManager distributionManager, InternalDistributedMember id) {
    }

    @Override
    public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
    }

    @Override
    public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
        Object object = this.membersLock;
        synchronized (object) {
            this.pendingResponders.remove(id);
        }
        object = this;
        synchronized (object) {
            if (id.equals(this.selectedNode) && this.requestInProgress && this.remoteGetInProgress) {
                if (this.departedMembers == null) {
                    this.departedMembers = new ArrayList();
                }
                this.departedMembers.add(id);
                this.selectedNode = null;
                this.selectedNodeDead = true;
                this.computeRemainingTimeout();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: processing loss of member {}", (Object)this, (Object)id);
                }
                this.lastNotifySpot = 3;
                this.notifyAll();
            }
            if (this.responseQueue != null) {
                this.responseQueue.remove(id);
            }
            this.checkIfDone();
        }
    }

    int getProcessorId() {
        return this.processorId;
    }

    synchronized void checkIfDone() {
        if (!this.remoteGetInProgress && this.pendingResponders.isEmpty()) {
            this.signalDone();
        }
    }

    synchronized void signalDone() {
        this.requestInProgress = false;
        this.lastNotifySpot = 1;
        this.notifyAll();
    }

    synchronized void signalTimedOut() {
        this.lastNotifySpot = 2;
        this.notifyAll();
    }

    synchronized void nackResponseComplete() {
    }

    static ProcessorKeeper21 getProcessorKeeper() {
        return processorKeeper;
    }

    boolean isNetSearch() {
        return this.netSearch;
    }

    boolean isNetLoad() {
        return this.netLoad;
    }

    boolean isLocalLoad() {
        return this.localLoad;
    }

    boolean isNetWrite() {
        return this.netWrite;
    }

    boolean isLocalWrite() {
        return this.localWrite;
    }

    long getLastModified() {
        return this.lastModified;
    }

    boolean resultIsSerialized() {
        return this.isSerialized;
    }

    static SearchLoadAndWriteProcessor getProcessor() {
        SearchLoadAndWriteProcessor processor = new SearchLoadAndWriteProcessor();
        processor.processorId = SearchLoadAndWriteProcessor.getProcessorKeeper().put(processor);
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void release() {
        block13: {
            try {
                if (this.lock == null) break block13;
                try {
                    this.lock.unlock();
                }
                catch (CancelException cancelException) {
                    // empty catch block
                }
                this.lock = null;
            }
            catch (Throwable throwable) {
                try {
                    if (this.advisor == null) throw throwable;
                    this.advisor.removeMembershipListener(this);
                    throw throwable;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw throwable;
                }
                finally {
                    SearchLoadAndWriteProcessor.getProcessorKeeper().remove(this.processorId);
                }
            }
        }
        try {
            if (this.advisor == null) return;
            this.advisor.removeMembershipListener(this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        finally {
            SearchLoadAndWriteProcessor.getProcessorKeeper().remove(this.processorId);
        }
    }

    void remove() {
        SearchLoadAndWriteProcessor.getProcessorKeeper().remove(this.processorId);
    }

    void initialize(LocalRegion theRegion, Object theKey, Object theCallbackArg) {
        this.region = theRegion;
        this.regionName = theRegion.getFullPath();
        this.key = theKey;
        this.aCallbackArgument = theCallbackArg;
        RegionAttributes attrs = theRegion.getAttributes();
        Scope scope = attrs.getScope();
        if (scope.isDistributed()) {
            this.advisor = ((CacheDistributionAdvisee)((Object)this.region)).getCacheDistributionAdvisor();
            this.distributionManager = theRegion.getDistributionManager();
            this.timeout = this.getSearchTimeout();
            this.advisor.addMembershipListener(this);
        }
    }

    void setKey(Object key) {
        this.key = key;
    }

    protected void setSelectedNode(InternalDistributedMember selectedNode) {
        this.selectedNode = selectedNode;
        this.selectedNodeDead = false;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    protected Object getKey() {
        return this.key;
    }

    InternalDistributedMember getSelectedNode() {
        return this.selectedNode;
    }

    private SearchLoadAndWriteProcessor() {
        this.resetResults();
        this.pendingResponders.clear();
        this.attemptedLocalLoad = false;
        this.netSearchDone = false;
        this.isSerialized = false;
        this.result = null;
        this.key = null;
        this.requestInProgress = false;
        this.netWriteSucceeded = false;
        this.remoteGetInProgress = false;
        this.responseQueue = null;
    }

    private void searchAndLoad(EntryEventImpl event, TXStateInterface txState, Object localValue) throws CacheLoaderException, TimeoutException {
        TXEntryState tx;
        RegionAttributes attrs = this.region.getAttributes();
        Scope scope = attrs.getScope();
        DataPolicy dataPolicy = attrs.getDataPolicy();
        if (txState != null && (tx = txState.txReadEntry(event.getKeyInfo(), this.region, false, true)) != null && tx.noValueInSystem()) {
            this.load(event);
            return;
        }
        if (localValue == Token.INVALID || dataPolicy.withReplication()) {
            this.load(event);
            return;
        }
        Object obj = null;
        if (!scope.isGlobal()) {
            CacheLoader loader = this.region.basicGetLoader();
            if (loader != null) {
                obj = this.doLocalLoad(loader, true);
                Assert.assertTrue(obj != Token.INVALID && obj != Token.LOCAL_INVALID);
                event.setNewValue(obj);
                this.isSerialized = false;
                this.result = obj;
                return;
            }
            if (scope.isLocal()) {
                return;
            }
        }
        this.netSearchForBlob();
        if (this.result != null) {
            Assert.assertTrue(this.result != Token.INVALID && this.result != Token.LOCAL_INVALID);
            if (this.isSerialized) {
                event.setSerializedNewValue((byte[])this.result);
            } else {
                event.setNewValue(this.result);
            }
            event.setVersionTag(this.versionTag);
            return;
        }
        this.load(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void netSearchForBlob() throws TimeoutException {
        if (this.netSearchDone) {
            return;
        }
        this.netSearchDone = true;
        CachePerfStats stats = this.region.getCachePerfStats();
        long start = 0L;
        HashSet sendSet = null;
        this.result = null;
        RegionAttributes attrs = this.region.getAttributes();
        this.requestInProgress = true;
        this.selectedNodeDead = false;
        this.initRemainingTimeout();
        start = stats.startNetsearch();
        try {
            ArrayList<InternalDistributedMember> replicates = new ArrayList<InternalDistributedMember>(this.advisor.adviseInitializedReplicates());
            if (replicates.size() > 1) {
                Collections.shuffle(replicates);
            }
            for (InternalDistributedMember replicate : replicates) {
                Object object = this.pendingResponders;
                synchronized (object) {
                    this.pendingResponders.clear();
                }
                object = this;
                synchronized (object) {
                    block30: {
                        this.requestInProgress = true;
                        this.remoteGetInProgress = true;
                        this.setSelectedNode(replicate);
                        this.lastNotifySpot = 0;
                        this.sendValueRequest(replicate);
                        this.waitForObject2(this.remainingTimeout);
                        if (!this.authorative) break block30;
                        if (this.result != null) {
                            this.netSearch = true;
                        }
                        return;
                    }
                    this.selectedNode = null;
                    this.selectedNodeDead = false;
                    this.lastNotifySpot = 0;
                    this.result = null;
                }
            }
            Object object = this.membersLock;
            synchronized (object) {
                Set recipients;
                block31: {
                    recipients = this.advisor.adviseNetSearch();
                    if (!recipients.isEmpty()) break block31;
                    return;
                }
                ArrayList list = new ArrayList(recipients);
                Collections.shuffle(list);
                sendSet = new HashSet(list);
                Set set = this.pendingResponders;
                synchronized (set) {
                    this.pendingResponders.clear();
                    this.pendingResponders.addAll(list);
                }
            }
            boolean useMulticast = this.region.getMulticastEnabled() && this.region instanceof DistributedRegion && ((DistributedRegion)this.region).getSystem().getConfig().getMcastPort() != 0;
            QueryMessage.sendMessage(this, this.regionName, this.key, useMulticast, sendSet, this.remainingTimeout, attrs.getEntryTimeToLive().getTimeout(), attrs.getEntryIdleTimeout().getTimeout());
            SearchLoadAndWriteProcessor searchLoadAndWriteProcessor = this;
            synchronized (searchLoadAndWriteProcessor) {
                boolean done = false;
                do {
                    this.waitForObject2(this.remainingTimeout);
                    if (this.selectedNodeDead && this.remoteGetInProgress) {
                        this.sendNetSearchRequest();
                        continue;
                    }
                    done = true;
                } while (!done);
                if (this.result != null) {
                    this.netSearch = true;
                }
                return;
            }
        }
        finally {
            stats.endNetsearch(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(EntryEventImpl event) throws CacheLoaderException, TimeoutException {
        Object obj = null;
        RegionAttributes attrs = this.region.getAttributes();
        Scope scope = attrs.getScope();
        CacheLoader loader = this.region.basicGetLoader();
        Assert.assertTrue(scope.isDistributed());
        if (loader != null && !scope.isGlobal()) {
            obj = this.doLocalLoad(loader, false);
            event.setNewValue(obj);
            Assert.assertTrue(obj != Token.INVALID && obj != Token.LOCAL_INVALID);
            return;
        }
        if (scope.isGlobal()) {
            Assert.assertTrue(this.lock == null);
            Set loadCandidatesSet = this.advisor.adviseNetLoad();
            if (loader == null && loadCandidatesSet.isEmpty()) {
                return;
            }
            this.lock = this.region.getDistributedLock(this.key);
            boolean locked = false;
            try {
                CancelCriterion stopper = this.region.getCancelCriterion();
                while (true) {
                    stopper.checkCancelInProgress(null);
                    boolean interrupted = Thread.interrupted();
                    try {
                        locked = this.lock.tryLock(this.region.getCache().getLockTimeout(), TimeUnit.SECONDS);
                        if (!locked) {
                            throw new TimeoutException(LocalizedStrings.SearchLoadAndWriteProcessor_TIMED_OUT_LOCKING_0_BEFORE_LOAD.toLocalizedString(this.key));
                        }
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                        this.region.getCancelCriterion().checkCancelInProgress(null);
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                if (loader == null) {
                    this.localLoad = false;
                    if (scope.isDistributed()) {
                        this.isSerialized = false;
                        obj = this.doNetLoad();
                        Assert.assertTrue(obj != Token.INVALID && obj != Token.LOCAL_INVALID);
                        if (this.isSerialized && obj != null) {
                            event.setSerializedNewValue((byte[])obj);
                        } else {
                            event.setNewValue(obj);
                        }
                    }
                } else {
                    obj = this.doLocalLoad(loader, false);
                    Assert.assertTrue(obj != Token.INVALID && obj != Token.LOCAL_INVALID);
                    event.setNewValue(obj);
                }
                return;
            }
            finally {
                if (!locked) {
                    this.lock = null;
                }
            }
        }
        if (scope.isDistributed()) {
            obj = this.doNetLoad();
            if (this.isSerialized && obj != null) {
                event.setSerializedNewValue((byte[])obj);
            } else {
                Assert.assertTrue(obj != Token.INVALID && obj != Token.LOCAL_INVALID);
                event.setNewValue(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doNetLoad() throws CacheLoaderException, TimeoutException {
        if (this.netLoadDone) {
            return null;
        }
        this.netLoadDone = true;
        if (this.advisor != null) {
            Set loadCandidatesSet = this.advisor.adviseNetLoad();
            if (loadCandidatesSet.isEmpty()) {
                return null;
            }
            CachePerfStats stats = this.region.getCachePerfStats();
            long start = stats.startNetload();
            ArrayList list = new ArrayList(loadCandidatesSet);
            Collections.shuffle(list);
            InternalDistributedMember[] loadCandidates = list.toArray(new InternalDistributedMember[list.size()]);
            this.initRemainingTimeout();
            RegionAttributes attrs = this.region.getAttributes();
            int index = 0;
            boolean stayInLoop = false;
            this.remoteLoadInProgress = true;
            try {
                do {
                    InternalDistributedMember next = loadCandidates[index++];
                    this.setSelectedNode(next);
                    this.lastNotifySpot = 0;
                    this.requestInProgress = true;
                    if (this.remainingTimeout <= 0) {
                        break;
                    }
                    this.remoteException = null;
                    NetLoadRequestMessage.sendMessage(this, this.regionName, this.key, this.aCallbackArgument, next, this.remainingTimeout, attrs.getEntryTimeToLive().getTimeout(), attrs.getEntryIdleTimeout().getTimeout());
                    this.waitForObject2(this.remainingTimeout);
                    if (this.remoteException == null) {
                        if (!this.requestInProgress) {
                            this.localLoad = false;
                            if (this.result != null) {
                                this.netLoad = true;
                            }
                            Object object = this.result;
                            return object;
                        }
                        if (!this.selectedNodeDead || index >= loadCandidates.length) continue;
                        continue;
                    }
                    if (this.remoteException instanceof TryAgainException) {
                        if (index < loadCandidates.length) {
                            continue;
                        }
                        break;
                    }
                    Throwable cause = this.remoteException instanceof CacheLoaderException ? this.remoteException.getCause() : this.remoteException;
                    throw new CacheLoaderException(LocalizedStrings.SearchLoadAndWriteProcessor_WHILE_INVOKING_A_REMOTE_NETLOAD_0.toLocalizedString(cause), cause);
                } while (stayInLoop);
            }
            finally {
                stats.endNetload(start);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doLocalLoad(CacheLoader loader, boolean netSearchAllowed) throws CacheLoaderException {
        Object obj = null;
        if (loader != null && !this.attemptedLocalLoad) {
            this.attemptedLocalLoad = true;
            CachePerfStats stats = this.region.getCachePerfStats();
            LoaderHelper loaderHelper = this.region.loaderHelperFactory.createLoaderHelper(this.key, this.aCallbackArgument, netSearchAllowed, true, this);
            long statStart = stats.startLoad();
            try {
                obj = loader.load(loaderHelper);
                obj = this.region.getCache().convertPdxInstanceIfNeeded(obj);
            }
            finally {
                stats.endLoad(statStart);
            }
            if (obj != null) {
                this.localLoad = true;
            }
        }
        return obj;
    }

    private CacheEvent getEventForListener(CacheEvent event) {
        EntryEventImpl r;
        Operation op = event.getOperation();
        if (!op.isEntry()) {
            return event;
        }
        EntryEventImpl result = r = (EntryEventImpl)event;
        if (r.isSingleHop()) {
            result = new EntryEventImpl(r);
            result.setOriginRemote(true);
            if (result.getOperation().isUpdate() && result.getTransactionId() == null) {
                result.makeCreate();
            }
        }
        if (op == Operation.REPLACE) {
            if (result == r) {
                result = new EntryEventImpl(r);
            }
            result.setOperation(Operation.UPDATE);
        } else if (op == Operation.PUT_IF_ABSENT) {
            if (result == r) {
                result = new EntryEventImpl(r);
            }
            result.setOperation(Operation.CREATE);
        } else if (op == Operation.REMOVE) {
            if (result == r) {
                result = new EntryEventImpl(r);
            }
            result.setOperation(Operation.DESTROY);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doLocalWrite(CacheWriter writer, CacheEvent pevent, int paction) throws CacheWriterException {
        if (pevent instanceof EntryEventImpl && ((EntryEventImpl)pevent).inhibitAllNotifications()) {
            if (SearchLoadAndWriteProcessor.logger.isDebugEnabled()) {
                SearchLoadAndWriteProcessor.logger.debug("Notification inhibited for key {}", (Object)pevent);
            }
            return false;
        }
        event = this.getEventForListener(pevent);
        action = paction;
        if (event.getOperation().isCreate() && action == 2) {
            action = 0;
        }
        if (event instanceof EntryEventImpl) {
            ((EntryEventImpl)event).setReadOldValueFromDisk(true);
        }
        try {
            switch (action) {
                case 0: {
                    writer.beforeCreate((EntryEvent)event);
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 1: {
                    writer.beforeDestroy((EntryEvent)event);
                    ** break;
lbl20:
                    // 1 sources

                    break;
                }
                case 2: {
                    writer.beforeUpdate((EntryEvent)event);
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 3: {
                    writer.beforeRegionDestroy((RegionEvent)event);
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 4: {
                    writer.beforeRegionClear((RegionEvent)event);
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                ** default:
lbl34:
                // 1 sources

                break;
            }
        }
        finally {
            if (event instanceof EntryEventImpl) {
                ((EntryEventImpl)event).setReadOldValueFromDisk(false);
            }
            if (event != pevent && event instanceof EntryEventImpl) {
                ((Releasable)event).release();
            }
        }
        this.localWrite = true;
        return true;
    }

    private boolean netWrite(CacheEvent event, int action, Set writeCandidateSet) throws CacheWriterException, TimeoutException {
        if (writeCandidateSet == null || writeCandidateSet.isEmpty()) {
            return false;
        }
        ArrayList list = new ArrayList(writeCandidateSet);
        Collections.shuffle(list);
        InternalDistributedMember[] writeCandidates = list.toArray(new InternalDistributedMember[list.size()]);
        this.initRemainingTimeout();
        int index = 0;
        do {
            InternalDistributedMember next = writeCandidates[index++];
            HashSet<InternalDistributedMember> set = new HashSet<InternalDistributedMember>();
            set.add(next);
            this.netWriteSucceeded = false;
            this.requestInProgress = true;
            this.remoteException = null;
            NetWriteRequestMessage.sendMessage(this, this.regionName, this.remainingTimeout, event, set, action);
            if (this.remainingTimeout <= 0) break;
            this.waitForObject2(this.remainingTimeout);
            if (this.netWriteSucceeded) {
                this.netWrite = true;
                break;
            }
            if (this.remoteException == null) continue;
            if (this.remoteException instanceof TryAgainException) {
                if (index >= writeCandidates.length) break;
                continue;
            }
            Throwable cause = this.remoteException instanceof CacheWriterException && this.remoteException.getCause() != null ? this.remoteException.getCause() : this.remoteException;
            throw new CacheWriterException(LocalizedStrings.SearchLoadAndWriteProcessor_WHILE_INVOKING_A_REMOTE_NETWRITE_0.toLocalizedString(cause), cause);
        } while (index < writeCandidates.length);
        return this.netWriteSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void incomingResponse(Object obj, long lastModifiedTime, boolean isPresent, boolean serialized, boolean requestorTimedOut, final InternalDistributedMember sender, ClusterDistributionManager dm, VersionTag versionTag) {
        if (this.remoteLoadInProgress) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignoring netsearch response from {} because we're now doing a netload", (Object)sender);
            }
            return;
        }
        if (this.pendingResponders.isEmpty()) {
            return;
        }
        if (!this.pendingResponders.remove(sender)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Processing response for processorId={}, isPresent is {}, sender is {}, key is {}, value is {}, version is {}", (Object)this.processorId, (Object)isPresent, (Object)sender, this.key, (Object)serialized, (Object)versionTag);
        }
        if (this.result != null) {
            return;
        }
        if (isPresent) {
            if (obj != null) {
                Assert.assertTrue(obj != Token.INVALID && obj != Token.LOCAL_INVALID);
                SearchLoadAndWriteProcessor searchLoadAndWriteProcessor = this;
                synchronized (searchLoadAndWriteProcessor) {
                    this.result = obj;
                    this.lastModified = lastModifiedTime;
                    this.isSerialized = serialized;
                    this.versionTag = versionTag;
                    this.signalDone();
                    return;
                }
            }
            if (!this.remoteGetInProgress) {
                try {
                    dm.getWaitingThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            SearchLoadAndWriteProcessor.this.sendValueRequest(sender);
                        }
                    });
                    this.requestInProgress = true;
                    this.remoteGetInProgress = true;
                    this.setSelectedNode(sender);
                    return;
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
            if (this.responseQueue == null) {
                this.responseQueue = new LinkedList();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Saving isPresent response, requestInProgress {}", (Object)sender);
            }
            this.responseQueue.add(sender);
        }
        if (requestorTimedOut) {
            this.signalTimedOut();
        }
        boolean endRequest = false;
        if (this.pendingResponders.isEmpty() && !this.remoteGetInProgress) {
            endRequest = true;
        }
        if (endRequest) {
            this.signalDone();
        }
    }

    protected synchronized void sendValueRequest(InternalDistributedMember sender) {
        RegionAttributes attrs = this.region.getAttributes();
        NetSearchRequestMessage.sendMessage(this, this.regionName, this.key, sender, this.remainingTimeout, attrs.getEntryTimeToLive().getTimeout(), attrs.getEntryIdleTimeout().getTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incomingNetLoadReply(Object obj, long lastModifiedTime, Object callbackArg, Exception e, boolean serialized, boolean requestorTimedOut) {
        SearchLoadAndWriteProcessor searchLoadAndWriteProcessor = this;
        synchronized (searchLoadAndWriteProcessor) {
            if (requestorTimedOut) {
                this.signalTimedOut();
                return;
            }
            this.result = obj;
            this.lastModified = lastModifiedTime;
            this.remoteException = e;
            this.aCallbackArgument = callbackArg;
            this.computeRemainingTimeout();
            this.isSerialized = serialized;
            this.signalDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void incomingNetSearchReply(byte[] value, long lastModifiedTime, boolean serialized, boolean requestorTimedOut, boolean authorative, VersionTag versionTag, InternalDistributedMember responder) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.departedMembers != null && this.departedMembers.contains(responder)) {
            if (isDebugEnabled) {
                logger.debug("ignore the reply received from a departed member");
            }
            return;
        }
        if (this.requestInProgress) {
            if (requestorTimedOut) {
                if (isDebugEnabled) {
                    logger.debug("incomingNetSearchReply() - requestorTimedOut {}", (Object)this);
                }
                this.signalTimedOut();
            }
            this.computeRemainingTimeout();
            if (value != null || authorative) {
                SearchLoadAndWriteProcessor searchLoadAndWriteProcessor = this;
                synchronized (searchLoadAndWriteProcessor) {
                    this.result = value;
                    this.lastModified = lastModifiedTime;
                    this.isSerialized = serialized;
                    this.remoteGetInProgress = false;
                    this.authorative = authorative;
                    this.versionTag = versionTag;
                    if (isDebugEnabled) {
                        logger.debug("incomingNetSearchReply() - got obj {}", (Object)this);
                    }
                    this.signalDone();
                }
            } else if (this.remainingTimeout <= 0) {
                this.remoteGetInProgress = false;
                if (isDebugEnabled) {
                    logger.debug("incomingNetSearchReply() - null obj, no more time {}", (Object)this);
                }
                this.signalDone();
            } else {
                if (isDebugEnabled) {
                    logger.debug("incomingNetSearchReply() - null obj, sendNetSearchRequest {}", (Object)this);
                }
                this.sendNetSearchRequest();
            }
        } else {
            if (isDebugEnabled) {
                logger.debug("incomingNetSearchReply() - requestInProgress is false {}", (Object)this);
            }
            this.checkIfDone();
        }
    }

    private InternalDistributedMember nextAppropriateResponder() {
        if (this.responseQueue != null && this.responseQueue.size() > 0) {
            return (InternalDistributedMember)this.responseQueue.remove(0);
        }
        return null;
    }

    private synchronized void sendNetSearchRequest() {
        InternalDistributedMember nextResponder = this.nextAppropriateResponder();
        if (nextResponder != null) {
            RegionAttributes attrs = this.region.getAttributes();
            this.setSelectedNode(nextResponder);
            this.requestInProgress = true;
            this.remoteGetInProgress = true;
            NetSearchRequestMessage.sendMessage(this, this.regionName, this.key, nextResponder, this.remainingTimeout, attrs.getEntryTimeToLive().getTimeout(), attrs.getEntryIdleTimeout().getTimeout());
        } else {
            this.remoteGetInProgress = false;
            this.checkIfDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incomingNetWriteReply(boolean netWriteSuccessful, Exception e, boolean exe) {
        SearchLoadAndWriteProcessor searchLoadAndWriteProcessor = this;
        synchronized (searchLoadAndWriteProcessor) {
            this.remoteException = e;
            this.netWriteSucceeded = netWriteSuccessful;
            this.computeRemainingTimeout();
            this.signalDone();
        }
    }

    private synchronized void initRemainingTimeout() {
        this.remainingTimeout = this.timeout * 1000;
        this.startTimeSnapShot = this.distributionManager.cacheTimeMillis();
    }

    private synchronized void computeRemainingTimeout() {
        if (this.startTimeSnapShot > 0L) {
            this.endTimeSnapShot = this.distributionManager.cacheTimeMillis();
            long delta = this.endTimeSnapShot - this.startTimeSnapShot;
            if (delta > 0L) {
                this.remainingTimeout = (int)((long)this.remainingTimeout - delta);
            }
            this.startTimeSnapShot = this.endTimeSnapShot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized void waitForObject2(int timeoutMs) throws TimeoutException {
        if (this.requestInProgress) {
            try {
                DistributionManager dm = this.region.getCache().getInternalDistributedSystem().getDistributionManager();
                long waitTimeMs = timeoutMs;
                long endTime = System.currentTimeMillis() + waitTimeMs;
                while (true) {
                    if (!this.requestInProgress) {
                        return;
                    }
                    if (waitTimeMs <= 0L) {
                        throw new TimeoutException(LocalizedStrings.SearchLoadAndWriteProcessor_TIMED_OUT_WHILE_DOING_NETSEARCHNETLOADNETWRITE_PROCESSORID_0_KEY_IS_1.toLocalizedString(this.processorId, this.key));
                    }
                    boolean interrupted = Thread.interrupted();
                    int lastNS = this.lastNotifySpot;
                    try {
                        boolean done;
                        boolean bl = done = lastNS != 0;
                        while (!done && waitTimeMs > 0L) {
                            this.region.getCancelCriterion().checkCancelInProgress(null);
                            interrupted = Thread.interrupted() || interrupted;
                            long wt = Math.min(RETRY_TIME, waitTimeMs);
                            this.wait(wt);
                            lastNS = this.lastNotifySpot;
                            done = lastNS != 0;
                            if (done) continue;
                            waitTimeMs = endTime - System.currentTimeMillis();
                        }
                        if (done) {
                            this.lastNotifySpot = 0;
                        }
                        if (this.requestInProgress && !this.selectedNodeDead) {
                            StringBuilder sb = new StringBuilder(200);
                            sb.append("processorId=").append(this.processorId);
                            sb.append(" Key is ").append(this.key);
                            sb.append(" searchTimeoutMs ").append(timeoutMs);
                            if (waitTimeMs > 0L) {
                                sb.append(" msRemaining=").append(waitTimeMs);
                            }
                            if (lastNS != 0) {
                                sb.append(" lastNotifySpot=").append(lastNS);
                            }
                            throw new TimeoutException(LocalizedStrings.SearchLoadAndWriteProcessor_TIMEOUT_DURING_NETSEARCHNETLOADNETWRITE_DETAILS_0.toLocalizedString(sb));
                        }
                        return;
                    }
                    catch (InterruptedException ignore) {
                        interrupted = true;
                        this.region.getCancelCriterion().checkCancelInProgress(null);
                        waitTimeMs = endTime - System.currentTimeMillis();
                        continue;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    break;
                }
            }
            finally {
                this.computeRemainingTimeout();
            }
        }
    }

    private int getSearchTimeout() {
        return this.region.getCache().getSearchTimeout();
    }

    private void resetResults() {
        this.netSearch = false;
        this.netLoad = false;
        this.localLoad = false;
        this.localWrite = false;
        this.netWrite = false;
        this.lastModified = 0L;
        this.isSerialized = false;
    }

    public String toString() {
        return super.toString() + " processorId " + this.processorId;
    }

    protected static void setClearCountReference(LocalRegion rgn) {
        DiskRegion dr = rgn.getDiskRegion();
        if (dr != null) {
            dr.setClearCountReference();
        }
    }

    protected static void removeClearCountReference(LocalRegion rgn) {
        DiskRegion dr = rgn.getDiskRegion();
        if (dr != null) {
            dr.removeClearCountReference();
        }
    }

    public void testNetSearchMessageDoGet(String theRegionName, Object theKey, int theTimeoutMs, int theTtl, int theIdleTime) {
        NetSearchRequestMessage nMsg = new NetSearchRequestMessage();
        nMsg.initialize(this, theRegionName, theKey, theTimeoutMs, theTtl, theIdleTime);
        nMsg.doGet((ClusterDistributionManager)this.distributionManager);
    }

    public static class NetWriteReplyMessage
    extends HighPriorityDistributionMessage {
        private int processorId;
        private boolean netWriteSucceeded;
        private Exception e;
        private boolean cacheWriterException;

        public static void sendMessage(InternalDistributedMember recipient, int processorId, ClusterDistributionManager distributionManager, boolean netWriteSucceeded, Exception e, boolean cacheWriterException) {
            NetWriteReplyMessage msg = new NetWriteReplyMessage();
            msg.initialize(processorId, netWriteSucceeded, e, cacheWriterException);
            msg.setRecipient(recipient);
            distributionManager.putOutgoing(msg);
        }

        private void initialize(int procId, boolean netwriteSucceeded, Exception except, boolean cacheWriterExcept) {
            this.processorId = procId;
            this.netWriteSucceeded = netwriteSucceeded;
            this.e = except;
            this.cacheWriterException = cacheWriterExcept;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            SearchLoadAndWriteProcessor processor = null;
            processor = (SearchLoadAndWriteProcessor)SearchLoadAndWriteProcessor.getProcessorKeeper().retrieve(this.processorId);
            if (processor == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("NetWriteReplyMessage() SearchLoadAndWriteProcessor no longer exists");
                }
                return;
            }
            processor.incomingNetWriteReply(this.netWriteSucceeded, this.e, this.cacheWriterException);
        }

        @Override
        public int getDSFID() {
            return 82;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeBoolean(this.netWriteSucceeded);
            DataSerializer.writeObject(this.e, out);
            out.writeBoolean(this.cacheWriterException);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.netWriteSucceeded = in.readBoolean();
            this.e = (Exception)DataSerializer.readObject(in);
            this.cacheWriterException = in.readBoolean();
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.NetWriteReplyMessage for processorId " + this.processorId;
        }
    }

    public static class NetWriteRequestMessage
    extends PooledDistributionMessage {
        private int processorId;
        private String regionName;
        CacheEvent event;
        private int timeoutMs;
        int action;

        public static void sendMessage(SearchLoadAndWriteProcessor processor, String regionName, int timeoutMs, CacheEvent event, Set recipients, int action) {
            NetWriteRequestMessage msg = new NetWriteRequestMessage();
            msg.initialize(processor, regionName, timeoutMs, event, action);
            msg.setRecipients(recipients);
            processor.distributionManager.putOutgoing(msg);
        }

        private void initialize(SearchLoadAndWriteProcessor processor, String theRegionName, int timeoutMS, CacheEvent theEvent, int actionType) {
            this.processorId = processor.processorId;
            this.regionName = theRegionName;
            this.timeoutMs = timeoutMS;
            this.event = theEvent;
            this.action = actionType;
            Assert.assertTrue(processor.region.getScope().isDistributed());
        }

        @Override
        public int getDSFID() {
            return 81;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeUTF(this.regionName);
            out.writeInt(this.timeoutMs);
            DataSerializer.writeObject(this.event, out);
            out.writeInt(this.action);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.regionName = in.readUTF();
            this.timeoutMs = in.readInt();
            this.event = (CacheEvent)DataSerializer.readObject(in);
            this.action = in.readInt();
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.NetWriteRequestMessage  for region \"" + this.regionName + "\", processorId " + this.processorId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            block37: {
                long startTime = dm.cacheTimeMillis();
                int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
                try {
                    InternalCache gfc = dm.getExistingCache();
                    LocalRegion region = (LocalRegion)gfc.getRegion(this.regionName);
                    if (region != null && region.isInitialized() && dm.cacheTimeMillis() - startTime < (long)this.timeoutMs) {
                        CacheWriter writer = region.basicGetWriter();
                        EntryEventImpl entryEvtImpl = null;
                        RegionEventImpl regionEvtImpl = null;
                        if (this.event instanceof EntryEventImpl) {
                            entryEvtImpl = (EntryEventImpl)this.event;
                            entryEvtImpl.setRegion(region);
                            Operation op = entryEvtImpl.getOperation();
                            if (op == Operation.REPLACE) {
                                entryEvtImpl.setOperation(Operation.UPDATE);
                            } else if (op == Operation.PUT_IF_ABSENT) {
                                entryEvtImpl.setOperation(Operation.CREATE);
                            } else if (op == Operation.REMOVE) {
                                entryEvtImpl.setOperation(Operation.DESTROY);
                            }
                            entryEvtImpl.setOriginRemote(this.event.getDistributedMember() == null || !this.event.getDistributedMember().equals(dm.getDistributionManagerId()));
                        } else if (this.event instanceof RegionEventImpl) {
                            regionEvtImpl = (RegionEventImpl)this.event;
                            regionEvtImpl.region = region;
                            regionEvtImpl.originRemote = true;
                        }
                        if (writer != null) {
                            if (entryEvtImpl != null) {
                                entryEvtImpl.setReadOldValueFromDisk(true);
                            }
                            try {
                                switch (this.action) {
                                    case 0: {
                                        writer.beforeCreate(entryEvtImpl);
                                        break;
                                    }
                                    case 1: {
                                        writer.beforeDestroy(entryEvtImpl);
                                        break;
                                    }
                                    case 2: {
                                        writer.beforeUpdate(entryEvtImpl);
                                        break;
                                    }
                                    case 3: {
                                        writer.beforeRegionDestroy(regionEvtImpl);
                                        break;
                                    }
                                    case 4: {
                                        writer.beforeRegionClear(regionEvtImpl);
                                        break;
                                    }
                                }
                                NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, true, null, false);
                                break block37;
                            }
                            catch (CacheWriterException cwe) {
                                NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, false, cwe, true);
                                break block37;
                            }
                            catch (Exception e) {
                                NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, false, e, false);
                                break block37;
                            }
                            finally {
                                if (entryEvtImpl != null) {
                                    entryEvtImpl.setReadOldValueFromDisk(false);
                                }
                            }
                        }
                        NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, false, new TryAgainException(LocalizedStrings.SearchLoadAndWriteProcessor_NO_CACHEWRITER_DEFINED_0.toLocalizedString()), true);
                        break block37;
                    }
                    NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, false, new TryAgainException(LocalizedStrings.SearchLoadAndWriteProcessor_TIMEOUT_EXPIRED_OR_REGION_NOT_READY_0.toLocalizedString()), true);
                }
                catch (RegionDestroyedException ignore) {
                    NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, false, null, false);
                }
                catch (DistributedSystemDisconnectedException e) {
                    throw e;
                }
                catch (CancelException cce) {
                    dm.getCancelCriterion().checkCancelInProgress(cce);
                    NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, false, null, false);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    NetWriteReplyMessage.sendMessage(this.getSender(), this.processorId, dm, false, new InternalGemFireException(LocalizedStrings.SearchLoadAndWriteProcessor_ERROR_PROCESSING_REQUEST.toLocalizedString(), t), true);
                }
                finally {
                    LocalRegion.setThreadInitLevelRequirement(oldLevel);
                }
            }
        }
    }

    public static class NetLoadReplyMessage
    extends HighPriorityDistributionMessage {
        private int processorId;
        private Object result;
        private Object aCallbackArgument;
        private Exception e;
        private boolean isSerialized;
        private boolean requestorTimedOut;

        public static void sendMessage(InternalDistributedMember recipient, int processorId, Object obj, ClusterDistributionManager distributionManager, Object aCallbackArgument, Exception e, boolean isSerialized, boolean requestorTimedOut) {
            NetLoadReplyMessage msg = new NetLoadReplyMessage();
            msg.initialize(processorId, obj, aCallbackArgument, e, isSerialized, requestorTimedOut);
            msg.setRecipient(recipient);
            distributionManager.putOutgoing(msg);
        }

        private void initialize(int procId, Object obj, Object callbackArgument, Exception exe, boolean isserialized, boolean requestorTimedout) {
            this.processorId = procId;
            this.result = obj;
            this.e = exe;
            this.aCallbackArgument = callbackArgument;
            this.isSerialized = isserialized;
            this.requestorTimedOut = requestorTimedout;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            SearchLoadAndWriteProcessor processor = null;
            processor = (SearchLoadAndWriteProcessor)SearchLoadAndWriteProcessor.getProcessorKeeper().retrieve(this.processorId);
            if (processor == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("NetLoadReplyMessage() SearchLoadAndWriteProcessor no longer exists");
                }
                return;
            }
            processor.incomingNetLoadReply(this.result, 0L, this.aCallbackArgument, this.e, this.isSerialized, this.requestorTimedOut);
        }

        @Override
        public int getDSFID() {
            return 80;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            boolean isSerialized = this.isSerialized;
            if (this.result instanceof byte[]) {
                DataSerializer.writeByteArray((byte[])this.result, out);
            } else {
                DataSerializer.writeObjectAsByteArray(this.result, out);
                isSerialized = true;
            }
            DataSerializer.writeObject(this.aCallbackArgument, out);
            DataSerializer.writeObject(this.e, out);
            out.writeBoolean(isSerialized);
            out.writeBoolean(this.requestorTimedOut);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.result = DataSerializer.readByteArray(in);
            this.aCallbackArgument = DataSerializer.readObject(in);
            this.e = (Exception)DataSerializer.readObject(in);
            this.isSerialized = in.readBoolean();
            this.requestorTimedOut = in.readBoolean();
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.NetLoadReplyMessage for processorId " + this.processorId + ", blob is " + this.result;
        }
    }

    public static class NetLoadRequestMessage
    extends PooledDistributionMessage {
        private int processorId;
        private String regionName;
        private Object key;
        private Object aCallbackArgument;
        private int timeoutMs;
        private int ttl;
        private int idleTime;

        public static void sendMessage(SearchLoadAndWriteProcessor processor, String regionName, Object key, Object aCallbackArgument, InternalDistributedMember recipient, int timeoutMs, int ttl, int idleTime) {
            NetLoadRequestMessage msg = new NetLoadRequestMessage();
            msg.initialize(processor, regionName, key, aCallbackArgument, timeoutMs, ttl, idleTime);
            msg.setRecipient(recipient);
            try {
                processor.distributionManager.putOutgoing(msg);
            }
            catch (InternalGemFireException e) {
                throw new IllegalArgumentException(LocalizedStrings.SearchLoadAndWriteProcessor_MESSAGE_NOT_SERIALIZABLE.toLocalizedString());
            }
        }

        private void initialize(SearchLoadAndWriteProcessor processor, String theRegionName, Object theKey, Object callbackArgument, int timeoutMS, int ttlMS, int idleTimeMS) {
            this.processorId = processor.processorId;
            this.regionName = theRegionName;
            this.key = theKey;
            this.aCallbackArgument = callbackArgument;
            this.timeoutMs = timeoutMS;
            this.ttl = ttlMS;
            this.idleTime = idleTimeMS;
            Assert.assertTrue(processor.region.getScope().isDistributed());
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            this.doLoad(dm);
        }

        @Override
        public int getDSFID() {
            return 79;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeUTF(this.regionName);
            DataSerializer.writeObject(this.key, out);
            DataSerializer.writeObject(this.aCallbackArgument, out);
            out.writeInt(this.timeoutMs);
            out.writeInt(this.ttl);
            out.writeInt(this.idleTime);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.regionName = in.readUTF();
            this.key = DataSerializer.readObject(in);
            this.aCallbackArgument = DataSerializer.readObject(in);
            this.timeoutMs = in.readInt();
            this.ttl = in.readInt();
            this.idleTime = in.readInt();
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.NetLoadRequestMessage for \"" + this.key + "\" in region \"" + this.regionName + "\", processorId " + this.processorId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doLoad(ClusterDistributionManager dm) {
            block17: {
                long startTime = dm.cacheTimeMillis();
                int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
                try {
                    InternalCache gfc = dm.getExistingCache();
                    LocalRegion region = (LocalRegion)gfc.getRegion(this.regionName);
                    if (region != null && region.isInitialized() && dm.cacheTimeMillis() - startTime < (long)this.timeoutMs) {
                        CacheLoader loader = region.basicGetLoader();
                        if (loader != null) {
                            LoaderHelper loaderHelper = region.loaderHelperFactory.createLoaderHelper(this.key, this.aCallbackArgument, false, false, null);
                            CachePerfStats stats = region.getCachePerfStats();
                            long start = stats.startLoad();
                            try {
                                Object o = loader.load(loaderHelper);
                                Assert.assertTrue(o != Token.INVALID && o != Token.LOCAL_INVALID);
                                NetLoadReplyMessage.sendMessage(this.getSender(), this.processorId, o, dm, loaderHelper.getArgument(), null, false, false);
                                break block17;
                            }
                            catch (Exception e) {
                                this.replyWithException(e, dm);
                                break block17;
                            }
                            finally {
                                stats.endLoad(start);
                            }
                        }
                        this.replyWithException(new TryAgainException(LocalizedStrings.SearchLoadAndWriteProcessor_NO_LOADER_DEFINED_0.toLocalizedString()), dm);
                        break block17;
                    }
                    this.replyWithException(new TryAgainException(LocalizedStrings.SearchLoadAndWriteProcessor_TIMEOUT_EXPIRED_OR_REGION_NOT_READY_0.toLocalizedString()), dm);
                }
                catch (RegionDestroyedException rde) {
                    this.replyWithException(rde, dm);
                }
                catch (CancelException cce) {
                    this.replyWithException(cce, dm);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    this.replyWithException(new InternalGemFireException(LocalizedStrings.SearchLoadAndWriteProcessor_ERROR_PROCESSING_REQUEST.toLocalizedString(), t), dm);
                }
                finally {
                    LocalRegion.setThreadInitLevelRequirement(oldLevel);
                }
            }
        }

        void replyWithException(Exception e, ClusterDistributionManager dm) {
            NetLoadReplyMessage.sendMessage(this.getSender(), this.processorId, null, dm, this.aCallbackArgument, e, false, false);
        }
    }

    public static class NetSearchReplyMessage
    extends HighPriorityDistributionMessage {
        private static final byte SERIALIZED = 1;
        private static final byte REQUESTOR_TIMEOUT = 2;
        private static final byte AUTHORATIVE = 4;
        private static final byte VERSIONED = 8;
        private static final byte PERSISTENT = 16;
        private int processorId;
        private byte[] value;
        private transient Object valueObj;
        private transient int valueLen;
        private long lastModified;
        private boolean isSerialized;
        private boolean requestorTimedOut;
        private boolean authoritative;
        private VersionTag versionTag;

        public static void sendMessage(InternalDistributedMember recipient, int processorId, Object key, byte[] value, Object valueObj, int valueLen, long lastModified, boolean isSerialized, boolean requestorTimedOut, boolean authoritative, ClusterDistributionManager distributionManager, VersionTag versionTag) {
            NetSearchReplyMessage msg = new NetSearchReplyMessage();
            msg.initialize(processorId, value, valueObj, valueLen, lastModified, isSerialized, requestorTimedOut, authoritative, versionTag);
            msg.setRecipient(recipient);
            distributionManager.putOutgoing(msg);
        }

        private void initialize(int procId, byte[] theValue, Object theValueObj, int valueObjLen, long lastModifiedTime, boolean isserialized, boolean requestorTimedout, boolean authoritative, VersionTag versionTag) {
            this.processorId = procId;
            this.value = theValue;
            this.valueObj = theValueObj;
            this.valueLen = valueObjLen;
            this.lastModified = lastModifiedTime;
            this.isSerialized = isserialized;
            this.requestorTimedOut = requestorTimedout;
            this.authoritative = authoritative;
            this.versionTag = versionTag;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            SearchLoadAndWriteProcessor processor = null;
            processor = (SearchLoadAndWriteProcessor)SearchLoadAndWriteProcessor.getProcessorKeeper().retrieve(this.processorId);
            if (processor == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("NetSearchReplyMessage() SearchLoadAndWriteProcessor {} no longer exists", (Object)this.processorId);
                }
                return;
            }
            long lastModifiedSystemTime = 0L;
            if (this.lastModified != 0L) {
                lastModifiedSystemTime = this.lastModified;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            processor.incomingNetSearchReply(this.value, lastModifiedSystemTime, this.isSerialized, this.requestorTimedOut, this.authoritative, this.versionTag, this.getSender());
        }

        @Override
        public int getDSFID() {
            return 78;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            if (this.valueObj != null) {
                DataSerializer.writeObjectAsByteArray(this.valueObj, out);
            } else {
                DataSerializer.writeByteArray(this.value, this.valueLen, out);
            }
            out.writeLong(this.lastModified);
            byte booleans = 0;
            if (this.isSerialized) {
                booleans = (byte)(booleans | 1);
            }
            if (this.requestorTimedOut) {
                booleans = (byte)(booleans | 2);
            }
            if (this.authoritative) {
                booleans = (byte)(booleans | 4);
            }
            if (this.versionTag != null) {
                booleans = (byte)(booleans | 8);
            }
            if (this.versionTag instanceof DiskVersionTag) {
                booleans = (byte)(booleans | 0x10);
            }
            out.writeByte(booleans);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.value = DataSerializer.readByteArray(in);
            if (this.value != null) {
                this.valueLen = this.value.length;
            }
            this.lastModified = in.readLong();
            byte booleans = in.readByte();
            this.isSerialized = (booleans & 1) != 0;
            this.requestorTimedOut = (booleans & 2) != 0;
            boolean bl = this.authoritative = (booleans & 4) != 0;
            if ((booleans & 8) != 0) {
                boolean persistentTag = (booleans & 0x10) != 0;
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.NetSearchReplyMessage for processorId " + this.processorId + ", blob is " + (this.value == null ? "null" : "(" + this.value.length + " bytes)") + " authorative=" + this.authoritative + " versionTag=" + this.versionTag;
        }
    }

    public static class NetSearchRequestMessage
    extends PooledDistributionMessage {
        private int processorId;
        private String regionName;
        private Object key;
        private int timeoutMs;
        private int ttl;
        private int idleTime;
        private static final short HAS_TTL = 64;
        private static final short HAS_IDLE_TIME = 128;

        public static void sendMessage(SearchLoadAndWriteProcessor processor, String regionName, Object key, InternalDistributedMember recipient, int timeoutMs, int ttl, int idleTime) {
            NetSearchRequestMessage msg = new NetSearchRequestMessage();
            msg.initialize(processor, regionName, key, timeoutMs, ttl, idleTime);
            msg.setRecipient(recipient);
            processor.distributionManager.putOutgoing(msg);
        }

        private void initialize(SearchLoadAndWriteProcessor processor, String theRegionName, Object theKey, int timeoutMS, int ttlMS, int idleTimeMS) {
            this.processorId = processor.processorId;
            this.regionName = theRegionName;
            this.key = theKey;
            this.timeoutMs = timeoutMS;
            this.ttl = ttlMS;
            this.idleTime = idleTimeMS;
            Assert.assertTrue(processor.region.getScope().isDistributed());
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            this.doGet(dm);
        }

        @Override
        public int getDSFID() {
            return 77;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            short flags = 0;
            if (this.processorId != 0) {
                flags = (short)(flags | 1);
            }
            if (this.ttl != 0) {
                flags = (short)(flags | 0x40);
            }
            if (this.idleTime != 0) {
                flags = (short)(flags | 0x80);
            }
            out.writeShort(flags);
            if (this.processorId != 0) {
                out.writeInt(this.processorId);
            }
            out.writeUTF(this.regionName);
            DataSerializer.writeObject(this.key, out);
            out.writeInt(this.timeoutMs);
            if (this.ttl != 0) {
                InternalDataSerializer.writeSignedVL(this.ttl, out);
            }
            if (this.idleTime != 0) {
                InternalDataSerializer.writeSignedVL(this.idleTime, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            short flags = in.readShort();
            if ((flags & 1) != 0) {
                this.processorId = in.readInt();
                ReplyProcessor21.setMessageRPId(this.processorId);
            }
            this.regionName = in.readUTF();
            this.key = DataSerializer.readObject(in);
            this.timeoutMs = in.readInt();
            if ((flags & 0x40) != 0) {
                this.ttl = (int)InternalDataSerializer.readSignedVL(in);
            }
            if ((flags & 0x80) != 0) {
                this.idleTime = (int)InternalDataSerializer.readSignedVL(in);
            }
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.NetSearchRequestMessage for \"" + this.key + "\" in region \"" + this.regionName + "\", processorId " + this.processorId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doGet(ClusterDistributionManager dm) {
            long startTime = dm.cacheTimeMillis();
            byte[] ebv = null;
            Object ebvObj = null;
            int ebvLen = 0;
            long lastModifiedCacheTime = 0L;
            boolean isSer = false;
            boolean requestorTimedOut = false;
            boolean authoritative = false;
            VersionTag versionTag = null;
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
            try {
                LocalRegion region = (LocalRegion)dm.getExistingCache().getRegion(this.regionName);
                if (region != null) {
                    SearchLoadAndWriteProcessor.setClearCountReference(region);
                    try {
                        boolean initialized = region.isInitialized();
                        RegionEntry entry = region.basicGetEntry(this.key);
                        if (entry != null) {
                            RegionEntry regionEntry = entry;
                            synchronized (regionEntry) {
                                Object eov;
                                VersionStamp versionStamp = entry.getVersionStamp();
                                if (versionStamp != null) {
                                    versionTag = versionStamp.asVersionTag();
                                }
                                if ((eov = region.getNoLRU(this.key, false, true, true)) != null && eov != Token.INVALID && eov != Token.LOCAL_INVALID) {
                                    if (dm.cacheTimeMillis() - startTime < (long)this.timeoutMs) {
                                        if (!region.isExpiredWithRegardTo(this.key, this.ttl, this.idleTime)) {
                                            lastModifiedCacheTime = entry.getLastModified();
                                            if (eov instanceof CachedDeserializable) {
                                                CachedDeserializable cd = (CachedDeserializable)eov;
                                                if (!cd.isSerialized()) {
                                                    isSer = false;
                                                    ebv = (byte[])cd.getDeserializedForReading();
                                                    ebvLen = ebv.length;
                                                } else {
                                                    Object tmp = cd.getValue();
                                                    if (tmp instanceof byte[]) {
                                                        byte[] bb;
                                                        ebv = bb = (byte[])tmp;
                                                        ebvLen = bb.length;
                                                    } else {
                                                        ebvObj = tmp;
                                                    }
                                                    isSer = true;
                                                }
                                            } else if (!(eov instanceof byte[])) {
                                                ebvObj = eov;
                                                isSer = true;
                                            } else {
                                                ebv = (byte[])eov;
                                                ebvLen = ebv.length;
                                            }
                                        }
                                    } else {
                                        requestorTimedOut = true;
                                    }
                                }
                            }
                        }
                        authoritative = region.getDataPolicy().withReplication() && initialized && !region.isDestroyed;
                    }
                    finally {
                        SearchLoadAndWriteProcessor.removeClearCountReference(region);
                    }
                }
                NetSearchReplyMessage.sendMessage(this.getSender(), this.processorId, this.key, ebv, ebvObj, ebvLen, lastModifiedCacheTime, isSer, requestorTimedOut, authoritative, dm, versionTag);
            }
            catch (RegionDestroyedException ignore) {
                this.replyWithNull(dm);
            }
            catch (CancelException ignore) {
                this.replyWithNull(dm);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn((Message)LocalizedMessage.create(LocalizedStrings.SearchLoadAndWriteProcessor_UNEXPECTED_EXCEPTION), t);
                this.replyWithNull(dm);
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
        }

        private void replyWithNull(ClusterDistributionManager dm) {
            NetSearchReplyMessage.sendMessage(this.getSender(), this.processorId, this.key, null, null, 0, 0L, false, false, false, dm, null);
        }
    }

    public static class ResponseMessage
    extends HighPriorityDistributionMessage {
        private Object key;
        private int processorId;
        private Object result;
        private long lastModified;
        private boolean isPresent;
        private boolean isSerialized;
        private boolean requestorTimedOut;
        private VersionTag versionTag;

        public static void sendMessage(Object key, InternalDistributedMember recipient, int processorId, Object result, long lastModified, boolean isPresent, boolean isSerialized, boolean requestorTimedOut, ClusterDistributionManager distributionManager, VersionTag versionTag) {
            ResponseMessage msg = new ResponseMessage();
            msg.initialize(key, processorId, result, lastModified, isPresent, isSerialized, requestorTimedOut, versionTag);
            msg.setRecipient(recipient);
            distributionManager.putOutgoing(msg);
        }

        private void initialize(Object theKey, int theProcessorId, Object theResult, long lastModifiedTime, boolean ispresent, boolean isserialized, boolean requestorTimedOutFlag, VersionTag versionTag) {
            this.key = theKey;
            this.processorId = theProcessorId;
            this.result = theResult;
            this.lastModified = lastModifiedTime;
            this.isPresent = ispresent;
            this.isSerialized = isserialized;
            this.requestorTimedOut = requestorTimedOutFlag;
            this.versionTag = versionTag;
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            SearchLoadAndWriteProcessor processor = null;
            processor = (SearchLoadAndWriteProcessor)SearchLoadAndWriteProcessor.getProcessorKeeper().retrieve(this.processorId);
            if (processor == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Response() SearchLoadAndWriteProcessor no longer exists");
                }
                return;
            }
            long lastModifiedSystemTime = 0L;
            if (this.lastModified != 0L) {
                lastModifiedSystemTime = this.lastModified;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            processor.incomingResponse(this.result, lastModifiedSystemTime, this.isPresent, this.isSerialized, this.requestorTimedOut, this.getSender(), dm, this.versionTag);
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        @Override
        public int getDSFID() {
            return 76;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.key, out);
            out.writeInt(this.processorId);
            DataSerializer.writeObject(this.result, out);
            out.writeLong(this.lastModified);
            out.writeBoolean(this.isPresent);
            out.writeBoolean(this.isSerialized);
            out.writeBoolean(this.requestorTimedOut);
            DataSerializer.writeObject(this.versionTag, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.key = DataSerializer.readObject(in);
            this.processorId = in.readInt();
            this.result = DataSerializer.readObject(in);
            this.lastModified = in.readLong();
            this.isPresent = in.readBoolean();
            this.isSerialized = in.readBoolean();
            this.requestorTimedOut = in.readBoolean();
            this.versionTag = (VersionTag)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.ResponseMessage for processorId " + this.processorId + ", blob is " + this.result + ", isPresent is " + this.isPresent + ", requestorTimedOut is " + this.requestorTimedOut + ", version is " + this.versionTag;
        }
    }

    public static class QueryMessage
    extends SerialDistributionMessage {
        private int processorId;
        private String regionName;
        private Object key;
        private int timeoutMs;
        private int ttl;
        private int idleTime;
        private boolean alwaysSendResult;
        private static final short HAS_TTL = 64;
        private static final short HAS_IDLE_TIME = 128;
        private static final short ALWAYS_SEND_RESULT = 256;

        public static void sendMessage(SearchLoadAndWriteProcessor processor, String regionName, Object key, boolean multicast, Set recipients, int timeoutMs, int ttl, int idleTime) {
            QueryMessage msg = new QueryMessage();
            msg.initialize(processor, regionName, key, multicast, timeoutMs, ttl, idleTime);
            msg.setRecipients(recipients);
            if (!multicast && recipients.size() == 1) {
                msg.alwaysSendResult = true;
            }
            processor.distributionManager.putOutgoing(msg);
        }

        private void initialize(SearchLoadAndWriteProcessor processor, String theRegionName, Object theKey, boolean multicast, int theTimeoutMs, int theTtl, int theIdleTime) {
            this.processorId = processor.processorId;
            this.regionName = theRegionName;
            this.setMulticast(multicast);
            this.key = theKey;
            this.timeoutMs = theTimeoutMs;
            this.ttl = theTtl;
            this.idleTime = theIdleTime;
            Assert.assertTrue(processor.region.getScope().isDistributed());
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            this.doGet(dm);
        }

        @Override
        public int getDSFID() {
            return 75;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            short flags = 0;
            if (this.processorId != 0) {
                flags = (short)(flags | 1);
            }
            if (this.ttl != 0) {
                flags = (short)(flags | 0x40);
            }
            if (this.idleTime != 0) {
                flags = (short)(flags | 0x80);
            }
            if (this.alwaysSendResult) {
                flags = (short)(flags | 0x100);
            }
            out.writeShort(flags);
            if (this.processorId != 0) {
                out.writeInt(this.processorId);
            }
            out.writeUTF(this.regionName);
            DataSerializer.writeObject(this.key, out);
            out.writeInt(this.timeoutMs);
            if (this.ttl != 0) {
                InternalDataSerializer.writeSignedVL(this.ttl, out);
            }
            if (this.idleTime != 0) {
                InternalDataSerializer.writeSignedVL(this.idleTime, out);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            short flags = in.readShort();
            if ((flags & 1) != 0) {
                this.processorId = in.readInt();
                ReplyProcessor21.setMessageRPId(this.processorId);
            }
            this.regionName = in.readUTF();
            this.key = DataSerializer.readObject(in);
            this.timeoutMs = in.readInt();
            if ((flags & 0x40) != 0) {
                this.ttl = (int)InternalDataSerializer.readSignedVL(in);
            }
            if ((flags & 0x80) != 0) {
                this.idleTime = (int)InternalDataSerializer.readSignedVL(in);
            }
            this.alwaysSendResult = (flags & 0x100) != 0;
        }

        @Override
        public String toString() {
            return "SearchLoadAndWriteProcessor.QueryMessage for \"" + this.key + "\" in region \"" + this.regionName + "\", processorId " + this.processorId + ", timeoutMs=" + this.timeoutMs + ", ttl=" + this.ttl + ", idleTime=" + this.idleTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doGet(ClusterDistributionManager dm) {
            long startTime = dm.cacheTimeMillis();
            boolean isPresent = false;
            boolean sendResult = false;
            boolean isSer = false;
            long lastModifiedCacheTime = 0L;
            boolean requestorTimedOut = false;
            VersionTag tag = null;
            if (dm.getDMType() == 12 || this.getSender().equals(dm.getDistributionManagerId())) {
                return;
            }
            int oldLevel = LocalRegion.setThreadInitLevelRequirement(1);
            try {
                Object o;
                block30: {
                    InternalCache cache = dm.getExistingCache();
                    if (cache.isGlobalRegionInitializing(this.regionName)) {
                        this.replyWithNull(dm);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Global Region not initialized yet");
                        }
                        return;
                    }
                    LocalRegion region = (LocalRegion)dm.getExistingCache().getRegion(this.regionName);
                    o = null;
                    if (region != null) {
                        SearchLoadAndWriteProcessor.setClearCountReference(region);
                        try {
                            RegionEntry entry = region.basicGetEntry(this.key);
                            if (entry != null) {
                                RegionEntry regionEntry = entry;
                                synchronized (regionEntry) {
                                    assert (region.isInitialized());
                                    if (dm.cacheTimeMillis() - startTime < (long)this.timeoutMs) {
                                        o = region.getNoLRU(this.key, false, true, true);
                                        if (!(o == null || Token.isInvalid(o) || Token.isRemoved(o) || region.isExpiredWithRegardTo(this.key, this.ttl, this.idleTime))) {
                                            isPresent = true;
                                            VersionStamp stamp = entry.getVersionStamp();
                                            if (stamp != null && stamp.hasValidVersion()) {
                                                tag = stamp.asVersionTag();
                                            }
                                            lastModifiedCacheTime = entry.getLastModified();
                                            isSer = o instanceof CachedDeserializable;
                                            if (isSer) {
                                                o = ((CachedDeserializable)o).getSerializedValue();
                                            }
                                            if (isPresent && (this.alwaysSendResult || ObjectSizer.DEFAULT.sizeof(o) < SMALL_BLOB_SIZE)) {
                                                sendResult = true;
                                            }
                                        }
                                    } else {
                                        requestorTimedOut = true;
                                    }
                                    break block30;
                                }
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug("Entry is null");
                            }
                        }
                        finally {
                            SearchLoadAndWriteProcessor.removeClearCountReference(region);
                        }
                    }
                }
                ResponseMessage.sendMessage(this.key, this.getSender(), this.processorId, sendResult ? o : null, lastModifiedCacheTime, isPresent, isSer, requestorTimedOut, dm, tag);
            }
            catch (RegionDestroyedException ignore) {
                logger.debug("Region Destroyed Exception in QueryMessage doGet, null");
                this.replyWithNull(dm);
            }
            catch (CancelException ignore) {
                logger.debug("CacheClosedException in QueryMessage doGet, null");
                this.replyWithNull(dm);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.debug("Throwable in QueryMessage doGet, null", t);
                this.replyWithNull(dm);
            }
            finally {
                LocalRegion.setThreadInitLevelRequirement(oldLevel);
            }
        }

        private void replyWithNull(ClusterDistributionManager dm) {
            ResponseMessage.sendMessage(this.key, this.getSender(), this.processorId, null, 0L, false, false, false, dm, null);
        }
    }

    private static class TryAgainException
    extends GemFireException {
        public TryAgainException() {
        }

        public TryAgainException(String message) {
            super(message);
        }
    }
}

