/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.cache.DiskAccessException;
import org.apache.geode.internal.cache.AbstractDiskRegion;
import org.apache.geode.internal.cache.CompactableOplog;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.Oplog;
import org.apache.geode.internal.cache.OplogSet;
import org.apache.geode.internal.cache.ValidatingDiskRegion;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.cache.persistence.DiskRegionView;
import org.apache.geode.internal.cache.persistence.DiskStoreFilter;
import org.apache.geode.internal.cache.persistence.OplogType;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class PersistentOplogSet
implements OplogSet {
    private static final Logger logger = LogService.getLogger();
    protected volatile Oplog child;
    private final AtomicLong oplogEntryId = new AtomicLong(0L);
    int dirCounter = -1;
    final Map<Long, Oplog> drfOnlyOplogs = new LinkedHashMap<Long, Oplog>();
    final Map<Long, Oplog> oplogIdToOplog = new LinkedHashMap<Long, Oplog>();
    private final Map<Long, Oplog> inactiveOplogs = new LinkedHashMap<Long, Oplog>(16, 0.75f, true);
    private final DiskStoreImpl parent;
    final AtomicInteger inactiveOpenCount = new AtomicInteger();
    private final Map<Long, DiskRecoveryStore> pendingRecoveryMap = new HashMap<Long, DiskRecoveryStore>();
    private final Map<Long, DiskRecoveryStore> currentRecoveryMap = new HashMap<Long, DiskRecoveryStore>();
    final AtomicBoolean alreadyRecoveredOnce = new AtomicBoolean(false);
    private volatile long maxRecoveredOplogId = 0L;

    public PersistentOplogSet(DiskStoreImpl parent) {
        this.parent = parent;
    }

    public Oplog getChild() {
        return this.child;
    }

    void setChild(Oplog oplog) {
        this.child = oplog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Oplog[] getAllOplogs() {
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            int i;
            int rollNum = this.oplogIdToOplog.size();
            int inactiveNum = this.inactiveOplogs.size();
            int drfOnlyNum = this.drfOnlyOplogs.size();
            int num = rollNum + inactiveNum + drfOnlyNum + 1;
            Oplog[] oplogs = new Oplog[num];
            oplogs[0] = this.getChild();
            Iterator<Oplog> itr = this.oplogIdToOplog.values().iterator();
            for (i = 1; i <= rollNum; ++i) {
                oplogs[i] = itr.next();
            }
            itr = this.inactiveOplogs.values().iterator();
            for (i = 1; i <= inactiveNum; ++i) {
                oplogs[i + rollNum] = itr.next();
            }
            itr = this.drfOnlyOplogs.values().iterator();
            for (i = 1; i <= drfOnlyNum; ++i) {
                oplogs[i + rollNum + inactiveNum] = itr.next();
            }
            if (oplogs.length == 1 && oplogs[0] == null) {
                return new Oplog[0];
            }
            return oplogs;
        }
    }

    private TreeSet<Oplog> getSortedOplogs() {
        TreeSet<Oplog> result = new TreeSet<Oplog>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return Long.signum(((Oplog)arg1).getOplogId() - ((Oplog)arg0).getOplogId());
            }
        });
        for (Oplog oplog : this.getAllOplogs()) {
            if (oplog == null) continue;
            result.add(oplog);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Oplog getChild(long id) {
        Oplog localOplog = this.child;
        if (localOplog != null && id == localOplog.getOplogId()) {
            return localOplog;
        }
        Long key = id;
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            Oplog result = this.oplogIdToOplog.get(key);
            if (result == null) {
                result = this.inactiveOplogs.get(key);
            }
            return result;
        }
    }

    @Override
    public void create(InternalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        this.getChild().create(region, entry, value, async);
    }

    @Override
    public void modify(InternalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) {
        this.getChild().modify(region, entry, value, async);
    }

    public void offlineModify(DiskRegionView drv, DiskEntry entry, byte[] value, boolean isSerializedObject) {
        this.getChild().offlineModify(drv, entry, value, isSerializedObject);
    }

    @Override
    public void remove(InternalRegion region, DiskEntry entry, boolean async, boolean isClear) {
        this.getChild().remove(region, entry, async, isClear);
    }

    public void forceRoll(DiskRegion dr) {
        Oplog child = this.getChild();
        if (child != null) {
            child.forceRolling(dr);
        }
    }

    public Map<File, DirectoryHolder> findFiles(String partialFileName) {
        this.dirCounter = 0;
        HashMap<File, DirectoryHolder> backupFiles = new HashMap<File, DirectoryHolder>();
        FilenameFilter backupFileFilter = this.getFileNameFilter(partialFileName);
        for (DirectoryHolder dh : this.parent.directories) {
            File[] backupList = dh.getDir().listFiles(backupFileFilter);
            if (backupList == null) continue;
            for (File f : backupList) {
                backupFiles.put(f, dh);
            }
        }
        return backupFiles;
    }

    protected FilenameFilter getFileNameFilter(String partialFileName) {
        return new DiskStoreFilter(OplogType.BACKUP, false, partialFileName);
    }

    public void createOplogs(boolean needsOplogs, Map<File, DirectoryHolder> backupFiles) {
        LongOpenHashSet foundCrfs = new LongOpenHashSet();
        LongOpenHashSet foundDrfs = new LongOpenHashSet();
        for (Map.Entry<File, DirectoryHolder> entry : backupFiles.entrySet()) {
            Oplog oplog;
            File file = entry.getKey();
            String absolutePath = file.getAbsolutePath();
            int underscorePosition = absolutePath.lastIndexOf("_");
            int pointPosition = absolutePath.lastIndexOf(".");
            String opid = absolutePath.substring(underscorePosition + 1, pointPosition);
            long oplogId = Long.parseLong(opid);
            this.maxRecoveredOplogId = Math.max(this.maxRecoveredOplogId, oplogId);
            if (Oplog.isCRFFile(file.getName())) {
                if (!this.isCrfOplogIdPresent(oplogId)) {
                    this.deleteFileOnRecovery(file);
                    try {
                        String krfFileName = Oplog.getKRFFilenameFromCRFFilename(file.getAbsolutePath());
                        File krfFile = new File(krfFileName);
                        this.deleteFileOnRecovery(krfFile);
                    }
                    catch (Exception krfFileName) {}
                    continue;
                }
            } else if (Oplog.isDRFFile(file.getName()) && !this.isDrfOplogIdPresent(oplogId)) {
                this.deleteFileOnRecovery(file);
                continue;
            }
            if ((oplog = this.getChild(oplogId)) == null) {
                oplog = new Oplog(oplogId, this);
                this.addRecoveredOplog(oplog);
            }
            if (oplog.addRecoveredFile(file, entry.getValue())) {
                foundCrfs.add(oplogId);
                continue;
            }
            foundDrfs.add(oplogId);
        }
        if (needsOplogs) {
            this.verifyOplogs(foundCrfs, foundDrfs);
        }
    }

    protected boolean isDrfOplogIdPresent(long oplogId) {
        return this.parent.getDiskInitFile().isDRFOplogIdPresent(oplogId);
    }

    protected boolean isCrfOplogIdPresent(long oplogId) {
        return this.parent.getDiskInitFile().isCRFOplogIdPresent(oplogId);
    }

    protected void verifyOplogs(LongOpenHashSet foundCrfs, LongOpenHashSet foundDrfs) {
        this.parent.getDiskInitFile().verifyOplogs(foundCrfs, foundDrfs);
    }

    private void deleteFileOnRecovery(File f) {
        try {
            f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addRecoveredOplog(Oplog oplog) {
        this.basicAddToBeCompacted(oplog);
    }

    void addToBeCompacted(Oplog oplog) {
        this.basicAddToBeCompacted(oplog);
        this.parent.scheduleCompaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicAddToBeCompacted(Oplog oplog) {
        if (!oplog.isRecovering() && oplog.hasNoLiveValues()) {
            oplog.cancelKrf();
            oplog.close();
            oplog.deleteFiles(oplog.getHasDeletes());
        } else {
            int inactivePromotedCount = 0;
            this.parent.getStats().incCompactableOplogs(1);
            Long key = oplog.getOplogId();
            Map<Long, Oplog> map = this.oplogIdToOplog;
            synchronized (map) {
                if (this.inactiveOplogs.remove(key) != null) {
                    if (oplog.isRAFOpen()) {
                        this.inactiveOpenCount.decrementAndGet();
                    }
                    ++inactivePromotedCount;
                }
                this.oplogIdToOplog.put(key, oplog);
            }
            if (inactivePromotedCount > 0) {
                this.parent.getStats().incInactiveOplogs(-inactivePromotedCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverRegionsThatAreReady() {
        AtomicBoolean atomicBoolean = this.alreadyRecoveredOnce;
        synchronized (atomicBoolean) {
            Map<Long, DiskRecoveryStore> map = this.pendingRecoveryMap;
            synchronized (map) {
                this.currentRecoveryMap.clear();
                this.currentRecoveryMap.putAll(this.pendingRecoveryMap);
                this.pendingRecoveryMap.clear();
            }
            if (this.currentRecoveryMap.isEmpty() && this.alreadyRecoveredOnce.get()) {
                return;
            }
            for (DiskRecoveryStore drs : this.currentRecoveryMap.values()) {
                drs.getDiskRegionView().prepareForRecovery();
            }
            if (!this.alreadyRecoveredOnce.get()) {
                this.initOplogEntryId();
                this.updateOplogEntryId(this.parent.getDiskInitFile().getMaxRecoveredClearEntryId());
            }
            long start = this.parent.getStats().startRecovery();
            long byteCount = 0L;
            EntryLogger.setSource(this.parent.getDiskStoreID(), "recovery");
            try {
                byteCount = this.recoverOplogs(byteCount);
            }
            finally {
                HashMap<String, Integer> prSizes = null;
                HashMap<String, Integer> prBuckets = null;
                if (this.parent.isValidating()) {
                    prSizes = new HashMap<String, Integer>();
                    prBuckets = new HashMap<String, Integer>();
                }
                for (DiskRecoveryStore diskRecoveryStore : this.currentRecoveryMap.values()) {
                    for (Oplog oplog : this.getAllOplogs()) {
                        if (oplog == null) continue;
                        oplog.checkForRecoverableRegion(diskRecoveryStore.getDiskRegionView());
                    }
                    if (!this.parent.isValidating() || !(diskRecoveryStore instanceof ValidatingDiskRegion)) continue;
                    ValidatingDiskRegion vdr = (ValidatingDiskRegion)diskRecoveryStore;
                    if (logger.isTraceEnabled(LogMarker.PERSIST_RECOVERY)) {
                        vdr.dump(System.out);
                    }
                    if (vdr.isBucket()) {
                        String prName = vdr.getPrName();
                        if (prSizes.containsKey(prName)) {
                            int oldSize = (Integer)prSizes.get(prName);
                            prSizes.put(prName, oldSize += vdr.size());
                            int oldBuckets = (Integer)prBuckets.get(prName);
                            prBuckets.put(prName, ++oldBuckets);
                            continue;
                        }
                        prSizes.put(prName, vdr.size());
                        prBuckets.put(prName, 1);
                        continue;
                    }
                    this.parent.incLiveEntryCount(vdr.size());
                    System.out.println(vdr.getName() + ": entryCount=" + vdr.size());
                }
                if (this.parent.isValidating()) {
                    for (Map.Entry entry : prSizes.entrySet()) {
                        this.parent.incLiveEntryCount((Integer)entry.getValue());
                        System.out.println((String)entry.getKey() + " entryCount=" + entry.getValue() + " bucketCount=" + prBuckets.get(entry.getKey()));
                    }
                }
                this.parent.getStats().endRecovery(start, byteCount);
                this.alreadyRecoveredOnce.set(true);
                this.currentRecoveryMap.clear();
                EntryLogger.clearSource();
            }
        }
    }

    private long recoverOplogs(long byteCount) {
        DiskStoreImpl.OplogEntryIdSet deletedIds = new DiskStoreImpl.OplogEntryIdSet();
        TreeSet<Oplog> oplogSet = this.getSortedOplogs();
        HashSet<Oplog> oplogsNeedingValueRecovery = new HashSet<Oplog>();
        if (!this.alreadyRecoveredOnce.get() && this.getChild() != null && !this.getChild().hasBeenUsed()) {
            oplogSet.remove(this.getChild());
        }
        if (oplogSet.size() > 0) {
            long startOpLogRecovery = System.currentTimeMillis();
            boolean latestOplog = true;
            for (Oplog oplog : oplogSet) {
                byteCount += oplog.recoverDrf(deletedIds, this.alreadyRecoveredOnce.get(), latestOplog);
                latestOplog = false;
                if (this.alreadyRecoveredOnce.get()) continue;
                this.updateOplogEntryId(oplog.getMaxRecoveredOplogEntryId());
            }
            this.parent.incDeadRecordCount(deletedIds.size());
            latestOplog = true;
            for (Oplog oplog : oplogSet) {
                long startOpLogRead = this.parent.getStats().startOplogRead();
                long bytesRead = oplog.recoverCrf(deletedIds, this.recoverValues(), this.recoverValuesSync(), this.alreadyRecoveredOnce.get(), oplogsNeedingValueRecovery, latestOplog);
                latestOplog = false;
                if (!this.alreadyRecoveredOnce.get()) {
                    this.updateOplogEntryId(oplog.getMaxRecoveredOplogEntryId());
                }
                byteCount += bytesRead;
                this.parent.getStats().endOplogRead(startOpLogRead, bytesRead);
                for (DiskRecoveryStore drs : this.currentRecoveryMap.values()) {
                    drs.getDiskRegionView().oplogRecovered(oplog.oplogId);
                }
            }
            long endOpLogRecovery = System.currentTimeMillis();
            long elapsed = endOpLogRecovery - startOpLogRecovery;
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_OPLOG_LOAD_TIME, elapsed));
        }
        if (!this.parent.isOfflineCompacting()) {
            long startRegionInit = System.currentTimeMillis();
            for (DiskRecoveryStore drs : this.currentRecoveryMap.values()) {
                drs.getDiskRegionView().initRecoveredEntryCount();
            }
            if (!this.alreadyRecoveredOnce.get()) {
                for (Oplog oplog : oplogSet) {
                    if (oplog == this.getChild()) continue;
                    oplog.initAfterRecovery(this.parent.isOffline());
                }
                if (this.getChild() == null) {
                    this.setFirstChild(this.getSortedOplogs(), false);
                }
            }
            if (!this.parent.isOffline()) {
                if (this.recoverValues() && !this.recoverValuesSync()) {
                    this.parent.scheduleValueRecovery(oplogsNeedingValueRecovery, this.currentRecoveryMap);
                }
                if (!this.alreadyRecoveredOnce.get()) {
                    for (Oplog oplog : oplogSet) {
                        if (!oplog.needsKrf()) continue;
                        oplog.createKrfAsync();
                    }
                    this.parent.scheduleCompaction();
                }
                long endRegionInit = System.currentTimeMillis();
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_REGION_INIT_TIME, endRegionInit - startRegionInit));
            }
        }
        return byteCount;
    }

    protected boolean recoverValuesSync() {
        return this.parent.RECOVER_VALUES_SYNC;
    }

    protected boolean recoverValues() {
        return this.parent.RECOVER_VALUES;
    }

    private void setFirstChild(TreeSet<Oplog> oplogSet, boolean force) {
        if (this.parent.isOffline() && !this.parent.isOfflineCompacting() && !this.parent.isOfflineModify()) {
            return;
        }
        if (!oplogSet.isEmpty()) {
            Oplog first = oplogSet.first();
            DirectoryHolder dh = first.getDirectoryHolder();
            this.dirCounter = dh.getArrayIndex();
            ++this.dirCounter;
            this.dirCounter %= this.parent.dirLength;
        }
        if (force || this.maxRecoveredOplogId > 0L) {
            this.setChild(new Oplog(this.maxRecoveredOplogId + 1L, this, this.getNextDir()));
        }
    }

    private void initOplogEntryId() {
        this.oplogEntryId.set(0L);
    }

    private void updateOplogEntryId(long v) {
        long curVal;
        do {
            if ((curVal = this.oplogEntryId.get()) < v) continue;
            return;
        } while (!this.oplogEntryId.compareAndSet(curVal, v));
    }

    long getOplogEntryId() {
        this.parent.initializeIfNeeded();
        return this.oplogEntryId.get();
    }

    long newOplogEntryId() {
        long result = this.oplogEntryId.incrementAndGet();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryHolder getNextDir(int minAvailableSpace, boolean checkForWarning) {
        DirectoryHolder dirHolder = null;
        DirectoryHolder selectedHolder = null;
        DirectoryHolder[] directoryHolderArray = this.parent.directories;
        synchronized (this.parent.directories) {
            for (int i = 0; i < this.parent.dirLength; ++i) {
                dirHolder = this.parent.directories[this.dirCounter];
                ++this.dirCounter;
                this.dirCounter %= this.parent.dirLength;
                if (dirHolder.getAvailableSpace() < (long)minAvailableSpace) continue;
                if (checkForWarning && !this.parent.isDirectoryUsageNormal(dirHolder)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Ignoring directory {} due to insufficient disk space", (Object)dirHolder);
                    continue;
                }
                selectedHolder = dirHolder;
                break;
            }
            if (selectedHolder == null) {
                if (checkForWarning) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return this.getNextDir(minAvailableSpace, false);
                }
                if (this.parent.isCompactionEnabled()) {
                    selectedHolder = this.parent.directories[this.dirCounter];
                    ++this.dirCounter;
                    this.dirCounter %= this.parent.dirLength;
                    if (selectedHolder.getAvailableSpace() < (long)minAvailableSpace) {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_COMPLEXDISKREGIONGETNEXTDIR_MAX_DIRECTORY_SIZE_WILL_GET_VIOLATED__GOING_AHEAD_WITH_THE_SWITCHING_OF_OPLOG_ANY_WAYS_CURRENTLY_AVAILABLE_SPACE_IN_THE_DIRECTORY_IS__0__THE_CAPACITY_OF_DIRECTORY_IS___1, new Object[]{selectedHolder.getUsedSpace(), selectedHolder.getCapacity()}));
                    }
                } else {
                    throw new DiskAccessException(LocalizedStrings.DiskRegion_DISK_IS_FULL_COMPACTION_IS_DISABLED_NO_SPACE_CAN_BE_CREATED.toLocalizedString(), this.parent);
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return selectedHolder;
        }
    }

    DirectoryHolder getNextDir() {
        return this.getNextDir(1024, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDrf(Oplog oplog) {
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            this.drfOnlyOplogs.put(oplog.getOplogId(), oplog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDrf(Oplog oplog) {
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            this.drfOnlyOplogs.remove(oplog.getOplogId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOldestExistingOplog(long id) {
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            for (long otherId : this.oplogIdToOplog.keySet()) {
                if (id <= otherId) continue;
                return false;
            }
            for (long otherId : this.inactiveOplogs.keySet()) {
                if (id <= otherId) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyOldestReadyToCompact() {
        Object object;
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            if (this.drfOnlyOplogs.isEmpty()) {
                return;
            }
        }
        Oplog oldestLiveOplog = this.getOldestLiveOplog();
        ArrayList<Oplog> toDestroy = new ArrayList<Oplog>();
        if (oldestLiveOplog == null) {
            object = this.oplogIdToOplog;
            synchronized (object) {
                toDestroy.addAll(this.drfOnlyOplogs.values());
            }
        }
        object = this.oplogIdToOplog;
        synchronized (object) {
            for (Oplog oplog : this.drfOnlyOplogs.values()) {
                if (oplog.getOplogId() >= oldestLiveOplog.getOplogId()) continue;
                toDestroy.add(oplog);
            }
        }
        for (Oplog oplog : toDestroy) {
            oplog.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Oplog getOldestReadyToCompact() {
        Oplog oldest = null;
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            for (Oplog oldestCompactable : this.oplogIdToOplog.values()) {
                if (oldest != null && oldestCompactable.getOplogId() >= oldest.getOplogId()) continue;
                oldest = oldestCompactable;
            }
            for (Oplog oldestDrfOnly : this.drfOnlyOplogs.values()) {
                if (oldest != null && oldestDrfOnly.getOplogId() >= oldest.getOplogId()) continue;
                oldest = oldestDrfOnly;
            }
        }
        return oldest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Oplog getOldestLiveOplog() {
        Oplog result = null;
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            for (Oplog n : this.oplogIdToOplog.values()) {
                if (result != null && n.getOplogId() >= result.getOplogId()) continue;
                result = n;
            }
            for (Oplog n : this.inactiveOplogs.values()) {
                if (result != null && n.getOplogId() >= result.getOplogId()) continue;
                result = n;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inactiveAccessed(Oplog oplog) {
        Long key = oplog.getOplogId();
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            this.inactiveOplogs.get(key);
        }
    }

    void inactiveReopened(Oplog oplog) {
        this.addInactive(oplog, true);
    }

    void addInactive(Oplog oplog) {
        this.addInactive(oplog, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInactive(Oplog oplog, boolean reopen) {
        Long key = oplog.getOplogId();
        ArrayList<Oplog> openlist = null;
        Object object = this.oplogIdToOplog;
        synchronized (object) {
            boolean isInactive = true;
            if (reopen) {
                isInactive = this.inactiveOplogs.get(key) != null;
            } else {
                this.inactiveOplogs.put(key, oplog);
            }
            if ((reopen && isInactive || oplog.isRAFOpen()) && this.inactiveOpenCount.incrementAndGet() > DiskStoreImpl.MAX_OPEN_INACTIVE_OPLOGS) {
                openlist = new ArrayList<Oplog>();
                for (Oplog o : this.inactiveOplogs.values()) {
                    if (!o.isRAFOpen()) continue;
                    openlist.add(o);
                }
            }
        }
        if (openlist != null) {
            Oplog o;
            object = openlist.iterator();
            while (object.hasNext() && (!(o = (Oplog)object.next()).closeRAF() || this.inactiveOpenCount.decrementAndGet() > DiskStoreImpl.MAX_OPEN_INACTIVE_OPLOGS)) {
            }
        }
        if (!reopen) {
            this.parent.getStats().incInactiveOplogs(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(DiskRegion dr, RegionVersionVector rvv) {
        ArrayList<Oplog> oplogsToClear = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            for (Oplog oplog : this.oplogIdToOplog.values()) {
                oplogsToClear.add(oplog);
            }
            for (Oplog oplog : this.inactiveOplogs.values()) {
                oplogsToClear.add(oplog);
            }
            Oplog child = this.getChild();
            if (child != null) {
                oplogsToClear.add(child);
            }
        }
        for (Oplog oplog : oplogsToClear) {
            oplog.clear(dr, rvv);
        }
        if (rvv != null) {
            this.parent.getDiskInitFile().clearRegion(dr, rvv);
        } else {
            long clearedOplogEntryId = this.getOplogEntryId();
            this.parent.getDiskInitFile().clearRegion((DiskRegionView)dr, clearedOplogEntryId);
        }
    }

    public RuntimeException close() {
        RuntimeException rte;
        block9: {
            block7: {
                rte = null;
                try {
                    this.closeOtherOplogs();
                }
                catch (RuntimeException e) {
                    if (rte == null) break block7;
                    rte = e;
                }
            }
            if (this.child != null) {
                block8: {
                    try {
                        this.child.finishKrf();
                    }
                    catch (RuntimeException e) {
                        if (rte == null) break block8;
                        rte = e;
                    }
                }
                try {
                    this.child.close();
                }
                catch (RuntimeException e) {
                    if (rte == null) break block9;
                    rte = e;
                }
            }
        }
        return rte;
    }

    private void closeOtherOplogs() {
        Oplog[] oplogs = this.getAllOplogs();
        for (int i = 1; i < oplogs.length; ++i) {
            oplogs[i].finishKrf();
            oplogs[i].close();
            this.removeOplog(oplogs[i].getOplogId());
        }
    }

    Oplog removeOplog(long id) {
        return this.removeOplog(id, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Oplog removeOplog(long id, boolean deleting, Oplog olgToAddToDrfOnly) {
        Oplog oplog = null;
        boolean drfOnly = false;
        boolean inactive = false;
        Long key = id;
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            oplog = this.oplogIdToOplog.remove(key);
            if (oplog == null) {
                oplog = this.inactiveOplogs.remove(key);
                if (oplog != null) {
                    if (oplog.isRAFOpen()) {
                        this.inactiveOpenCount.decrementAndGet();
                    }
                    inactive = true;
                } else {
                    oplog = this.drfOnlyOplogs.remove(key);
                    if (oplog != null) {
                        drfOnly = true;
                    }
                }
            }
            if (olgToAddToDrfOnly != null) {
                this.addDrf(olgToAddToDrfOnly);
            }
        }
        if (oplog != null) {
            if (!drfOnly) {
                if (inactive) {
                    this.parent.getStats().incInactiveOplogs(-1);
                } else {
                    this.parent.getStats().incCompactableOplogs(-1);
                }
            }
            if (!deleting && !oplog.isOplogEmpty()) {
                this.parent.undeletedOplogSize.addAndGet(oplog.getOplogSize());
            }
        }
        return oplog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicClose(DiskRegion dr) {
        ArrayList<Oplog> oplogsToClose = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            oplogsToClose.addAll(this.oplogIdToOplog.values());
            oplogsToClose.addAll(this.inactiveOplogs.values());
            oplogsToClose.addAll(this.drfOnlyOplogs.values());
            Oplog child = this.getChild();
            if (child != null) {
                oplogsToClose.add(child);
            }
        }
        for (Oplog oplog : oplogsToClose) {
            oplog.close(dr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForClose() {
        ArrayList<Oplog> oplogsToPrepare = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            oplogsToPrepare.addAll(this.oplogIdToOplog.values());
            oplogsToPrepare.addAll(this.inactiveOplogs.values());
        }
        boolean childPreparedForClose = false;
        long child_oplogid = this.getChild() == null ? -1L : this.getChild().oplogId;
        for (Oplog oplog : oplogsToPrepare) {
            oplog.prepareForClose();
            if (child_oplogid == -1L || oplog.oplogId != child_oplogid) continue;
            childPreparedForClose = true;
        }
        if (!childPreparedForClose && this.getChild() != null) {
            this.getChild().prepareForClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicDestroy(DiskRegion dr) {
        ArrayList<Oplog> oplogsToDestroy = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            for (Oplog oplog : this.oplogIdToOplog.values()) {
                oplogsToDestroy.add(oplog);
            }
            for (Oplog oplog : this.inactiveOplogs.values()) {
                oplogsToDestroy.add(oplog);
            }
            for (Oplog oplog : this.drfOnlyOplogs.values()) {
                oplogsToDestroy.add(oplog);
            }
            Oplog child = this.getChild();
            if (child != null) {
                oplogsToDestroy.add(child);
            }
        }
        for (Oplog oplog : oplogsToDestroy) {
            oplog.destroy(dr);
        }
    }

    public void destroyAllOplogs() {
        for (Oplog oplog : this.getAllOplogs()) {
            if (oplog == null) continue;
            oplog.destroy();
            this.removeOplog(oplog.getOplogId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCompactableOplogs(List<CompactableOplog> l, int max) {
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            Iterator<Oplog> itr = this.oplogIdToOplog.values().iterator();
            while (itr.hasNext() && l.size() < max) {
                Oplog oplog = itr.next();
                if (!oplog.needsCompaction()) continue;
                l.add(oplog);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleForRecovery(DiskRecoveryStore drs) {
        DiskRegionView dr = drs.getDiskRegionView();
        if (dr.isRecreated() && (dr.getMyPersistentID() != null || dr.getMyInitializingID() != null)) {
            DiskRecoveryStore p_drs = drs;
            Map<Long, DiskRecoveryStore> map = this.pendingRecoveryMap;
            synchronized (map) {
                this.pendingRecoveryMap.put(dr.getId(), p_drs);
            }
        }
    }

    public DiskRecoveryStore getCurrentlyRecovering(long drId) {
        return this.currentRecoveryMap.get(drId);
    }

    public void initChild() {
        if (this.getChild() == null) {
            this.setFirstChild(this.getSortedOplogs(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offlineCompact() {
        if (this.getChild() != null) {
            this.getChild().krfClose();
            if (this.getChild().isOplogEmpty()) {
                this.getChild().destroy();
            }
        }
        ArrayList<Oplog> toDestroy = new ArrayList<Oplog>();
        Map<Long, Oplog> map = this.oplogIdToOplog;
        synchronized (map) {
            for (Oplog n : this.oplogIdToOplog.values()) {
                if (!n.isDrfOnly()) continue;
                toDestroy.add(n);
            }
        }
        for (Oplog oplog : toDestroy) {
            oplog.destroy();
        }
        this.destroyOldestReadyToCompact();
    }

    public DiskStoreImpl getParent() {
        return this.parent;
    }

    public void updateDiskRegion(AbstractDiskRegion dr) {
        for (Oplog oplog : this.getAllOplogs()) {
            if (oplog == null) continue;
            oplog.updateDiskRegion(dr);
        }
    }

    public void flushChild() {
        Oplog oplog = this.getChild();
        if (oplog != null) {
            oplog.flushAll();
        }
    }

    public String getPrefix() {
        return OplogType.BACKUP.getPrefix();
    }

    public void crfCreate(long oplogId) {
        this.getParent().getDiskInitFile().crfCreate(oplogId);
    }

    public void drfCreate(long oplogId) {
        this.getParent().getDiskInitFile().drfCreate(oplogId);
    }

    public void crfDelete(long oplogId) {
        this.getParent().getDiskInitFile().crfDelete(oplogId);
    }

    public void drfDelete(long oplogId) {
        this.getParent().getDiskInitFile().drfDelete(oplogId);
    }

    public boolean couldHaveKrf() {
        return this.getParent().couldHaveKrf();
    }

    public boolean isCompactionPossible() {
        return this.getParent().isCompactionPossible();
    }
}

