/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.internal.cache.DiskDirectoryStats;

public class DirectoryHolder {
    private final File dir;
    private final long capacity;
    private final AtomicLong totalOplogSize = new AtomicLong();
    private int index;
    private final DiskDirectoryStats dirStats;
    static boolean SET_DIRECTORY_SIZE_IN_BYTES_FOR_TESTING_PURPOSES = false;

    DirectoryHolder(StatisticsFactory factory, File dir, long space, int index) {
        this(dir.getPath(), factory, dir, space, index);
    }

    DirectoryHolder(String ownersName, StatisticsFactory factory, File dir, long space, int index) {
        this.dir = dir;
        this.capacity = SET_DIRECTORY_SIZE_IN_BYTES_FOR_TESTING_PURPOSES ? space : space * 1024L * 1024L;
        this.index = index;
        this.dirStats = new DiskDirectoryStats(factory, ownersName);
        this.dirStats.setMaxSpace(this.capacity);
    }

    public long getUsedSpace() {
        return this.totalOplogSize.get();
    }

    public long getAvailableSpace() {
        return this.getCapacity() - this.getUsedSpace();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("dir=").append(this.getDir()).append(" maxSpace=").append(this.getCapacity()).append(" usedSpace=").append(this.getUsedSpace()).append(" availableSpace=").append(this.getAvailableSpace());
        return sb.toString();
    }

    public void incrementTotalOplogSize(long incrementSize) {
        this.totalOplogSize.addAndGet(incrementSize);
        this.dirStats.incDiskSpace(incrementSize);
    }

    public void decrementTotalOplogSize(long decrementSize) {
        this.totalOplogSize.addAndGet(-decrementSize);
        this.dirStats.incDiskSpace(-decrementSize);
    }

    public File getDir() {
        return this.dir;
    }

    public int getArrayIndex() {
        return this.index;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void close() {
        this.dirStats.close();
    }

    public long getDirStatsDiskSpaceUsage() {
        return this.dirStats.getDiskSpace();
    }

    public DiskDirectoryStats getDiskDirectoryStats() {
        return this.dirStats;
    }
}

