/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.Operation;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEventImpl;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.RegionAdvisor;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class DestroyPartitionedRegionMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private Object cbArg;
    private Operation op;
    private int prSerial;
    private int[] bucketSerials;

    public DestroyPartitionedRegionMessage() {
    }

    private DestroyPartitionedRegionMessage(Set recipients, PartitionedRegion region, ReplyProcessor21 processor, RegionEventImpl event, int[] serials) {
        super(recipients, region.getPRId(), processor);
        this.cbArg = event.getRawCallbackArgument();
        this.op = event.getOperation();
        this.prSerial = region.getSerialNumber();
        Assert.assertTrue(this.prSerial != -1);
        this.bucketSerials = serials;
    }

    public static DestroyPartitionedRegionResponse send(Set recipients, PartitionedRegion r, RegionEventImpl event, int[] serials) {
        Assert.assertTrue(recipients != null, "DestroyMessage NULL recipients set");
        DestroyPartitionedRegionResponse resp = new DestroyPartitionedRegionResponse(r.getSystem(), recipients);
        DestroyPartitionedRegionMessage m = new DestroyPartitionedRegionMessage(recipients, r, resp, event, serials);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        r.getDistributionManager().putOutgoing(m);
        return resp;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws CacheException {
        if (this.op.isLocal()) {
            RegionAdvisor.PartitionProfile pp = r.getRegionAdvisor().getPartitionProfile(this.getSender());
            if (pp == null) {
                return true;
            }
            Assert.assertTrue(this.prSerial != -1);
            boolean ok = true;
            int oldSerial = pp.getSerialNumber();
            if (DistributionAdvisor.isNewerSerialNumber(oldSerial, this.prSerial)) {
                ok = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("Not removing region {}l serial requested = {}; actual is {}", (Object)r.getName(), (Object)this.prSerial, (Object)r.getSerialNumber());
                }
            }
            if (ok) {
                RegionAdvisor ra = r.getRegionAdvisor();
                ra.removeIdAndBuckets(this.sender, this.prSerial, this.bucketSerials, !this.op.isClose());
            }
            this.sendReply(this.getSender(), this.getProcessorId(), dm, null, r, startTime);
            return false;
        }
        if (r.isDestroyed()) {
            boolean isClose = this.op.isClose();
            r.destroyPartitionedRegionLocally(!isClose);
            return true;
        }
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "{} operateOnRegion: {}", (Object)this.getClass().getName(), (Object)r.getFullPath());
        }
        RegionEventImpl event = new RegionEventImpl(r, this.op, this.cbArg, true, r.getMyId());
        r.basicDestroyRegion(event, false, false, true);
        return true;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; cbArg=").append(this.cbArg).append("; op=").append(this.op);
        buff.append("; prSerial=" + this.prSerial);
        buff.append("; bucketSerials (" + this.bucketSerials.length + ")=(");
        for (int i = 0; i < this.bucketSerials.length; ++i) {
            buff.append(Integer.toString(this.bucketSerials[i]));
            if (i >= this.bucketSerials.length - 1) continue;
            buff.append(", ");
        }
    }

    @Override
    public int getDSFID() {
        return -88;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.cbArg = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        this.prSerial = in.readInt();
        int len = in.readInt();
        this.bucketSerials = new int[len];
        for (int i = 0; i < len; ++i) {
            this.bucketSerials[i] = in.readInt();
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.cbArg, out);
        out.writeByte(this.op.ordinal);
        out.writeInt(this.prSerial);
        out.writeInt(this.bucketSerials.length);
        for (int i = 0; i < this.bucketSerials.length; ++i) {
            out.writeInt(this.bucketSerials[i]);
        }
    }

    public static class DestroyPartitionedRegionResponse
    extends ReplyProcessor21 {
        public DestroyPartitionedRegionResponse(InternalDistributedSystem system, Set initMembers) {
            super(system, (Collection)initMembers);
        }

        @Override
        protected void processException(ReplyException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("DestroyRegionResponse ignoring exception", (Throwable)ex);
            }
        }
    }
}

