/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoteCacheInfo;
import org.apache.geode.internal.cache.InternalCache;

public class CacheInfoResponse
extends AdminResponse {
    private RemoteCacheInfo info;

    public static CacheInfoResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        CacheInfoResponse m = new CacheInfoResponse();
        m.setRecipient(recipient);
        try {
            InternalCache c = (InternalCache)CacheFactory.getInstanceCloseOk(dm.getSystem());
            m.info = new RemoteCacheInfo(c);
        }
        catch (CancelException ignore) {
            m.info = null;
        }
        return m;
    }

    RemoteCacheInfo getCacheInfo() {
        return this.info;
    }

    @Override
    public int getDSFID() {
        return 1015;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.info, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.info = (RemoteCacheInfo)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "CacheInfoResponse from " + this.getSender() + " info=" + this.info;
    }
}

