/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.ObjToByteArraySerializer;

public class NullDataOutputStream
extends OutputStream
implements ObjToByteArraySerializer {
    private int size = 0;

    @Override
    public void write(int b) {
        ++this.size;
    }

    @Override
    public void write(byte[] source, int offset, int len) {
        this.size += len;
    }

    public int size() {
        return this.size;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.size += 2;
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.size += 2;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.size += 4;
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.size += 8;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.size += 4;
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.size += 8;
    }

    @Override
    public void writeBytes(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 0) {
            this.size += strlen;
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        if (len > 0) {
            this.size += len * 2;
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int strlen = str.length();
        if (strlen > 65535) {
            throw new UTFDataFormatException();
        }
        int utfSize = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfSize;
                continue;
            }
            if (c > '\u07ff') {
                utfSize += 3;
                continue;
            }
            utfSize += 2;
        }
        if (utfSize > 65535) {
            throw new UTFDataFormatException();
        }
        this.size += utfSize + 2;
    }

    @Override
    public void writeAsSerializedByteArray(Object v) throws IOException {
        if (v instanceof HeapDataOutputStream) {
            this.size += 4;
            this.size += ((HeapDataOutputStream)v).size();
        } else {
            this.size += 5;
            DataSerializer.writeObject(v, this);
        }
    }
}

