/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.OSProcess;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.ArgumentRedactor;

public class Banner {
    private Banner() {
    }

    private static void prettyPrintPath(String path, PrintWriter out) {
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                out.println("  " + st.nextToken());
            }
        }
    }

    static void print(PrintWriter out, String[] args) {
        TreeMap<Object, Object> sp = new TreeMap<Object, Object>((Properties)System.getProperties().clone());
        Object userName = sp.get("user.name");
        Object userDir = sp.get("user.dir");
        Object userHome = sp.get("user.home");
        Object javaClassPath = sp.get("java.class.path");
        Object javaLibraryPath = sp.get("java.library.path");
        sp.remove("user.name");
        sp.remove("user.dir");
        sp.remove("user.home");
        sp.remove("java.class.path");
        sp.remove("java.library.path");
        sp.remove("os.name");
        sp.remove("os.arch");
        String SEPARATOR = "---------------------------------------------------------------------------";
        int processId = Banner.attemptToReadProcessId();
        short currentOrdinal = Version.CURRENT_ORDINAL;
        ArrayList<String> commandLineArguments = new ArrayList<String>();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeBean != null) {
            commandLineArguments.addAll(runtimeBean.getInputArguments());
        }
        if (args != null && args.length != 0) {
            Collections.addAll(commandLineArguments, args);
        }
        out.println();
        out.println("---------------------------------------------------------------------------");
        Banner.printASFLicense(out);
        out.println("---------------------------------------------------------------------------");
        GemFireVersion.print(out);
        out.println("Communications version: " + currentOrdinal);
        out.println("Process ID: " + processId);
        out.println("User: " + userName);
        out.println("Current dir: " + userDir);
        out.println("Home dir: " + userHome);
        if (!commandLineArguments.isEmpty()) {
            out.println("Command Line Parameters:");
            for (String string : commandLineArguments) {
                out.println("  " + ArgumentRedactor.redact(string));
            }
        }
        out.println("Class Path:");
        Banner.prettyPrintPath((String)javaClassPath, out);
        out.println("Library Path:");
        Banner.prettyPrintPath((String)javaLibraryPath, out);
        if (Boolean.getBoolean("gemfire.disableSystemPropertyLogging")) {
            out.println("System property logging disabled.");
        } else {
            out.println("System Properties:");
            for (Object object : sp.entrySet()) {
                Map.Entry me = (Map.Entry)object;
                String key = me.getKey().toString();
                String value = ArgumentRedactor.redactValueIfNecessary(key, String.valueOf(me.getValue()));
                out.println("    " + key + " = " + value);
            }
            out.println("Log4J 2 Configuration:");
            out.println("    " + LogService.getConfigInformation());
        }
        out.println("---------------------------------------------------------------------------");
    }

    private static int attemptToReadProcessId() {
        int processId = -1;
        try {
            processId = OSProcess.getId();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        return processId;
    }

    private static void printASFLicense(PrintWriter out) {
        out.println("  ");
        out.println("  Licensed to the Apache Software Foundation (ASF) under one or more");
        out.println("  contributor license agreements.  See the NOTICE file distributed with this");
        out.println("  work for additional information regarding copyright ownership.");
        out.println("   ");
        out.println("  The ASF licenses this file to You under the Apache License, Version 2.0");
        out.println("  (the \"License\"); you may not use this file except in compliance with the");
        out.println("  License.  You may obtain a copy of the License at");
        out.println("  ");
        out.println("  http://www.apache.org/licenses/LICENSE-2.0");
        out.println("  ");
        out.println("  Unless required by applicable law or agreed to in writing, software");
        out.println("  distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT");
        out.println("  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the");
        out.println("  License for the specific language governing permissions and limitations");
        out.println("  under the License.");
        out.println("  ");
    }

    public static String getString(String[] args) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Banner.print(pw, args);
        pw.close();
        return sw.toString();
    }
}

