/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Version;

public class JoinRequestMessage
extends HighPriorityDistributionMessage {
    private InternalDistributedMember memberID;
    private Object credentials;
    private int failureDetectionPort = -1;
    private int requestId;

    public JoinRequestMessage(InternalDistributedMember coord, InternalDistributedMember id, Object credentials, int fdPort, int requestId) {
        this.setRecipient(coord);
        this.memberID = id;
        this.credentials = credentials;
        this.failureDetectionPort = fdPort;
        this.requestId = requestId;
    }

    public JoinRequestMessage() {
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public int getDSFID() {
        return -142;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + (this.credentials == null ? ")" : "; with credentials)") + " failureDetectionPort:" + this.failureDetectionPort;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeObject(this.credentials, out);
        DataSerializer.writePrimitiveInt(this.failureDetectionPort, out);
        out.writeBoolean(this.getMulticast());
        out.writeInt(this.requestId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.credentials = DataSerializer.readObject(in);
        this.failureDetectionPort = DataSerializer.readPrimitiveInt(in);
        this.setMulticast(in.readBoolean());
        this.requestId = in.readInt();
    }

    public int getFailureDetectionPort() {
        return this.failureDetectionPort;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinRequestMessage other = (JoinRequestMessage)obj;
        if (this.credentials == null ? other.credentials != null : !this.credentials.equals(other.credentials)) {
            return false;
        }
        if (this.failureDetectionPort != other.failureDetectionPort) {
            return false;
        }
        if (this.memberID == null ? other.memberID != null : !this.memberID.equals(other.memberID)) {
            return false;
        }
        return this.requestId == other.requestId;
    }
}

