/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.util.HashMap;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.locks.DeposeGrantorProcessor;
import org.apache.geode.distributed.internal.locks.ElderInitProcessor;
import org.apache.geode.distributed.internal.locks.GrantorInfo;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ElderState {
    private static final Logger logger = LogService.getLogger();
    private final HashMap nameToInfo;
    private final DistributionManager dm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElderState(DistributionManager dm) {
        Assert.assertTrue(dm != null);
        this.dm = dm;
        this.nameToInfo = new HashMap();
        try {
            this.dm.getStats().incElders(1);
            ElderInitProcessor.init(this.dm, this.nameToInfo);
        }
        catch (NullPointerException e) {
            try {
                this.checkForProblem(dm);
            }
            finally {
                throw e;
            }
        }
        catch (InternalGemFireError e) {
            try {
                this.checkForProblem(dm);
            }
            finally {
                throw e;
            }
        }
        finally {
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                StringBuffer sb = new StringBuffer("ElderState initialized with:");
                for (Object key : this.nameToInfo.keySet()) {
                    sb.append("\n\t" + key + ": " + this.nameToInfo.get(key));
                }
                logger.trace(LogMarker.DLS, sb.toString());
            }
        }
    }

    private void checkForProblem(DistributionManager checkDM) {
        if (checkDM.getSystem() == null) {
            logger.warn(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.ElderState_ELDERSTATE_PROBLEM_SYSTEM_0, checkDM.getSystem()));
            return;
        }
        if (checkDM.getSystem().getDistributionManager() == null) {
            logger.warn(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.ElderState_ELDERSTATE_PROBLEM_SYSTEM_DISTRIBUTIONMANAGER_0, checkDM.getSystem().getDistributionManager()));
        }
        if (checkDM != checkDM.getSystem().getDistributionManager()) {
            logger.warn(LogMarker.DLS, (Message)LocalizedMessage.create(LocalizedStrings.ElderState_ELDERSTATE_PROBLEM_DM_0_BUT_SYSTEM_DISTRIBUTIONMANAGER_1, new Object[]{checkDM, checkDM.getSystem().getDistributionManager()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrantorInfo getGrantor(String serviceName, InternalDistributedMember requestor, int dlsSerialNumberRequestor) {
        ElderState elderState = this;
        synchronized (elderState) {
            GrantorInfo gi = (GrantorInfo)this.nameToInfo.get(serviceName);
            if (gi != null) {
                this.waitWhileInitiatingTransfer(gi);
                InternalDistributedMember currentGrantor = gi.getId();
                if (currentGrantor != null && this.dm.getDistributionManagerIds().contains(currentGrantor)) {
                    return gi;
                }
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "Elder setting grantor for {} to {} because {} ", (Object)serviceName, (Object)requestor, (Object)(currentGrantor != null ? "current grantor crashed" : "of unclean grantor shutdown"));
                }
                long myVersion = gi.getVersionId() + 1L;
                this.nameToInfo.put(serviceName, new GrantorInfo(requestor, myVersion, dlsSerialNumberRequestor, false));
                return new GrantorInfo(requestor, myVersion, dlsSerialNumberRequestor, true);
            }
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "Elder setting grantor for {} to {} because of clean grantor shutdown", (Object)serviceName, (Object)requestor);
            }
            gi = new GrantorInfo(requestor, 1L, dlsSerialNumberRequestor, false);
            this.nameToInfo.put(serviceName, gi);
            return gi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrantorInfo peekGrantor(String serviceName) {
        ElderState elderState = this;
        synchronized (elderState) {
            GrantorInfo gi = (GrantorInfo)this.nameToInfo.get(serviceName);
            if (gi != null) {
                this.waitWhileInitiatingTransfer(gi);
                InternalDistributedMember currentGrantor = gi.getId();
                if (currentGrantor != null && this.dm.getDistributionManagerIds().contains(currentGrantor)) {
                    return gi;
                }
                return new GrantorInfo(null, 0L, 0, true);
            }
            return new GrantorInfo(null, 0L, 0, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public GrantorInfo becomeGrantor(String serviceName, InternalDistributedMember newGrantor, int newGrantorSerialNumber, InternalDistributedMember oldTurk) {
        GrantorInfo gi;
        long newGrantorVersion;
        InternalDistributedMember previousGrantor;
        GrantorInfo newInfo;
        block22: {
            block23: {
                GrantorInfo myVersion2;
                newInfo = null;
                previousGrantor = null;
                newGrantorVersion = -1L;
                try {
                    ElderState elderState = this;
                    // MONITORENTER : elderState
                    gi = (GrantorInfo)this.nameToInfo.get(serviceName);
                    while (gi != null && gi.isInitiatingTransfer()) {
                        this.waitWhileInitiatingTransfer(gi);
                        gi = (GrantorInfo)this.nameToInfo.get(serviceName);
                    }
                    if (gi == null) break block22;
                    previousGrantor = gi.getId();
                    if (previousGrantor == null || !this.dm.getDistributionManagerIds().contains(previousGrantor)) break block23;
                    if (!newGrantor.equals(previousGrantor)) {
                        if (oldTurk != null && !oldTurk.equals(previousGrantor)) {
                            if (logger.isTraceEnabled(LogMarker.DLS)) {
                                logger.trace(LogMarker.DLS, "Elder did not become grantor for {} to {} because oldT was {} and the current grantor is {}", (Object)serviceName, (Object)newGrantor, (Object)oldTurk, (Object)previousGrantor);
                            }
                        } else {
                            long myVersion2;
                            if (logger.isTraceEnabled(LogMarker.DLS)) {
                                logger.trace(LogMarker.DLS, "Elder forced to set grantor for {} to {}", (Object)serviceName, (Object)newGrantor);
                            }
                            newGrantorVersion = myVersion2 = gi.getVersionId() + 1L;
                            newInfo = new GrantorInfo(newGrantor, myVersion2, newGrantorSerialNumber, false);
                            this.nameToInfo.put(serviceName, newInfo);
                            if (gi.getId() != null && (oldTurk == null || gi.getId().equals(oldTurk)) && !gi.getId().equals(newGrantor)) {
                                this.beginInitiatingTransfer(newInfo);
                            }
                        }
                    }
                    myVersion2 = new GrantorInfo(gi.getId(), gi.getVersionId(), gi.getSerialNumber(), true);
                    // MONITOREXIT : elderState
                    if (!this.isInitiatingTransfer(newInfo)) return myVersion2;
                    Assert.assertTrue(newGrantorVersion > -1L);
                }
                catch (Throwable throwable) {
                    if (!this.isInitiatingTransfer(newInfo)) throw throwable;
                    Assert.assertTrue(newGrantorVersion > -1L);
                    DeposeGrantorProcessor.send(serviceName, previousGrantor, newGrantor, newGrantorVersion, newGrantorSerialNumber, this.dm);
                    this.finishInitiatingTransfer(newInfo);
                    throw throwable;
                }
                DeposeGrantorProcessor.send(serviceName, previousGrantor, newGrantor, newGrantorVersion, newGrantorSerialNumber, this.dm);
                this.finishInitiatingTransfer(newInfo);
                return myVersion2;
            }
            long myVersion = gi.getVersionId() + 1L;
            if (oldTurk != null) {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "Elder did not become grantor for {} to {} because oldT was {} and the current grantor {} had crashed", (Object)serviceName, (Object)newGrantor, (Object)oldTurk, (Object)previousGrantor);
                }
            } else {
                if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "Elder forced to set grantor for {} to {} and noticed previous grantor had crashed", (Object)serviceName, (Object)newGrantor);
                }
                this.nameToInfo.put(serviceName, new GrantorInfo(newGrantor, myVersion, newGrantorSerialNumber, false));
            }
            GrantorInfo grantorInfo = new GrantorInfo(null, myVersion - 1L, gi.getSerialNumber(), true);
            // MONITOREXIT : elderState
            if (!this.isInitiatingTransfer(newInfo)) return grantorInfo;
            Assert.assertTrue(newGrantorVersion > -1L);
            DeposeGrantorProcessor.send(serviceName, previousGrantor, newGrantor, newGrantorVersion, newGrantorSerialNumber, this.dm);
            this.finishInitiatingTransfer(newInfo);
            return grantorInfo;
        }
        if (oldTurk != null) {
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "Elder did not become grantor for {} to {} because oldT was {} and elder had no current grantor", (Object)serviceName, (Object)newGrantor, (Object)oldTurk);
            }
        } else {
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "Elder forced to set grantor for {} to {} because of clean grantor shutdown", (Object)serviceName, (Object)newGrantor);
            }
            gi = new GrantorInfo(newGrantor, 1L, newGrantorSerialNumber, false);
            this.nameToInfo.put(serviceName, gi);
        }
        GrantorInfo grantorInfo = new GrantorInfo(null, 0L, 0, false);
        // MONITOREXIT : elderState
        if (!this.isInitiatingTransfer(newInfo)) return grantorInfo;
        Assert.assertTrue(newGrantorVersion > -1L);
        DeposeGrantorProcessor.send(serviceName, previousGrantor, newGrantor, newGrantorVersion, newGrantorSerialNumber, this.dm);
        this.finishInitiatingTransfer(newInfo);
        return grantorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGrantor(long grantorVersion, String serviceName, int dlsSerialNumber, InternalDistributedMember oldGrantor, boolean locksHeld) {
        ElderState elderState = this;
        synchronized (elderState) {
            if (grantorVersion == -1L) {
                return;
            }
            GrantorInfo currentGI = (GrantorInfo)this.nameToInfo.get(serviceName);
            if (currentGI == null) {
                return;
            }
            if (currentGI.getVersionId() != grantorVersion || currentGI.getSerialNumber() != dlsSerialNumber) {
                return;
            }
            GrantorInfo gi = locksHeld ? this.nameToInfo.put(serviceName, new GrantorInfo(null, currentGI.getVersionId(), 0, true)) : (GrantorInfo)this.nameToInfo.remove(serviceName);
            if (gi != null) {
                InternalDistributedMember currentGrantor = gi.getId();
                if (!oldGrantor.equals(currentGrantor)) {
                    this.nameToInfo.put(serviceName, gi);
                    if (logger.isTraceEnabled(LogMarker.DLS)) {
                        logger.trace(LogMarker.DLS, "Elder not making {} grantor shutdown for {} by {} because the current grantor is {}", (Object)(locksHeld ? "unclean" : "clean"), (Object)serviceName, (Object)oldGrantor, (Object)currentGrantor);
                    }
                } else if (logger.isTraceEnabled(LogMarker.DLS)) {
                    logger.trace(LogMarker.DLS, "Elder making {} grantor shutdown for {} by {}", (Object)(locksHeld ? "unclean" : "clean"), (Object)serviceName, (Object)oldGrantor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitiatingTransfer(GrantorInfo gi) {
        if (gi == null) {
            return false;
        }
        ElderState elderState = this;
        synchronized (elderState) {
            return gi.isInitiatingTransfer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginInitiatingTransfer(GrantorInfo gi) {
        ElderState elderState = this;
        synchronized (elderState) {
            gi.setInitiatingTransfer(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInitiatingTransfer(GrantorInfo gi) {
        ElderState elderState = this;
        synchronized (elderState) {
            gi.setInitiatingTransfer(false);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileInitiatingTransfer(GrantorInfo gi) {
        ElderState elderState = this;
        synchronized (elderState) {
            boolean interrupted = false;
            try {
                while (gi.isInitiatingTransfer()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        this.dm.getCancelCriterion().checkCancelInProgress(e);
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceGrantorRecovery(String serviceName) {
        ElderState elderState = this;
        synchronized (elderState) {
            GrantorInfo gi = (GrantorInfo)this.nameToInfo.get(serviceName);
            if (gi.isInitiatingTransfer()) {
                throw new IllegalStateException(LocalizedStrings.ElderState_CANNOT_FORCE_GRANTOR_RECOVERY_FOR_GRANTOR_THAT_IS_TRANSFERRING.toLocalizedString());
            }
            this.nameToInfo.put(serviceName, new GrantorInfo(gi.getId(), gi.getVersionId(), gi.getSerialNumber(), true));
        }
    }
}

