/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.query.CqAttributes;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.CqExistsException;
import org.apache.geode.cache.query.CqQuery;
import org.apache.geode.cache.query.CqServiceStatistics;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.MultiIndexCreationException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.ClientCQ;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class ProxyQueryService
implements QueryService {
    private static final Logger logger = LogService.getLogger();
    ProxyCache proxyCache;
    QueryService realQueryService;
    List<String> cqNames = new ArrayList<String>();

    public ProxyQueryService(ProxyCache proxyCache, QueryService realQueryService) {
        this.proxyCache = proxyCache;
        this.realQueryService = realQueryService;
    }

    @Override
    public void closeCqs() {
        this.closeCqs(false);
    }

    public void closeCqs(boolean keepAlive) {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().closeAllCqs(!keepAlive, Arrays.asList(this.getCqs()), keepAlive);
                this.cqNames.clear();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to closeAll Cqs. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createKeyIndex(String indexName, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineKeyIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public List<Index> createDefinedIndexes() throws MultiIndexCreationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public boolean clearDefinedIndexes() {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void executeCqs() throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().executeCqs(Arrays.asList(this.getCqs()));
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute cqs. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public void executeCqs(String regionName) throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().executeCqs(Arrays.asList(this.getCqs(regionName)));
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute cqs on the specified region. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public CqQuery getCq(String cqName) {
        this.preOp();
        if (this.cqNames.contains(cqName)) {
            return this.realQueryService.getCq(cqName);
        }
        return null;
    }

    @Override
    public CqServiceStatistics getCqStatistics() {
        throw new UnsupportedOperationException();
    }

    public ClientCQ[] getCqs() {
        ClientCQ[] cqs;
        block3: {
            this.preOp();
            cqs = null;
            try {
                ArrayList<InternalCqQuery> cqList = new ArrayList<InternalCqQuery>();
                for (String name : this.cqNames) {
                    cqList.add(((DefaultQueryService)this.realQueryService).getCqService().getCq(name));
                }
                cqs = new ClientCQ[cqList.size()];
                cqList.toArray(cqs);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Unable to get Cqs. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        return cqs;
    }

    public ClientCQ[] getCqs(String regionName) throws CqException {
        this.preOp();
        Collection<? extends InternalCqQuery> cqs = null;
        try {
            ArrayList<InternalCqQuery> cqList = new ArrayList<InternalCqQuery>();
            cqs = ((DefaultQueryService)this.realQueryService).getCqService().getAllCqs(regionName);
            for (InternalCqQuery internalCqQuery : cqs) {
                if (!this.cqNames.contains(internalCqQuery.getName())) continue;
                cqList.add(internalCqQuery);
            }
            ClientCQ[] results = new ClientCQ[cqList.size()];
            cqList.toArray(results);
            return results;
        }
        catch (CqException cqe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to get Cqs. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
            throw cqe;
        }
    }

    @Override
    public Index getIndex(Region<?, ?> region, String indexName) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public Collection<Index> getIndexes() {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public Collection<Index> getIndexes(Region<?, ?> region) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public Collection<Index> getIndexes(Region<?, ?> region, IndexType indexType) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqException {
        this.preOp(true);
        ClientCQ cq = null;
        try {
            cq = ((DefaultQueryService)this.realQueryService).getCqService().newCq(null, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getPool(), false);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
        }
        catch (CqExistsException cqe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to createCq. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        finally {
            this.postOp();
        }
        return cq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqException {
        this.preOp(true);
        ClientCQ cq = null;
        try {
            cq = ((DefaultQueryService)this.realQueryService).getCqService().newCq(null, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getPool(), isDurable);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
        }
        catch (CqExistsException cqe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to createCq. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        finally {
            this.postOp();
        }
        return cq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqExistsException, CqException {
        this.preOp(true);
        try {
            if (cqName == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
            }
            ClientCQ cq = ((DefaultQueryService)this.realQueryService).getCqService().newCq(cqName, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getPool(), false);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
            ClientCQ clientCQ = cq;
            return clientCQ;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
        this.preOp(true);
        try {
            if (cqName == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
            }
            ClientCQ cq = ((DefaultQueryService)this.realQueryService).getCqService().newCq(cqName, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getPool(), isDurable);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
            ClientCQ clientCQ = cq;
            return clientCQ;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public Query newQuery(String queryString) {
        this.preOp();
        return ((DefaultQueryService)this.realQueryService).newQuery(queryString, this.proxyCache);
    }

    @Override
    public void removeIndex(Index index) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public void removeIndexes() {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public void removeIndexes(Region<?, ?> region) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public void stopCqs() throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().stopCqs(Arrays.asList(this.getCqs()));
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop all CQs. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public void stopCqs(String regionName) throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().stopCqs(Arrays.asList(this.getCqs(regionName)));
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop cqs on the specified region. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
    }

    @Override
    public List<String> getAllDurableCqsFromServer() throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getAllDurableCqsFromServer();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to get all durablec client cqs on the specified region. Error: {}", (Object)cqe.getMessage(), (Object)cqe);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private void preOp() {
        this.preOp(false);
    }

    private void preOp(boolean setTL) {
        if (this.proxyCache.isClosed()) {
            throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
        }
        if (setTL) {
            UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
        }
    }

    private void postOp() {
        UserAttributes.userAttributes.set(null);
    }
}

