/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.jmx.internal;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import mx4j.log.Log;
import mx4j.tools.adaptor.AdaptorServerSocketFactory;
import mx4j.tools.adaptor.http.HttpAdaptor;
import mx4j.tools.adaptor.http.XSLTProcessor;
import org.apache.geode.GemFireException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.LogWriter;
import org.apache.geode.SystemFailure;
import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.AdminException;
import org.apache.geode.admin.jmx.Agent;
import org.apache.geode.admin.jmx.AgentConfig;
import org.apache.geode.admin.jmx.AgentFactory;
import org.apache.geode.admin.jmx.internal.AdminDistributedSystemJmxImpl;
import org.apache.geode.admin.jmx.internal.AgentConfigImpl;
import org.apache.geode.admin.jmx.internal.ConnectionNotificationAdapter;
import org.apache.geode.admin.jmx.internal.ConnectionNotificationFilterImpl;
import org.apache.geode.admin.jmx.internal.MBeanUtil;
import org.apache.geode.admin.jmx.internal.MX4JServerSocketFactory;
import org.apache.geode.admin.jmx.internal.ManagedResource;
import org.apache.geode.admin.jmx.internal.ManagedResourceType;
import org.apache.geode.admin.jmx.internal.MemberInfoWithStatsMBean;
import org.apache.geode.admin.jmx.internal.RMIRegistryService;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Banner;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.admin.remote.TailLogResponse;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.logging.LogConfig;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LogWriterFactory;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.logging.log4j.LogWriterAppender;
import org.apache.geode.internal.logging.log4j.LogWriterAppenders;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class AgentImpl
implements Agent,
ManagedResource {
    private static final Logger logger = LogService.getLogger();
    private static final String MX4J_HTTPADAPTOR_BASIC_AUTHENTICATION = "basic";
    private static final String JMX_SERVICE_URL = "service:jmx:rmi://{0}:{1}/jndi/rmi://{2}:{3}{4}";
    private LogWriterAppender logWriterAppender;
    private InternalLogWriter logWriter;
    private HttpAdaptor httpAdaptor;
    private JMXConnectorServer rmiConnector;
    private final String mbeanName;
    private final ObjectName objectName;
    private ModelMBean modelMBean;
    private final AgentConfigImpl agentConfig;
    private AdminDistributedSystem system;
    private String propertyFile;
    private Object CONN_SYNC = new Object();
    protected MemberInfoWithStatsMBean memberInfoWithStatsMBean;
    private MBeanServer mBeanServer;
    private final Thread shutdownHook = new Thread(LoggingThreadGroup.createThreadGroup("Shutdown"), "Shutdown"){

        @Override
        public void run() {
            AgentImpl.this.disconnectFromSystem();
        }
    };

    private static void checkDebug() {
        try {
            if (Boolean.getBoolean("gfAgentDebug")) {
                Log.setDefaultPriority((int)0);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
    }

    public AgentImpl(AgentConfigImpl agentConfig) throws AdminException, IllegalArgumentException {
        this.addShutdownHook();
        if (agentConfig == null) {
            throw new IllegalArgumentException(LocalizedStrings.AgentImpl_AGENTCONFIG_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.agentConfig = agentConfig;
        this.mbeanName = "GemFire:type=" + MBeanUtil.makeCompliantMBeanNameProperty("Agent");
        try {
            this.objectName = new ObjectName(this.mbeanName);
        }
        catch (MalformedObjectNameException ex) {
            String s = LocalizedStrings.AgentImpl_WHILE_CREATING_OBJECTNAME_0.toLocalizedString(this.mbeanName);
            throw new AdminException(s, ex);
        }
        this.propertyFile = this.agentConfig.getPropertyFile().getAbsolutePath();
        this.agentConfig.setBindAddress(this.getBindAddress());
        this.initLogWriter();
        this.mBeanServer = MBeanUtil.start();
        MBeanUtil.createMBean(this);
        this.initializeHelperMbean();
    }

    private void initializeHelperMbean() {
        try {
            this.memberInfoWithStatsMBean = new MemberInfoWithStatsMBean(this);
            MBeanServer mbs = this.getMBeanServer();
            mbs.registerMBean(this.memberInfoWithStatsMBean, this.memberInfoWithStatsMBean.getObjectName());
        }
        catch (OperationsException e) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_FAILED_TO_INITIALIZE_MEMBERINFOWITHSTATSMBEAN), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_FAILED_TO_INITIALIZE_MEMBERINFOWITHSTATSMBEAN), (Throwable)e);
        }
        catch (AdminException e) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_FAILED_TO_INITIALIZE_MEMBERINFOWITHSTATSMBEAN), (Throwable)e);
        }
    }

    @Override
    public AgentConfig getConfig() {
        return this.agentConfig;
    }

    @Override
    public AdminDistributedSystem getDistributedSystem() {
        return this.system;
    }

    @Override
    public void saveProperties() {
        throw new GemFireIOException("saveProperties is no longer supported for security reasons");
    }

    @Override
    public void start() {
        AgentImpl.checkDebug();
        this.agentConfig.validate();
        if (this.mBeanServer == null) {
            this.mBeanServer = MBeanUtil.start();
        }
        try {
            this.startHttpAdaptor();
        }
        catch (StartupException e) {
            AlertAppender.getInstance().shuttingDown();
            LogWriterAppenders.stop(LogWriterAppenders.Identifier.MAIN);
            LogWriterAppenders.destroy(LogWriterAppenders.Identifier.MAIN);
            throw e;
        }
        try {
            this.startRMIConnectorServer();
        }
        catch (StartupException e) {
            this.stopHttpAdaptor();
            AlertAppender.getInstance().shuttingDown();
            LogWriterAppenders.stop(LogWriterAppenders.Identifier.MAIN);
            LogWriterAppenders.destroy(LogWriterAppenders.Identifier.MAIN);
            throw e;
        }
        try {
            this.startSnmpAdaptor();
        }
        catch (StartupException e) {
            this.stopRMIConnectorServer();
            this.stopHttpAdaptor();
            AlertAppender.getInstance().shuttingDown();
            LogWriterAppenders.stop(LogWriterAppenders.Identifier.MAIN);
            LogWriterAppenders.destroy(LogWriterAppenders.Identifier.MAIN);
            throw e;
        }
        if (this.agentConfig.getAutoConnect()) {
            try {
                this.connectToSystem();
            }
            catch (AdminException ex) {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_AUTO_CONNECT_FAILED__0, ex.getMessage()));
                this.stop();
                throw new StartupException(ex);
            }
            catch (MalformedObjectNameException ex) {
                StringId autoConnectFailed = LocalizedStrings.AgentImpl_AUTO_CONNECT_FAILED__0;
                logger.error((Message)LocalizedMessage.create(autoConnectFailed, ex.getMessage()));
                this.stop();
                throw new StartupException(new AdminException(autoConnectFailed.toLocalizedString(ex.getMessage()), ex));
            }
        }
        logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_GEMFIRE_JMX_AGENT_IS_RUNNING));
        LogWriterAppenders.startupComplete(LogWriterAppenders.Identifier.MAIN);
        if (this.memberInfoWithStatsMBean == null) {
            this.initializeHelperMbean();
        }
    }

    @Override
    public void stop() {
        try {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_STOPPING_JMX_AGENT));
            AlertAppender.getInstance().shuttingDown();
            LogWriterAppenders.stop(LogWriterAppenders.Identifier.MAIN);
            this.stopDistributedSystem();
            this.stopHttpAdaptor();
            this.stopRMIConnectorServer();
            this.memberInfoWithStatsMBean = null;
            this.stopSnmpAdaptor();
            MBeanUtil.stop();
            this.mBeanServer = null;
            this.removeShutdownHook();
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_AGENT_HAS_STOPPED));
        }
        finally {
            LogWriterAppenders.destroy(LogWriterAppenders.Identifier.MAIN);
            LoggingThreadGroup.cleanUpThreadGroups();
        }
    }

    private void stopDistributedSystem() {
        try {
            this.disconnectFromSystem();
        }
        catch (Exception exception) {
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error e) {
            SystemFailure.checkFailure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName manageDistributedSystem() throws MalformedObjectNameException {
        Object object = this.CONN_SYNC;
        synchronized (object) {
            if (this.isConnected()) {
                return ((AdminDistributedSystemJmxImpl)this.system).getObjectName();
            }
            return null;
        }
    }

    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This is only a style warning.")
    public ObjectName connectToSystem() throws AdminException, MalformedObjectNameException {
        Object object = this.CONN_SYNC;
        synchronized (object) {
            try {
                if (this.isConnected()) {
                    return ((AdminDistributedSystemJmxImpl)this.system).getObjectName();
                }
                ClusterDistributionManager.setIsDedicatedAdminVM(true);
                AdminDistributedSystemJmxImpl systemJmx = (AdminDistributedSystemJmxImpl)this.system;
                if (systemJmx == null) {
                    systemJmx = (AdminDistributedSystemJmxImpl)this.createDistributedSystem(this.agentConfig);
                    this.system = systemJmx;
                }
                systemJmx.connect(this.logWriter);
                return new ObjectName(systemJmx.getMBeanName());
            }
            catch (AdminException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This is only a style warning.")
    public void disconnectFromSystem() {
        Object object = this.CONN_SYNC;
        synchronized (object) {
            try {
                if (this.system == null || !this.system.isConnected()) {
                    return;
                }
                ((AdminDistributedSystemJmxImpl)this.system).disconnect();
            }
            catch (RuntimeException e) {
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                logger.warn(e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                ClusterDistributionManager.setIsDedicatedAdminVM(false);
            }
        }
    }

    public String getLog() {
        String childTail = this.tailFile(this.logWriterAppender.getChildLogFile());
        String mainTail = this.tailFile(new File(this.agentConfig.getLogFile()));
        if (childTail == null && mainTail == null) {
            return LocalizedStrings.AgentImpl_NO_LOG_FILE_CONFIGURED_LOG_MESSAGES_WILL_BE_DIRECTED_TO_STDOUT.toLocalizedString();
        }
        StringBuffer result = new StringBuffer();
        if (mainTail != null) {
            result.append(mainTail);
        }
        if (childTail != null) {
            result.append("\n" + LocalizedStrings.AgentImpl_TAIL_OF_CHILD_LOG.toLocalizedString() + "\n");
            result.append(childTail);
        }
        return result.toString();
    }

    public String getVersion() {
        return GemFireVersion.asString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        boolean result = false;
        Object object = this.CONN_SYNC;
        synchronized (object) {
            result = this.system != null && this.system.isConnected();
        }
        return result;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(String value) {
        File f = new File(value).getAbsoluteFile();
        if (f.isDirectory()) {
            throw new IllegalArgumentException(LocalizedStrings.AgentImpl_THE_FILE_0_IS_A_DIRECTORY.toLocalizedString(f));
        }
        File parent = f.getParentFile();
        if (parent != null && !parent.isDirectory()) {
            throw new IllegalArgumentException(LocalizedStrings.AgentImpl_THE_DIRECTORY_0_DOES_NOT_EXIST.toLocalizedString(parent));
        }
        this.propertyFile = f.getPath();
    }

    public String getMcastAddress() {
        return this.agentConfig.getMcastAddress();
    }

    public void setMcastAddress(String mcastAddress) {
        this.agentConfig.setMcastAddress(mcastAddress);
    }

    public int getMcastPort() {
        return this.agentConfig.getMcastPort();
    }

    public void setMcastPort(int mcastPort) {
        this.agentConfig.setMcastPort(mcastPort);
    }

    public String getLocators() {
        return this.agentConfig.getLocators();
    }

    public void setLocators(String locators) {
        this.agentConfig.setLocators(locators);
    }

    public String getMembershipPortRange() {
        return this.agentConfig.getMembershipPortRange();
    }

    public void setMembershipPortRange(String membershipPortRange) {
        this.agentConfig.setMembershipPortRange(membershipPortRange);
    }

    public String getBindAddress() {
        return this.agentConfig.getBindAddress();
    }

    public void setBindAddress(String bindAddress) {
        this.agentConfig.setBindAddress(bindAddress);
    }

    public String getRemoteCommand() {
        return this.agentConfig.getRemoteCommand();
    }

    public void setRemoteCommand(String remoteCommand) {
        this.agentConfig.setRemoteCommand(remoteCommand);
    }

    public String getSystemId() {
        return this.agentConfig.getSystemId();
    }

    public void setSystemId(String systemId) {
        this.agentConfig.setSystemId(systemId);
    }

    public int getLogFileSizeLimit() {
        return this.agentConfig.getLogFileSizeLimit();
    }

    public void setLogFileSizeLimit(int logFileSizeLimit) {
        this.agentConfig.setLogFileSizeLimit(logFileSizeLimit);
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    public int getLogDiskSpaceLimit() {
        return this.agentConfig.getLogDiskSpaceLimit();
    }

    public void setLogDiskSpaceLimit(int logDiskSpaceLimit) {
        this.agentConfig.setLogDiskSpaceLimit(logDiskSpaceLimit);
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    public String getLogFile() {
        return this.agentConfig.getLogFile();
    }

    public void setLogFile(String logFile) {
        this.agentConfig.setLogFile(logFile);
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    public String getLogLevel() {
        return this.agentConfig.getLogLevel();
    }

    public void setLogLevel(String logLevel) {
        this.agentConfig.setLogLevel(logLevel);
        LogWriterAppenders.configChanged(LogWriterAppenders.Identifier.MAIN);
    }

    public boolean getAutoConnect() {
        return this.agentConfig.getAutoConnect();
    }

    public boolean isAutoConnect() {
        return this.agentConfig.getAutoConnect();
    }

    public void setAutoConnect(boolean v) {
        this.agentConfig.setAutoConnect(v);
    }

    public JMXServiceURL getRMIAddress() {
        if (this.rmiConnector != null) {
            return this.rmiConnector.getAddress();
        }
        return null;
    }

    protected AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    private String tailFile(File f) {
        try {
            return TailLogResponse.tailSystemLog(f);
        }
        catch (IOException ex) {
            return LocalizedStrings.AgentImpl_COULD_NOT_TAIL_0_BECAUSE_1.toLocalizedString(f, ex);
        }
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    @Override
    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    private void addShutdownHook() {
        if (!Boolean.getBoolean("gemfire.disableShutdownHook")) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    private void removeShutdownHook() {
        if (!Boolean.getBoolean("gemfire.disableShutdownHook")) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Return value for file delete is not important here.")
    private void initLogWriter() throws AdminException {
        LogConfig logConfig = this.agentConfig.createLogConfig();
        this.logWriterAppender = LogWriterAppenders.getOrCreateAppender(LogWriterAppenders.Identifier.MAIN, false, logConfig, false);
        InternalLogWriter existingLogWriter = this.agentConfig.getInternalLogWriter();
        if (existingLogWriter != null) {
            this.logWriter = existingLogWriter;
        } else {
            this.logWriter = LogWriterFactory.createLogWriterLogger(false, false, logConfig, false);
            this.logWriter.info(Banner.getString(null));
            this.agentConfig.setInternalLogWriter(this.logWriter);
        }
        this.logWriter = LogWriterFactory.createLogWriterLogger(false, false, logConfig, false);
        this.agentConfig.setInternalLogWriter(this.logWriter);
        logger.info(Banner.getString(this.agentConfig.getOriginalArgs()));
        logger.info(LogMarker.CONFIG, LocalizedStrings.AgentImpl_AGENT_CONFIG_PROPERTY_FILE_NAME_0.toLocalizedString(AgentConfigImpl.retrievePropertyFile()));
        logger.info(LogMarker.CONFIG, this.agentConfig.getPropertyFileDescription());
        logger.info(LogMarker.CONFIG, this.agentConfig.toPropertiesAsString());
    }

    private void stopHttpAdaptor() {
        if (!this.agentConfig.isHttpEnabled()) {
            return;
        }
        try {
            this.httpAdaptor.stop();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            MBeanUtil.unregisterMBean(this.getHttpAdaptorName());
            MBeanUtil.unregisterMBean(this.getXsltProcessorName());
        }
        catch (MalformedObjectNameException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void stopRMIConnectorServer() {
        if (!this.agentConfig.isRmiEnabled()) {
            return;
        }
        try {
            this.rmiConnector.stop();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            ObjectName rmiRegistryNamingName = this.getRMIRegistryNamingName();
            if (this.agentConfig.isRmiRegistryEnabled() && this.mBeanServer.isRegistered(rmiRegistryNamingName)) {
                Object[] empty = new String[]{};
                this.mBeanServer.invoke(rmiRegistryNamingName, "stop", empty, (String[])empty);
                MBeanUtil.unregisterMBean(rmiRegistryNamingName);
            }
        }
        catch (MalformedObjectNameException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (ReflectionException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (MBeanException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            ObjectName rmiConnectorServerName = this.getRMIConnectorServerName();
            if (this.mBeanServer.isRegistered(rmiConnectorServerName)) {
                MBeanUtil.unregisterMBean(rmiConnectorServerName);
            }
        }
        catch (MalformedObjectNameException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void stopSnmpAdaptor() {
        if (!this.agentConfig.isSnmpEnabled()) {
            return;
        }
        try {
            this.getMBeanServer().invoke(this.getSnmpAdaptorName(), "unbind", new Object[0], new String[0]);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            MBeanUtil.unregisterMBean(this.getSnmpAdaptorName());
        }
        catch (MalformedObjectNameException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private ObjectName getRMIRegistryNamingName() throws MalformedObjectNameException {
        return ObjectName.getInstance("naming:type=rmiregistry");
    }

    private ObjectName getHttpAdaptorName() throws MalformedObjectNameException {
        return new ObjectName("Server:name=HttpAdaptor");
    }

    private ObjectName getRMIConnectorServerName() throws MalformedObjectNameException {
        return new ObjectName("connectors:protocol=rmi");
    }

    private ObjectName getSnmpAdaptorName() throws MalformedObjectNameException {
        return new ObjectName("Adaptors:protocol=SNMP");
    }

    private ObjectName getXsltProcessorName() throws MalformedObjectNameException {
        return new ObjectName("Server:name=XSLTProcessor");
    }

    private AdminDistributedSystem createDistributedSystem(AgentConfigImpl config) throws AdminException {
        return new AdminDistributedSystemJmxImpl(config);
    }

    public static void main(String[] args) {
        AgentConfigImpl ac;
        SystemFailure.loadEmergencyClasses();
        try {
            ac = new AgentConfigImpl(args);
        }
        catch (RuntimeException ex) {
            System.err.println(LocalizedStrings.AgentImpl_FAILED_READING_CONFIGURATION_0.toLocalizedString(ex));
            ExitCode.FATAL.doSystemExit();
            return;
        }
        try {
            Agent agent = AgentFactory.getAgent(ac);
            agent.start();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            ExitCode.FATAL.doSystemExit();
        }
    }

    private void createRMIRegistry() throws Exception {
        if (!this.agentConfig.isRmiRegistryEnabled()) {
            return;
        }
        MBeanServer mbs = this.getMBeanServer();
        String host = this.agentConfig.getRmiBindAddress();
        int port = this.agentConfig.getRmiPort();
        ObjectName registryName = this.getRMIRegistryNamingName();
        try {
            RMIRegistryService registryNamingService = null;
            registryNamingService = host != null && !"".equals(host.trim()) ? new RMIRegistryService(host, port) : new RMIRegistryService(port);
            mbs.registerMBean(registryNamingService, registryName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_0__IS_ALREADY_REGISTERED, registryName));
        }
        mbs.invoke(registryName, "start", null, null);
    }

    private void startRMIConnectorServer() {
        if (!this.agentConfig.isRmiEnabled()) {
            return;
        }
        String rmiBindAddress = this.agentConfig.getRmiBindAddress();
        String rmiStubServerNameKey = "java.rmi.server.hostname";
        String overrideHostName = System.getProperty(rmiStubServerNameKey);
        if ((overrideHostName == null || overrideHostName.trim().length() == 0) && rmiBindAddress != null && rmiBindAddress.trim().length() != 0) {
            System.setProperty(rmiStubServerNameKey, rmiBindAddress);
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_SETTING_0, new StringBuilder(rmiStubServerNameKey).append(" = ").append(rmiBindAddress)));
        }
        try {
            this.createRMIRegistry();
            ObjectName objName = this.getRMIConnectorServerName();
            if (this.getMBeanServer().isRegistered(objName)) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_RMICONNECTORSERVER_ALREADY_REGISTERED_AS__0, objName));
                return;
            }
            String urlString = null;
            String connectorServerHost = "";
            int connectorServerPort = this.agentConfig.getRmiServerPort();
            String rmiRegistryHost = "";
            int rmiRegistryPort = this.agentConfig.getRmiPort();
            if (rmiBindAddress == null || rmiBindAddress.trim().length() == 0) {
                connectorServerHost = "localhost";
                rmiRegistryHost = "";
            } else {
                rmiRegistryHost = connectorServerHost = AgentImpl.applyRFC2732(rmiBindAddress);
            }
            urlString = MessageFormat.format(JMX_SERVICE_URL, connectorServerHost, String.valueOf(connectorServerPort), rmiRegistryHost, String.valueOf(rmiRegistryPort), "/jmxconnector");
            logger.debug("JMX Service URL string is : \"{}\"", (Object)urlString);
            JMXServiceURL url = new JMXServiceURL(urlString);
            HashMap<String, Object> env = new HashMap<String, Object>();
            MX4JServerSocketFactory ssf = new MX4JServerSocketFactory(this.agentConfig.isAgentSSLEnabled(), this.agentConfig.isAgentSSLRequireAuth(), this.agentConfig.getAgentSSLProtocols(), this.agentConfig.getAgentSSLCiphers(), this.agentConfig.getRmiBindAddress(), 10, this.agentConfig.getGfSecurityProperties());
            env.put("jmx.remote.rmi.server.socket.factory", ssf);
            if (this.agentConfig.isAgentSSLEnabled()) {
                SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                env.put("jmx.remote.rmi.client.socket.factory", csf);
            }
            MBeanServer mbs = null;
            this.rmiConnector = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            this.rmiConnector.addNotificationListener(new ConnectionNotificationAdapter(), new ConnectionNotificationFilterImpl(), this);
            this.getMBeanServer().registerMBean(this.rmiConnector, objName);
            this.rmiConnector.start();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.error((Object)LocalizedStrings.AgentImpl_FAILED_TO_START_RMICONNECTORSERVER, t);
            throw new StartupException(LocalizedStrings.AgentImpl_FAILED_TO_START_RMI_SERVICE.toLocalizedString(), t);
        }
    }

    private void startSnmpAdaptor() {
        if (!this.agentConfig.isSnmpEnabled()) {
            return;
        }
        try {
            ObjectName objName = this.getSnmpAdaptorName();
            if (this.getMBeanServer().isRegistered(objName)) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_SNMPADAPTOR_ALREADY_REGISTERED_AS__0, objName));
                return;
            }
            String className = "com.adventnet.adaptors.snmp.snmpsupport.SmartSnmpAdaptor";
            String snmpDir = this.agentConfig.getSnmpDirectory();
            if (snmpDir == null || snmpDir.length() == 0) {
                throw new IllegalArgumentException(LocalizedStrings.AgentImpl_SNMPDIRECTORY_MUST_BE_SPECIFIED_BECAUSE_SNMP_IS_ENABLED.toLocalizedString());
            }
            File root = new File(snmpDir);
            if (!root.exists()) {
                throw new IllegalArgumentException(LocalizedStrings.AgentImpl_SNMPDIRECTORY_DOES_NOT_EXIST.toLocalizedString());
            }
            String[] sigs = new String[]{"java.lang.String"};
            Object[] args = new Object[]{snmpDir};
            String bindAddress = this.agentConfig.getSnmpBindAddress();
            if (bindAddress != null && bindAddress.length() > 0) {
                sigs = new String[]{"java.lang.String", sigs[0]};
                args = new Object[]{bindAddress, args[0]};
            }
            this.getMBeanServer().createMBean(className, objName, args, sigs);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_FAILED_TO_START_SNMPADAPTOR__0, t.getMessage()));
            throw new StartupException(LocalizedStrings.AgentImpl_FAILED_TO_START_SNMPADAPTOR__0.toLocalizedString(t.getMessage()), t);
        }
    }

    private void startHttpAdaptor() {
        if (!this.agentConfig.isHttpEnabled()) {
            return;
        }
        try {
            ObjectName objName = this.getHttpAdaptorName();
            if (this.getMBeanServer().isRegistered(objName)) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_HTTPADAPTOR_ALREADY_REGISTERED_AS__0, objName));
                return;
            }
            this.httpAdaptor = new HttpAdaptor();
            if (this.agentConfig.getHttpPort() > 0) {
                this.httpAdaptor.setPort(this.agentConfig.getHttpPort());
                logger.info(LogMarker.CONFIG, (Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_HTTP_ADAPTOR_LISTENING_ON_PORT__0, this.agentConfig.getHttpPort()));
            } else {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_INCORRECT_PORT_VALUE__0, this.agentConfig.getHttpPort()));
            }
            if (this.agentConfig.getHttpBindAddress() != null) {
                String host = this.agentConfig.getHttpBindAddress();
                logger.info(LogMarker.CONFIG, (Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_HTTP_ADAPTOR_LISTENING_ON_ADDRESS__0, host));
                this.httpAdaptor.setHost(host);
            } else {
                logger.error((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_INCORRECT_NULL_HOSTNAME));
            }
            MX4JServerSocketFactory socketFactory = new MX4JServerSocketFactory(this.agentConfig.isAgentSSLEnabled(), this.agentConfig.isHttpSSLRequireAuth(), this.agentConfig.getAgentSSLProtocols(), this.agentConfig.getAgentSSLCiphers(), this.agentConfig.getGfSecurityProperties());
            this.httpAdaptor.setSocketFactory((AdaptorServerSocketFactory)socketFactory);
            if (this.agentConfig.isHttpAuthEnabled()) {
                this.httpAdaptor.setAuthenticationMethod(MX4J_HTTPADAPTOR_BASIC_AUTHENTICATION);
                this.httpAdaptor.addAuthorization(this.agentConfig.getHttpAuthUser(), this.agentConfig.getHttpAuthPassword());
            }
            this.httpAdaptor.setProcessorName(this.createXsltProcessor());
            this.getMBeanServer().registerMBean(this.httpAdaptor, objName);
            this.httpAdaptor.start();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.error((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_FAILED_TO_START_HTTPADAPTOR__0, t.getMessage()));
            throw new StartupException(LocalizedStrings.AgentImpl_FAILED_TO_START_HTTPADAPTOR__0.toLocalizedString(t.getMessage()), t);
        }
    }

    private ObjectName createXsltProcessor() throws JMException {
        ObjectName objName = this.getXsltProcessorName();
        if (this.getMBeanServer().isRegistered(objName)) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.AgentImpl_XSLTPROCESSOR_ALREADY_REGISTERED_AS__0, objName));
            return objName;
        }
        this.getMBeanServer().registerMBean(new XSLTProcessor(), objName);
        return objName;
    }

    public boolean isSSLEnabled() {
        return this.agentConfig.isSSLEnabled();
    }

    public void setSSLEnabled(boolean enabled) {
        this.agentConfig.setSSLEnabled(enabled);
    }

    public String getSSLProtocols() {
        return this.agentConfig.getSSLProtocols();
    }

    public void setSSLProtocols(String protocols) {
        this.agentConfig.setSSLProtocols(protocols);
    }

    public String getSSLCiphers() {
        return this.agentConfig.getSSLCiphers();
    }

    public void setSSLCiphers(String ciphers) {
        this.agentConfig.setSSLCiphers(ciphers);
    }

    public boolean isSSLAuthenticationRequired() {
        return this.agentConfig.isSSLAuthenticationRequired();
    }

    public void setSSLAuthenticationRequired(boolean authRequired) {
        this.agentConfig.setSSLAuthenticationRequired(authRequired);
    }

    public Properties getSSLProperties() {
        return this.agentConfig.getSSLProperties();
    }

    public void setSSLProperties(Properties sslProperties) {
        this.agentConfig.setSSLProperties(sslProperties);
    }

    public void addSSLProperty(String key, String value) {
        this.agentConfig.addSSLProperty(key, value);
    }

    public void removeSSLProperty(String key) {
        this.agentConfig.removeSSLProperty(key);
    }

    @Override
    public String getMBeanName() {
        return this.mbeanName;
    }

    @Override
    public ModelMBean getModelMBean() {
        return this.modelMBean;
    }

    @Override
    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public ManagedResourceType getManagedResourceType() {
        return ManagedResourceType.AGENT;
    }

    @Override
    public void cleanupResource() {
    }

    void updateRmiClientsCount() {
        int noOfClientsConnected = 0;
        String[] connectionIds = this.rmiConnector.getConnectionIds();
        if (connectionIds != null) {
            noOfClientsConnected = connectionIds.length;
        }
        logger.info("No. of RMI clients connected :: {}", (Object)noOfClientsConnected);
        AdminDistributedSystemJmxImpl adminDSJmx = (AdminDistributedSystemJmxImpl)this.system;
        adminDSJmx.setRmiClientCountZero(noOfClientsConnected == 0);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AgentImpl[");
        sb.append("config=" + this.agentConfig.toProperties().toString());
        sb.append("; mbeanName=" + this.mbeanName);
        sb.append("; modelMBean=" + this.modelMBean);
        sb.append("; objectName=" + this.objectName);
        sb.append("; propertyFile=" + this.propertyFile);
        sb.append(": rmiConnector=" + this.rmiConnector);
        sb.append("]");
        return sb.toString();
    }

    private static String applyRFC2732(String hostname) {
        if (hostname.indexOf(":") != -1) {
            return "[" + hostname + "]";
        }
        return hostname;
    }

    static {
        AgentImpl.checkDebug();
        String commonsLog = System.getProperty("org.apache.commons.logging.log");
        if (commonsLog == null || commonsLog.length() == 0) {
            System.setProperty("org.apache.commons.logging.log", "org.apache.commons.logging.impl.SimpleLog");
        }
    }

    static class StartupException
    extends GemFireException {
        private static final long serialVersionUID = 6614145962199330348L;

        StartupException(Throwable cause) {
            super(cause);
        }

        StartupException(String reason, Throwable cause) {
            super(reason, cause);
        }
    }
}

