/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Region;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.internal.cache.PartitionedRegion;

public class RegionSubRegionSnapshot
implements DataSerializable {
    private static final long serialVersionUID = -8052137675270041871L;
    protected String name;
    protected int entryCount;
    protected RegionSubRegionSnapshot parent = null;
    protected Set subRegionSnapshots = new HashSet();

    public RegionSubRegionSnapshot() {
    }

    public RegionSubRegionSnapshot(Region reg) {
        this();
        this.name = reg.getName();
        if (reg instanceof PartitionedRegion) {
            PartitionedRegion p_reg = (PartitionedRegion)reg;
            this.entryCount = p_reg.entryCount(true);
        } else {
            this.entryCount = reg.entrySet().size();
        }
        LogWriterI18n logger = reg.getCache().getLoggerI18n();
        if (logger != null && logger.fineEnabled()) {
            logger.fine("RegionSubRegionSnapshot Region entry count =" + this.entryCount + " for region =" + this.name);
        }
    }

    public boolean addSubRegion(RegionSubRegionSnapshot snap) {
        if (this.subRegionSnapshots.contains(snap)) {
            return true;
        }
        if (this.subRegionSnapshots.add(snap)) {
            snap.setParent(this);
            return true;
        }
        return false;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(int entryCount) {
        this.entryCount = entryCount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set getSubRegionSnapshots() {
        return this.subRegionSnapshots;
    }

    public void setSubRegionSnapshots(Set subRegionSnapshots) {
        this.subRegionSnapshots = subRegionSnapshots;
    }

    public RegionSubRegionSnapshot getParent() {
        return this.parent;
    }

    public void setParent(RegionSubRegionSnapshot parent) {
        this.parent = parent;
    }

    public String getFullPath() {
        return (this.getParent() == null ? "/" : this.getParent().getFullPath()) + this.getName() + "/";
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.name, out);
        out.writeInt(this.entryCount);
        DataSerializer.writeHashSet((HashSet)this.subRegionSnapshots, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readString(in);
        this.entryCount = in.readInt();
        this.subRegionSnapshots = DataSerializer.readHashSet(in);
        Iterator iter = this.subRegionSnapshots.iterator();
        while (iter.hasNext()) {
            ((RegionSubRegionSnapshot)iter.next()).setParent(this);
        }
    }

    public String toString() {
        String toStr = "RegionSnapshot [path=" + this.getFullPath() + ",parent=" + (this.parent == null ? "null" : this.parent.name) + ", entryCount=" + this.entryCount + ", subRegionCount=" + this.subRegionSnapshots.size() + "<<";
        Iterator iter = this.subRegionSnapshots.iterator();
        while (iter.hasNext()) {
            toStr = toStr + ((RegionSubRegionSnapshot)iter.next()).getName() + ", ";
        }
        toStr = toStr + ">>]";
        return toStr;
    }
}

