/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.modules.session.catalina;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

import org.apache.catalina.Session;
import org.apache.catalina.session.ManagerBase;

import org.apache.geode.cache.Region;
import org.apache.geode.modules.session.catalina.internal.DeltaSessionAttributeEvent;

public interface DeltaSessionInterface extends Session {

  void commit();

  void abort();

  boolean isValid();

  void localDestroyAttribute(String name);

  void applyAttributeEvents(Region<String, DeltaSessionInterface> region,
      List<DeltaSessionAttributeEvent> events);

  void localUpdateAttribute(String attributeName, Object attributeValue);

  void toData(DataOutput os) throws IOException;

  void fromData(DataInput is) throws IOException, ClassNotFoundException;

  String getContextName();

  boolean getExpired();

  void setOwner(Object manager);

  void activate();

  void processExpired();
}
