/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.connectors.jdbc.internal.SqlHandler;

class TableKeyColumnManager {
    private final ConcurrentMap<String, String> tableToPrimaryKeyMap = new ConcurrentHashMap<String, String>();

    TableKeyColumnManager() {
    }

    public String getKeyColumnName(Connection connection, String tableName) {
        return this.tableToPrimaryKeyMap.computeIfAbsent(tableName, k -> this.computeKeyColumnName(connection, (String)k));
    }

    private String computeKeyColumnName(Connection connection, String tableName) {
        String key = null;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            try (ResultSet tables = metaData.getTables(null, null, "%", null);){
                String realTableName = this.getTableNameFromMetaData(tableName, tables);
                key = this.getPrimaryKeyColumnNameFromMetaData(realTableName, metaData);
            }
        }
        catch (SQLException e) {
            SqlHandler.handleSQLException(e);
        }
        return key;
    }

    private String getTableNameFromMetaData(String tableName, ResultSet tables) throws SQLException {
        String realTableName = null;
        while (tables.next()) {
            String name = tables.getString("TABLE_NAME");
            if (!name.equalsIgnoreCase(tableName)) continue;
            if (realTableName != null) {
                throw new IllegalStateException("Duplicate tables that match region name");
            }
            realTableName = name;
        }
        if (realTableName == null) {
            throw new IllegalStateException("no table was found that matches " + tableName);
        }
        return realTableName;
    }

    private String getPrimaryKeyColumnNameFromMetaData(String tableName, DatabaseMetaData metaData) throws SQLException {
        ResultSet primaryKeys = metaData.getPrimaryKeys(null, null, tableName);
        if (!primaryKeys.next()) {
            throw new IllegalStateException("The table " + tableName + " does not have a primary key column.");
        }
        String key = primaryKeys.getString("COLUMN_NAME");
        if (primaryKeys.next()) {
            throw new IllegalStateException("The table " + tableName + " has more than one primary key column.");
        }
        return key;
    }
}

