/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.security;

import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authz.permission.WildcardPermission;

public class ResourcePermission
extends WildcardPermission {
    public static String ALL = "*";
    public static String ALL_REGIONS = "*";
    public static String ALL_KEYS = "*";
    private Resource resource = Resource.NULL;
    private Operation operation = Operation.NULL;
    private String target = ALL;
    private String key = ALL;

    public ResourcePermission() {
        this(Resource.NULL, Operation.NULL, ALL, ALL);
    }

    public ResourcePermission(String resource, String operation) {
        this(resource, operation, ALL, ALL);
    }

    public ResourcePermission(String resource, String operation, String target) {
        this(resource, operation, target, ALL);
    }

    public ResourcePermission(String resource, String operation, String target, String key) {
        this(resource == null ? Resource.NULL : Resource.valueOf(resource.toUpperCase()), operation == null ? Operation.NULL : Operation.valueOf(operation.toUpperCase()), target, key);
    }

    public ResourcePermission(Resource resource, Operation operation) {
        this(resource, operation, ALL, ALL);
    }

    public ResourcePermission(Resource resource, Operation operation, String target) {
        this(resource, operation, target, ALL);
    }

    public ResourcePermission(Resource resource, Operation operation, Target target) {
        this(resource, operation, target, ALL);
    }

    public ResourcePermission(Resource resource, Operation operation, Target target, String targetKey) {
        this(resource, operation, target.getName(), targetKey);
    }

    public ResourcePermission(Resource resource, Operation operation, String target, String key) {
        if (resource != null) {
            this.resource = resource;
        }
        if (operation != null) {
            this.operation = operation;
        }
        if (target != null) {
            this.target = StringUtils.stripStart((String)target, (String)"/");
        }
        if (key != null) {
            this.key = key;
        }
        this.setParts((Object)((Object)this.resource) + ":" + (Object)((Object)this.operation) + ":" + this.target + ":" + this.key, true);
    }

    public Resource getResource() {
        return this.resource;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getTarget() {
        return this.target;
    }

    public String getRegionName() {
        return this.getTarget();
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        if (ALL.equals(this.target)) {
            return (Object)((Object)this.getResource()) + ":" + (Object)((Object)this.getOperation());
        }
        if (ALL.equals(this.key)) {
            return (Object)((Object)this.resource) + ":" + (Object)((Object)this.operation) + ":" + this.target;
        }
        return (Object)((Object)this.resource) + ":" + (Object)((Object)this.operation) + ":" + this.target + ":" + this.key;
    }

    public static enum Target {
        ALL(ALL),
        DISK,
        GATEWAY,
        QUERY,
        DEPLOY;

        private String name;

        private Target() {
        }

        private Target(String name) {
            this.name = name;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return this.name();
        }
    }

    public static enum Operation {
        NULL,
        MANAGE,
        WRITE,
        READ;

    }

    public static enum Resource {
        NULL,
        CLUSTER,
        DATA;

    }
}

