/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class GetSetExecutor
extends StringExecutor {
    private final int VALUE_INDEX = 2;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GETSET command is \"GETSET key value\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        byte[] newCharValue = commandElems.get(2);
        ByteArrayWrapper newValueWrapper = new ByteArrayWrapper(newCharValue);
        ByteArrayWrapper oldValueWrapper = r.get(key);
        r.put(key, newValueWrapper);
        if (oldValueWrapper == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
        } else {
            command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), oldValueWrapper.toBytes()));
        }
    }
}

