/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.tcp.ByteBufferInputStream;
import org.apache.geode.pdx.PdxFieldAlreadyExistsException;
import org.apache.geode.pdx.PdxUnreadFields;
import org.apache.geode.pdx.internal.PdxField;
import org.apache.geode.pdx.internal.PdxReaderImpl;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.geode.pdx.internal.UnreadPdxType;

public class PdxUnreadData
implements PdxUnreadFields {
    private UnreadPdxType unreadType;
    private byte[][] unreadData;

    public PdxUnreadData() {
    }

    public PdxUnreadData(UnreadPdxType unreadType, PdxReaderImpl reader) {
        this.initialize(unreadType, reader);
    }

    public void initialize(UnreadPdxType unreadType, PdxReaderImpl reader) {
        this.unreadType = unreadType;
        int[] indexes = unreadType.getUnreadFieldIndexes();
        this.unreadData = new byte[indexes.length][];
        int i = 0;
        for (int idx : indexes) {
            ByteBufferInputStream.ByteSource field = reader.getRaw(idx);
            this.unreadData[i] = new byte[field.capacity()];
            field.position(0);
            field.get(this.unreadData[i]);
            ++i;
        }
    }

    public UnreadPdxType getUnreadType() {
        return this.unreadType;
    }

    public PdxType getSerializedType() {
        return this.getUnreadType().getSerializedType();
    }

    public void setSerializedType(PdxType t) {
        this.getUnreadType().setSerializedType(t);
    }

    public void sendTo(PdxWriterImpl writer) {
        if (this.isEmpty()) {
            return;
        }
        int[] indexes = this.unreadType.getUnreadFieldIndexes();
        for (int i = 0; i < this.unreadData.length; ++i) {
            int idx = indexes[i];
            byte[] data = this.unreadData[i];
            PdxField ft = this.unreadType.getPdxFieldByIndex(idx);
            try {
                writer.writeRawField(ft, data);
                continue;
            }
            catch (PdxFieldAlreadyExistsException ex) {
                throw new PdxFieldAlreadyExistsException("Check the toData and fromData for " + this.unreadType.getClassName() + " to see if the field \"" + ft.getFieldName() + "\" is spelled differently.");
            }
        }
    }

    public static void copy(Object o, Object copy) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return;
        }
        TypeRegistry tr = cache.getPdxRegistry();
        PdxUnreadData ud = tr.getUnreadData(o);
        if (ud != null && !ud.isEmpty()) {
            tr.putUnreadData(copy, ud);
        }
    }

    public boolean isEmpty() {
        return this.unreadData == null;
    }
}

