/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.configuration.messages.ConfigurationResponse;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;

public class GetClusterConfigurationFunction
implements Function {
    private static final Logger logger = LogService.getLogger();

    public void execute(FunctionContext context) {
        ClusterConfigurationService clusterConfigurationService = InternalLocator.getLocator().getSharedConfiguration();
        Set groups = (Set)context.getArguments();
        logger.info("Received request for configuration  : {}", (Object)groups);
        try {
            ConfigurationResponse response = clusterConfigurationService.createConfigurationResponse(groups);
            context.getResultSender().lastResult(response);
        }
        catch (IOException e) {
            logger.error("Unable to retrieve the cluster configuration", (Throwable)e);
            context.getResultSender().lastResult(e);
        }
    }

    @Override
    public Collection<ResourcePermission> getRequiredPermissions(String regionName) {
        return Stream.of(ResourcePermissions.DATA_READ, ResourcePermissions.DATA_WRITE, ResourcePermissions.DATA_MANAGE, ResourcePermissions.CLUSTER_READ, ResourcePermissions.CLUSTER_WRITE, ResourcePermissions.CLUSTER_MANAGE).collect(Collectors.toSet());
    }
}

