/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.functions;

import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class DownloadJarFunction
implements Function<Object[]>,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext<Object[]> context) {
        ClusterConfigurationService sharedConfig;
        InternalLocator locator = (InternalLocator)Locator.getLocator();
        Object[] args = context.getArguments();
        String group = (String)args[0];
        String jarName = (String)args[1];
        RemoteInputStream result = null;
        if (locator != null && group != null && jarName != null && (sharedConfig = locator.getSharedConfiguration()) != null) {
            try {
                File jarFile = sharedConfig.getPathToJarOnThisLocator(group, jarName).toFile();
                RemoteStreamExporter exporter = ((SystemManagementService)SystemManagementService.getExistingManagementService(context.getCache())).getManagementAgent().getRemoteStreamExporter();
                try (SimpleRemoteInputStream istream = null;){
                    istream = new SimpleRemoteInputStream((InputStream)new BufferedInputStream(new FileInputStream(jarFile)));
                    result = (RemoteInputStream)exporter.export((RemoteStreamServer)istream);
                    istream = null;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        context.getResultSender().lastResult(result);
    }

    @Override
    public String getId() {
        return DownloadJarFunction.class.getName();
    }
}

