/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.remote;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.geode.annotations.TestingOnly;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.SecurityServiceFactory;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.CommandProcessingException;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.remote.CommandExecutor;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.util.CommentSkipHelper;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.Parser;
import org.springframework.shell.event.ParseResult;
import org.springframework.util.StringUtils;

public class OnlineCommandProcessor {
    protected final CommandExecutor executor;
    private final GfshParser gfshParser;
    private final Object LOCK = new Object();
    private final SecurityService securityService;

    @TestingOnly
    public OnlineCommandProcessor() throws ClassNotFoundException, IOException {
        this(new Properties(), SecurityServiceFactory.create());
    }

    public OnlineCommandProcessor(Properties cacheProperties, SecurityService securityService) throws ClassNotFoundException, IOException {
        this(cacheProperties, securityService, new CommandExecutor());
    }

    @TestingOnly
    public OnlineCommandProcessor(Properties cacheProperties, SecurityService securityService, CommandExecutor commandExecutor) {
        this.gfshParser = new GfshParser(new CommandManager(cacheProperties));
        this.executor = commandExecutor;
        this.securityService = securityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandExecutor getCommandExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Parser getParser() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.gfshParser;
        }
    }

    public ParseResult parseCommand(String commentLessLine) throws CommandProcessingException, IllegalStateException {
        if (commentLessLine != null) {
            return this.getParser().parse(commentLessLine);
        }
        throw new IllegalStateException("Command String should not be null.");
    }

    public Result executeCommand(String command) {
        return this.executeCommand(command, Collections.emptyMap(), null);
    }

    public Result executeCommand(String command, Map<String, String> env) {
        return this.executeCommand(command, env, null);
    }

    public Result executeCommand(String command, Map<String, String> env, List<String> stagedFilePaths) {
        CliMetaData metaData;
        CommentSkipHelper commentSkipper = new CommentSkipHelper();
        String commentLessLine = commentSkipper.skipComments(command);
        if (StringUtils.isEmpty((Object)commentLessLine)) {
            return null;
        }
        CommandExecutionContext.setShellEnv(env);
        CommandExecutionContext.setFilePathToShell(stagedFilePaths);
        CommandExecutor commandExecutor = this.getCommandExecutor();
        ParseResult parseResult = this.parseCommand(commentLessLine);
        if (parseResult == null) {
            return ResultBuilder.createParsingErrorResult(command);
        }
        Method method = parseResult.getMethod();
        ResourceOperation resourceOperation = method.getAnnotation(ResourceOperation.class);
        if (resourceOperation != null) {
            this.securityService.authorize(resourceOperation.resource(), resourceOperation.operation(), resourceOperation.target(), ResourcePermission.ALL);
        }
        if ((metaData = method.getAnnotation(CliMetaData.class)) != null && metaData.isFileUploaded() && stagedFilePaths == null) {
            return ResultBuilder.createUserErrorResult(command + " can not be executed only from server side");
        }
        return (Result)commandExecutor.execute(parseResult);
    }
}

