/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class UserFunctionExecution
implements Function,
InternalEntity {
    public static final String ID = UserFunctionExecution.class.getName();
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext context) {
        try {
            Cache cache = context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            String[] functionArgs = null;
            Object[] args = (Object[])context.getArguments();
            if (args == null) {
                context.getResultSender().lastResult("Could not retrieve arguments");
                return;
            }
            String functionId = (String)args[0];
            String filterString = (String)args[1];
            String resultCollectorName = (String)args[2];
            String argumentsString = (String)args[3];
            String onRegion = (String)args[4];
            Properties credentials = (Properties)args[5];
            SecurityService securityService = ((InternalCache)context.getCache()).getSecurityService();
            try {
                Function function;
                securityService.login(credentials);
                if (argumentsString != null && argumentsString.length() > 0) {
                    functionArgs = argumentsString.split(",");
                }
                HashSet<String> filters = new HashSet<String>();
                ResultCollector resultCollectorInstance = null;
                if (resultCollectorName != null && resultCollectorName.length() > 0) {
                    resultCollectorInstance = (ResultCollector)ClassPathLoader.getLatest().forName(resultCollectorName).newInstance();
                }
                if (filterString != null && filterString.length() > 0) {
                    filters.add(filterString);
                }
                if ((function = FunctionService.getFunction(functionId)) == null) {
                    context.getResultSender().lastResult(CliStrings.format("Function : {0} is not registered on member.", (Object)functionId));
                    return;
                }
                function.getRequiredPermissions(onRegion).forEach(securityService::authorize);
                Execution execution = null;
                if (onRegion != null && onRegion.length() > 0) {
                    Region region = cache.getRegion(onRegion);
                    if (region == null) {
                        context.getResultSender().lastResult(onRegion + "does not exist.");
                        return;
                    }
                    execution = FunctionService.onRegion(region);
                } else {
                    execution = FunctionService.onMember(member);
                }
                if (execution == null) {
                    context.getResultSender().lastResult(CliStrings.format("While executing function : {0} on member : {1} one region : {2} error occurred : {3}", functionId, member.getId(), onRegion, "Could not retrieve executor"));
                    return;
                }
                if (resultCollectorInstance != null) {
                    execution = execution.withCollector(resultCollectorInstance);
                }
                if (functionArgs != null && functionArgs.length > 0) {
                    execution = execution.setArguments(functionArgs);
                }
                if (filters.size() > 0) {
                    execution = execution.withFilter(filters);
                }
                List results = (List)execution.execute(function).getResult();
                StringBuilder resultMessage = new StringBuilder();
                if (results != null) {
                    for (Object resultObj : results) {
                        if (resultObj == null) continue;
                        if (resultObj instanceof String) {
                            resultMessage.append((String)resultObj);
                            resultMessage.append(GfshParser.LINE_SEPARATOR);
                            continue;
                        }
                        if (resultObj instanceof Exception) {
                            resultMessage.append(((IllegalArgumentException)resultObj).getMessage());
                            continue;
                        }
                        resultMessage.append(resultObj);
                        resultMessage.append(GfshParser.LINE_SEPARATOR);
                    }
                }
                context.getResultSender().lastResult(resultMessage);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                context.getResultSender().lastResult(CliStrings.format("ResultCollector : {0} not found. Error : {1}", resultCollectorName, e.getMessage()));
            }
            catch (Exception e) {
                context.getResultSender().lastResult(CliStrings.format("While executing function : {0} on member : {1} error occurred : {2}", functionId, member.getId(), e.getMessage()));
            }
            finally {
                securityService.logout();
            }
        }
        catch (Exception ex) {
            context.getResultSender().lastResult(ex.getMessage());
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

